/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryViewTask
extends ImmoToolTask<CalendarEntryViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryViewTask.class);
    private final long entryId;
    private boolean selectCreatedTab;
    private final CalendarEntryViewPanel viewTab;
    private final AbstractDbDriver dbDriver;

    public CalendarEntryViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public CalendarEntryViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading calendar entry {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.entryId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public CalendarEntryViewTask(AbstractDbDriver abstractDbDriver, long l, CalendarEntryViewPanel calendarEntryViewPanel) {
        super(I18N.tr("Loading calendar entry {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.entryId = l;
        this.selectCreatedTab = true;
        this.viewTab = calendarEntryViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CalendarEntryViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(CalendarEntryViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    CalendarEntryViewPanel calendarEntryViewPanel = (CalendarEntryViewPanel)abstractMainTab;
                    if (this.entryId < 1L && calendarEntryViewPanel.getCurrentEntryId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)calendarEntryViewPanel));
                        return null;
                    }
                    if (this.entryId <= 0L || calendarEntryViewPanel.getCurrentEntryId() != this.entryId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)calendarEntryViewPanel));
                    return null;
                }
            }
            if (this.entryId < 1L) {
                return this.viewTab != null ? this.viewTab : CalendarEntryViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbCalendarEntry dbCalendarEntry = dbCalendarHandler.getEntry(connection2, this.entryId);
                if (dbCalendarEntry == null) {
                    throw new Exception("Can't load calendar entry #" + this.entryId + "!");
                }
                if (this.viewTab == null) {
                    object = CalendarEntryViewPanel.createTab(dbCalendarEntry);
                    break block8;
                }
                object = this.viewTab;
                ((CalendarEntryViewPanel)((Object)object)).setEntry(dbCalendarEntry);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load calendar entry!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
        super.succeeded((Object)calendarEntryViewPanel);
        if (calendarEntryViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)calendarEntryViewPanel, (boolean)this.selectCreatedTab);
            }
            calendarEntryViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

