/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarExtension;
import com.openindex.openestate.tool.extensions.ProjectAdapter;
import java.io.IOException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarProjectExtension
extends ProjectAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarProjectExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarProjectExtension.class);

    public void close(ImmoToolProject immoToolProject) throws ImmoToolException {
        CalendarPlugin.unloadSettings();
        CalendarPlugin.setDbCalendarExtension(null);
    }

    public void open(ImmoToolProject immoToolProject) throws ImmoToolException {
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(immoToolProject);
        if (dbCalendarExtension == null) {
            throw new ImmoToolException("Can't find a usable DbCalendarExtension!");
        }
        CalendarPlugin.setDbCalendarExtension(dbCalendarExtension);
        try {
            CalendarPlugin.loadSettings(immoToolProject);
        }
        catch (SQLException sQLException) {
            throw new ImmoToolException("Can't load calendar settings!", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new ImmoToolException("Can't load calendar settings!", (Throwable)iOException);
        }
    }
}

