-- -----------------------------------------------------
-- Calendar-Addon for OpenEstate-ImmoTool
-- update 8 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'can_read_immotool_calendar_groups'
-- Add function 'can_read_immotool_calendar_entries'
-- Update function 'can_delete_immotool_calendar_groups'
-- Update function 'can_write_immotool_calendar_groups'
-- Update function 'can_delete_immotool_calendar_entries'
-- Update function 'can_write_immotool_calendar_entries'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Function can_read_immotool_calendar_groups
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_calendar_groups( val_group_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_calendar_groups
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_calendar_groups
      WHERE group_id = val_group_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_calendar_entries
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_calendar_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_calendar_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE entry_group_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Kalender-Gruppe ermitteln
    SELECT group_id
      INTO entry_group_id
      FROM immotool_calendar_entries
      WHERE entry_id = val_entry_id;

    -- Zum Lesen eines Kalender-Eintrages müssen Leserechte auf der Kalender-Gruppe vorliegen
    RETURN can_read_immotool_calendar_groups( entry_group_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_calendar_groups
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE can_delete_immotool_calendar_groups
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_calendar_groups
      WHERE group_id = val_group_id;

    RETURN can_delete( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_calendar_groups
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE can_write_immotool_calendar_groups
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_calendar_groups
      WHERE group_id = val_group_id;

    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_calendar_entries
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE can_delete_immotool_calendar_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE entry_group_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Kalender-Gruppe ermitteln
    SELECT group_id
      INTO entry_group_id
      FROM immotool_calendar_entries
      WHERE entry_id = val_entry_id;

    -- Zum Löschen eines Kalender-Eintrages müssen Schreibrechte auf der Kalender-Gruppe vorliegen
    RETURN can_write_immotool_calendar_groups( entry_group_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_calendar_entries
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE can_write_immotool_calendar_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE entry_group_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Kalender-Gruppe ermitteln
    SELECT group_id
      INTO entry_group_id
      FROM immotool_calendar_entries
      WHERE entry_id = val_entry_id;

    -- Zum Schreiben eines Kalender-Eintrages müssen Schreibrechte auf der Kalender-Gruppe vorliegen
    RETURN can_write_immotool_calendar_groups( entry_group_id );
  END;
.;
