/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.news.db.DbNewsUpdateListener;
import com.openindex.openestate.tool.news.db.hsql.HSqlDbNewsHandler;
import com.openindex.openestate.tool.news.extensions.DbNewsAdapter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbNewsExtension
extends DbNewsAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbNewsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbNewsExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/news/db/hsql/resources/";
    private static final DbNewsHandler NEWS_HANDLER = new HSqlDbNewsHandler();

    @Override
    public DbNewsHandler getNewsHandler() {
        return NEWS_HANDLER;
    }

    @Override
    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_news_entries", "remove_immotool_news_feeds", "save_immotool_news_entries", "save_immotool_news_feeds"};
    }

    @Override
    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_news_entries", "view_immotool_news_feeds"};
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbNewsExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new NewsUpdateHandler(string, new DbNewsUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbNewsExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbNewsExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbNewsExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbNewsExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_news_feeds");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_news_feeds");
    }

    private static final class NewsUpdateHandler
    extends HSqlDbUpdateHandler {
        public NewsUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-News", DbUpdateHandlerImpl.Type.PLUGIN, NewsPlugin.getInstance().getApiVersion(), string, HSqlDbNewsExtension.RESOURCE_PATH, NewsPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 8L && Locale.getDefault().getLanguage().equalsIgnoreCase("de")) {
                try {
                    DbNewsFeed dbNewsFeed = new DbNewsFeed();
                    dbNewsFeed.isArchived = true;
                    dbNewsFeed.isUpdateEnabled = true;
                    dbNewsFeed.name = "ImmobilienDiskussion.de";
                    dbNewsFeed.url = new URI("https://immobiliendiskussion.de/news/feed/rss/");
                    dbNewsFeed.updateInterval = 900000L;
                    new HSqlDbNewsHandler().saveFeed(connection, dbNewsFeed);
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't create feed for immobiliendiskussion.de!");
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
            }
            if (l < 7L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_news_feeds");
            }
            if (l < 7L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_news_feeds");
            }
        }
    }
}

