/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.news.NewsPluginUtils;
import com.openindex.openestate.tool.news.db.DbNewsEntry;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsDownloadTask
extends ImmoToolTask<Integer, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsDownloadTask.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsDownloadTask.class);
    private final AbstractDbDriver dbDriver;
    private final DbNewsHandler newsHandler;
    private final List<DbNewsFeed> feeds;
    private final List<DbNewsFeed> modifiedFeeds;
    private final Map<Long, Integer> modifiedFeedCounter;

    public NewsDownloadTask(AbstractDbDriver abstractDbDriver, DbNewsHandler dbNewsHandler) {
        super(I18N.tr("Check for news updates."));
        this.dbDriver = abstractDbDriver;
        this.newsHandler = dbNewsHandler;
        this.feeds = new ArrayList<DbNewsFeed>();
        this.modifiedFeeds = new ArrayList<DbNewsFeed>();
        this.modifiedFeedCounter = new HashMap<Long, Integer>();
    }

    public void addFeed(DbNewsFeed dbNewsFeed) {
        this.feeds.add(dbNewsFeed);
    }

    protected final Integer doInBackground() throws Exception {
        Connection connection = null;
        try {
            connection = this.dbDriver.getConnection();
            Integer n = this.executeTask(connection);
            return n;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer executeTask(Connection connection) throws Exception {
        int n = this.feeds.size() + 1;
        int n2 = 0;
        this.setProgress(n2, 0, n);
        try {
            Date date = new Date();
            this.modifiedFeeds.clear();
            this.modifiedFeedCounter.clear();
            int n3 = 0;
            for (DbNewsFeed dbNewsFeed : this.feeds) {
                SyndFeed syndFeed;
                this.setProgress(++n2, 0, n);
                this.setMessage(StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)dbNewsFeed.name), (int)50));
                if (dbNewsFeed.id <= 0L) {
                    LOGGER.warn("Feed is not saved yet!");
                    continue;
                }
                int n4 = 0;
                try {
                    syndFeed = NewsPluginUtils.parseFeed(dbNewsFeed);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't parse feed: " + dbNewsFeed.url);
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    dbNewsFeed.downloadedAt = date;
                    this.newsHandler.saveFeed(connection, dbNewsFeed);
                    if (n4 <= 0) continue;
                    this.modifiedFeeds.add(dbNewsFeed);
                    this.modifiedFeedCounter.put(dbNewsFeed.id, n4);
                    continue;
                }
                try {
                    Date date2 = syndFeed.getPublishedDate();
                    Date date3 = dbNewsFeed.publishedAt;
                    if (date2 != null && date3 != null && !date2.after(date3)) continue;
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    if (!dbNewsFeed.isArchived) {
                        for (Object object : (Object)this.newsHandler.getEntryIds(connection, dbNewsFeed.id)) {
                            arrayList.add((long)object);
                        }
                    }
                    for (Object e : syndFeed.getEntries()) {
                        String string;
                        SyndEntry syndEntry = (SyndEntry)e;
                        DbNewsEntry dbNewsEntry = this.newsHandler.getEntry(connection, dbNewsFeed.id, syndEntry.getUri());
                        if (dbNewsEntry != null) {
                            if (!dbNewsFeed.isArchived) {
                                arrayList.remove(dbNewsEntry.id);
                            }
                        } else {
                            block26: {
                                dbNewsEntry = new DbNewsEntry();
                                dbNewsEntry.feedId = dbNewsFeed.id;
                                try {
                                    string = syndEntry.getUri();
                                    if (string == null) break block26;
                                    dbNewsEntry.uri = new URI(string);
                                }
                                catch (Exception exception) {
                                    LOGGER.warn("Can't read entry URI: " + syndEntry.getUri());
                                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                                    continue;
                                }
                            }
                            ++n3;
                            ++n4;
                        }
                        dbNewsEntry.title = syndEntry.getTitle();
                        dbNewsEntry.content = NewsPluginUtils.readSyndEntryContent(syndEntry);
                        dbNewsEntry.time = syndEntry.getUpdatedDate();
                        if (dbNewsEntry.time == null) {
                            dbNewsEntry.time = syndEntry.getPublishedDate();
                        }
                        dbNewsEntry.author = syndEntry.getAuthor();
                        if (dbNewsEntry.author == null || dbNewsEntry.author.trim().length() < 1) {
                            dbNewsEntry.author = syndFeed.getAuthor();
                        }
                        try {
                            string = syndEntry.getLink();
                            if (string != null) {
                                dbNewsEntry.link = new URI(string);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            LOGGER.warn("Can't read entry URL: " + syndEntry.getLink());
                            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                            dbNewsEntry.link = null;
                        }
                        this.newsHandler.saveEntry(connection, dbNewsEntry);
                    }
                    if (!dbNewsFeed.isArchived && !arrayList.isEmpty()) {
                        Object object = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
                        this.newsHandler.removeEntries(connection, (long[])object);
                    }
                    dbNewsFeed.publishedAt = syndFeed.getPublishedDate();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    dbNewsFeed.downloadedAt = date;
                    this.newsHandler.saveFeed(connection, dbNewsFeed);
                    if (n4 <= 0) continue;
                    this.modifiedFeeds.add(dbNewsFeed);
                    this.modifiedFeedCounter.put(dbNewsFeed.id, n4);
                }
            }
            Integer n5 = n3;
            return n5;
        }
        finally {
            this.setProgress(n, 0, n);
        }
    }

    public List<DbNewsFeed> getModifiedFeeds() {
        return this.modifiedFeeds;
    }

    public int getNewEntriesCounter(DbNewsFeed dbNewsFeed) {
        return dbNewsFeed != null ? this.getNewEntriesCounter(dbNewsFeed.id) : 0;
    }

    public int getNewEntriesCounter(long l) {
        return this.modifiedFeedCounter.containsKey(l) ? this.modifiedFeedCounter.get(l) : 0;
    }

    protected DbNewsHandler getNewsHandler() {
        return this.newsHandler;
    }
}

