/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.extensions.DbNewsExtension;
import com.openindex.openestate.tool.utils.HttpUtils;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsPluginUtils.class);

    private NewsPluginUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(URI uRI, String string, char[] cArray, OutputStream outputStream) throws IOException {
        HttpClientBuilder httpClientBuilder = HttpUtils.builder();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            httpClientBuilder.setDefaultCredentialsProvider(HttpUtils.createAuthentication((String)string, (String)(cArray != null ? String.valueOf(cArray) : "")));
        }
        HttpEntity httpEntity = null;
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl((URI)uRI)));
            if (closeableHttpResponse == null) {
                throw new IOException("Can't create response!");
            }
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            if (statusLine == null) {
                throw new IOException("Can't read response status!");
            }
            int n = statusLine.getStatusCode();
            if (n >= 400) {
                throw new IOException("Invalid response " + n + " / " + statusLine.getReasonPhrase());
            }
            httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity == null) {
                throw new IOException("Can't read response entity!");
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(httpEntity.getContent());){
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
                outputStream.flush();
            }
        }
        catch (Throwable throwable) {
            EntityUtils.consumeQuietly(httpEntity);
            throw throwable;
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File downloadToTempFile(URI uRI, String string, char[] cArray) throws IOException {
        File file = File.createTempFile("ImmoTool_", "_" + System.currentTimeMillis());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            NewsPluginUtils.download(uRI, string, cArray, fileOutputStream);
            File file2 = file;
            return file2;
        }
        catch (IOException iOException) {
            if (!file.isFile()) throw iOException;
            FileUtils.deleteQuietly((File)file);
            throw iOException;
        }
    }

    public static DbNewsExtension getDbNewsExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? NewsPluginUtils.getDbNewsExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbNewsExtension getDbNewsExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? NewsPluginUtils.getDbNewsExtension(abstractDbDriver.getName()) : null;
    }

    public static DbNewsExtension getDbNewsExtension(String string) {
        for (Object object : NewsPluginUtils.getExtensionHandlers("DbNewsExtension", DbNewsExtension.class, null, null)) {
            DbNewsExtension dbNewsExtension = (DbNewsExtension)object;
            if (!dbNewsExtension.isSupportedDriver(string)) continue;
            return dbNewsExtension;
        }
        return null;
    }

    public static Collection<DbNewsExtension> getDbNewsExtensions() {
        ArrayList<DbNewsExtension> arrayList = new ArrayList<DbNewsExtension>();
        for (Object object : NewsPluginUtils.getExtensionHandlers("DbNewsExtension", DbNewsExtension.class, null, null)) {
            arrayList.add((DbNewsExtension)object);
        }
        return arrayList;
    }

    public static Properties getDefaultFeeds() throws IOException {
        Properties properties = new Properties();
        Locale locale = Locale.getDefault();
        URL uRL = NewsPluginUtils.class.getResource("/com/openindex/openestate/tool/news/resources/default_feeds_" + locale.toString() + ".properties");
        if (uRL == null) {
            uRL = NewsPluginUtils.class.getResource("/com/openindex/openestate/tool/news/resources/default_feeds_" + locale.getLanguage() + ".properties");
        }
        if (uRL == null) {
            uRL = NewsPluginUtils.class.getResource("/com/openindex/openestate/tool/news/resources/default_feeds_en.properties");
        }
        if (uRL == null) {
            return properties;
        }
        try (InputStream inputStream = uRL.openStream();){
            if (inputStream == null) {
                throw new IOException("Can't open resource: " + uRL.toString());
            }
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-News", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    private static SyndFeed parseFeed(File file) throws IOException, IllegalArgumentException {
        try {
            return new SyndFeedInput().build(file);
        }
        catch (FeedException | IOException | IllegalArgumentException throwable) {
            throw new IOException("Can't parse XML document!", throwable);
        }
    }

    public static SyndFeed parseFeed(DbNewsFeed dbNewsFeed) throws IOException, IllegalArgumentException {
        SyndFeed syndFeed;
        File file = null;
        try {
            file = DbNewsFeed.AuthMethod.HTTP_BASIC.equals((Object)dbNewsFeed.authMethod) ? NewsPluginUtils.downloadToTempFile(dbNewsFeed.url, dbNewsFeed.authUser, dbNewsFeed.authPassword) : NewsPluginUtils.downloadToTempFile(dbNewsFeed.url, null, null);
            syndFeed = NewsPluginUtils.parseFeed(file);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(file);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)file);
        return syndFeed;
    }

    public static String readSyndEntryContent(SyndEntry syndEntry) {
        if (!syndEntry.getContents().isEmpty()) {
            for (Object e : syndEntry.getContents()) {
                SyndContent syndContent = (SyndContent)e;
                String string = syndContent.getValue();
                if (string == null || string.trim().length() <= 0 || "null".equalsIgnoreCase(string.trim())) continue;
                return string;
            }
        }
        return syndEntry.getDescription() != null ? syndEntry.getDescription().getValue() : "";
    }
}

