/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.news.NewsPluginUtils;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.news.extensions.DbNewsExtension;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsUpgradeExtension.class);

    private static DbNewsFeed createFeed(Properties properties) throws URISyntaxException {
        String string = properties.getProperty("url.0");
        if (string == null || string.trim().length() < 1) {
            return null;
        }
        DbNewsFeed dbNewsFeed = new DbNewsFeed();
        dbNewsFeed.url = new URI(string);
        dbNewsFeed.name = properties.getProperty("title.0");
        dbNewsFeed.updateInterval = ImmoToolUtils.getPropertyAsLong((String)"updateInterval.0", (Long)0L, (Properties)properties);
        return dbNewsFeed;
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-News"};
    }

    public void upgrade(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, Properties properties, ImmoToolTask.Callback callback) {
        this.setMessage("Upgrade news...", callback);
        DbNewsExtension dbNewsExtension = NewsPluginUtils.getDbNewsExtension(abstractDbDriver);
        DbNewsHandler dbNewsHandler = dbNewsExtension.getNewsHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        TreeMap<Long, Object> treeMap = new TreeMap<Long, Object>();
        Object[] objectArray = file.listFiles((FileFilter)suffixFileFilter);
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                try {
                    treeMap.put(Long.valueOf(((File)object).getName().split("\\.")[0]), object);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read feed-id!");
                    LOGGER.warn("> from " + ((File)object).getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read feed-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            File file2 = (File)entry.getValue();
            try {
                Object object;
                object = new FileInputStream(file2);
                Throwable throwable = null;
                try {
                    Properties properties2 = new Properties();
                    properties2.loadFromXML((InputStream)object);
                    DbNewsFeed dbNewsFeed = NewsUpgradeExtension.createFeed(properties2);
                    if (dbNewsFeed == null) continue;
                    this.setMessage("> Import feed '" + dbNewsFeed.name + "'", callback);
                    dbNewsHandler.saveFeed(connection, dbNewsFeed);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)object).close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't import feed!");
                LOGGER.warn("> from " + file2.getAbsolutePath());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.setMessage("WARNING: Can't import feed!", callback);
                this.setMessage("> " + exception.getLocalizedMessage(), callback);
            }
        }
    }
}

