-- -----------------------------------------------------
-- News-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------

CREATE SEQUENCE seq_immotool_news_feeds
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;
CREATE SEQUENCE seq_immotool_news_entries
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;


-- -----------------------------------------------------
-- Table immotool_news_feeds
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_news_feeds (
  feed_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_news_feeds NOT NULL,
  feed_name VARCHAR(100) NOT NULL,
  feed_url VARCHAR(255) NOT NULL,
  feed_auth_method VARCHAR(50) DEFAULT NULL NULL,
  feed_auth_user VARCHAR(100) DEFAULT NULL NULL,
  feed_auth_pass VARCHAR(255) DEFAULT NULL NULL,
  feed_notes LONGVARCHAR DEFAULT NULL NULL,
  feed_archived BOOLEAN DEFAULT false NOT NULL,
  feed_update_enabled BOOLEAN DEFAULT true NOT NULL,
  feed_update_interval BIGINT DEFAULT 0 NOT NULL,
  feed_published_at TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  feed_downloaded_at TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  access_owner_id BIGINT DEFAULT 1 NOT NULL,
  access_group_id BIGINT DEFAULT 1 NOT NULL,
  access_permissions INT DEFAULT 0 NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (feed_id),
  FOREIGN KEY (access_owner_id)
    REFERENCES immotool_users(user_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT,
  FOREIGN KEY (access_group_id)
    REFERENCES immotool_groups(group_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT
);

-- -----------------------------------------------------
-- Table immotool_news_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_news_entries (
  entry_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_news_entries NOT NULL,
  feed_id BIGINT NOT NULL,
  entry_uri VARCHAR(255) NOT NULL,
  entry_title VARCHAR(255) NOT NULL,
  entry_author VARCHAR(255) DEFAULT NULL NULL,
  entry_content LONGVARCHAR NOT NULL,
  entry_link VARCHAR(255) DEFAULT NULL NULL,
  entry_time TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  entry_new BOOLEAN DEFAULT true NOT NULL,
  entry_sticky BOOLEAN DEFAULT false NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (entry_id),
  FOREIGN KEY (feed_id)
    REFERENCES immotool_news_feeds(feed_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);


-- -----------------------------------------------------
-- View view_immotool_news_feeds
-- -----------------------------------------------------
CREATE VIEW view_immotool_news_feeds AS
  SELECT * FROM immotool_news_feeds
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

GRANT SELECT
  ON view_immotool_news_feeds
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- View view_immotool_news_entries
-- -----------------------------------------------------
CREATE VIEW view_immotool_news_entries AS
  SELECT * FROM immotool_news_entries
  WHERE feed_id IN (SELECT feed_id FROM view_immotool_news_feeds);

GRANT SELECT
  ON view_immotool_news_entries
  TO "IMMOTOOL";
