-- -----------------------------------------------------
-- News-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Call temporary procedure 'immotool_news_update_permissions'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Call temporary procedure 'immotool_news_update_permissions'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS immotool_news_update_permissions;

\.
CREATE PROCEDURE immotool_news_update_permissions()
  SPECIFIC immotool_news_update_permissions
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE pluginId BIGINT;
    DECLARE permissionId BIGINT;
    DECLARE groupId BIGINT;

    -- ID des Plugins ermitteln
    SELECT plugin_id
      INTO pluginId
      FROM immotool_plugins
      WHERE plugin_name = 'OpenEstate-Tool-News';

    -- USE_PLUGIN-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'USE_PLUGIN' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ID der IMMOTOOL-Gruppe ermitteln
    SELECT group_id
      INTO groupId
      FROM immotool_groups
      WHERE group_name = 'IMMOTOOL';

    -- USE_PLUGIN-Berechtigung zur IMMOTOOL-Gruppe zuweisen
    INSERT INTO immotool_groups_permissions (
      group_id,
      permission_id )
    VALUES (
      groupId,
      permissionId );

    -- Umbenennung der bestehenden Berechtigungen
    UPDATE immotool_permissions
      SET permission_key = 'FEEDS_EDIT', modified_at = NOW()
      WHERE permission_key = 'feed.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'FEEDS_REMOVE', modified_at = NOW()
      WHERE permission_key = 'feed.remove'
      AND plugin_id = pluginId;

  END;
.;

CALL immotool_news_update_permissions();

DROP PROCEDURE
  IF EXISTS immotool_news_update_permissions;
