/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.remote.RemoteCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheListener;
import org.apache.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.RemoteCacheWatchRepairable;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheWatch;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IShutdownObserver;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class RemoteCacheManager
implements AuxiliaryCacheManager,
IShutdownObserver {
    private static final long serialVersionUID = 798077557166389498L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheManager == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheManager = RemoteCacheManager.class$("org.apache.jcs.auxiliary.remote.RemoteCacheManager")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheManager));
    static final Map instances = new HashMap();
    private static RemoteCacheMonitor monitor;
    private int clients;
    final Map caches = new HashMap();
    final String host;
    final int port;
    final String service;
    private IRemoteCacheAttributes irca;
    private IRemoteCacheService remoteService;
    private RemoteCacheWatchRepairable remoteWatch;
    private ICompositeCacheManager cacheMgr;
    private String registry;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheManager;

    private RemoteCacheManager(String host, int port, String service, ICompositeCacheManager cacheMgr) {
        this.host = host;
        this.port = port;
        this.service = service;
        this.cacheMgr = cacheMgr;
        if (this.cacheMgr instanceof CompositeCacheManager) {
            ((CompositeCacheManager)this.cacheMgr).registerShutdownObserver(this);
        }
        this.registry = "//" + host + ":" + port + "/" + service;
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up server " + this.registry));
        }
        try {
            Remote obj = Naming.lookup(this.registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            this.remoteService = (IRemoteCacheService)obj;
            if (log.isDebugEnabled()) {
                log.debug((Object)("remoteService = " + this.remoteService));
            }
            this.remoteWatch = new RemoteCacheWatchRepairable();
            this.remoteWatch.setCacheWatch((IRemoteCacheObserver)obj);
        }
        catch (Exception ex) {
            log.error((Object)("Problem finding server at [" + this.registry + "]"), (Throwable)ex);
            this.remoteService = new ZombieRemoteCacheService();
            this.remoteWatch = new RemoteCacheWatchRepairable();
            this.remoteWatch.setCacheWatch(new ZombieRemoteCacheWatch());
            RemoteCacheMonitor.getInstance().notifyError();
        }
    }

    public IRemoteCacheAttributes getDefaultCattr() {
        return this.irca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener listener) throws IOException {
        if (cattr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"The remote cache is configured to receive events from the remote server.  We will register a listener.");
            }
            Map map = this.caches;
            synchronized (map) {
                this.remoteWatch.addCacheListener(cattr.getCacheName(), listener);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"The remote cache is configured to NOT receive events from the remote server.  We will NOT register a listener.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.remoteWatch.removeCacheListener(cattr.getCacheName(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCacheListener(IRemoteCacheAttributes cattr) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            RemoteCacheNoWait cache = (RemoteCacheNoWait)this.caches.get(cattr.getCacheName());
            if (cache != null) {
                IRemoteCacheClient rc = cache.getRemoteCache();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cache for[ " + cattr.getCacheName() + "], deregistering listener."));
                }
                IRemoteCacheListener listener = rc.getListener();
                this.remoteWatch.removeCacheListener(cattr.getCacheName(), listener);
            } else if (cattr.isReceive()) {
                log.warn((Object)"Trying to deregister Cache Listener that was never registered.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Since the remote cache is configured to not receive, there is no listener to deregister.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCacheListener(String cacheName) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            RemoteCacheNoWait cache = (RemoteCacheNoWait)this.caches.get(cacheName);
            if (cache != null) {
                IRemoteCacheClient rc = cache.getRemoteCache();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cache for [" + cacheName + "], deregistering listener."));
                }
                IRemoteCacheListener listener = rc.getListener();
                this.remoteWatch.removeCacheListener(cacheName, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteCacheManager getInstance(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr) {
        String host = cattr.getRemoteHost();
        int port = cattr.getRemotePort();
        String service = cattr.getRemoteServiceName();
        if (host == null) {
            host = "";
        }
        if (port < 1024) {
            port = 1099;
        }
        Location loc = new Location(host, port);
        RemoteCacheManager ins = (RemoteCacheManager)instances.get(loc);
        Map map = instances;
        synchronized (map) {
            if (ins == null && (ins = (RemoteCacheManager)instances.get(loc)) == null) {
                ins = new RemoteCacheManager(host, port, service, cacheMgr);
                ins.irca = cattr;
                instances.put(loc, ins);
            }
        }
        ++ins.clients;
        if (monitor == null && (monitor = RemoteCacheMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return ins;
    }

    public AuxiliaryCache getCache(String cacheName) {
        IRemoteCacheAttributes ca = (IRemoteCacheAttributes)this.irca.copy();
        ca.setCacheName(cacheName);
        return this.getCache(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(IRemoteCacheAttributes cattr) {
        RemoteCacheNoWait c = null;
        Map map = this.caches;
        synchronized (map) {
            c = (RemoteCacheNoWait)this.caches.get(cattr.getCacheName());
            if (c == null) {
                RemoteCacheListener listener = null;
                try {
                    listener = new RemoteCacheListener(cattr, this.cacheMgr);
                    this.addRemoteCacheListener(cattr, listener);
                }
                catch (IOException ioe) {
                    log.error((Object)ioe.getMessage());
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
                c = new RemoteCacheNoWait(new RemoteCache(cattr, this.remoteService, listener));
                this.caches.put(cattr.getCacheName(), c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCache(String name) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("freeCache [" + name + "]"));
        }
        ICache c = null;
        Map map = this.caches;
        synchronized (map) {
            c = (ICache)this.caches.get(name);
        }
        if (c != null) {
            this.removeRemoteCacheListener(name);
            c.dispose();
        }
    }

    public String getStats() {
        StringBuffer stats = new StringBuffer();
        Iterator allCaches = this.caches.values().iterator();
        while (allCaches.hasNext()) {
            ICache c = (ICache)allCaches.next();
            if (c == null) continue;
            stats.append(c.getCacheName());
        }
        return stats.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (--this.clients != 0) {
            return;
        }
        Map map = this.caches;
        synchronized (map) {
            Iterator allCaches = this.caches.values().iterator();
            while (allCaches.hasNext()) {
                ICache c = (ICache)allCaches.next();
                if (c == null) continue;
                try {
                    this.freeCache(c.getCacheName());
                }
                catch (IOException ex) {
                    log.error((Object)"Problem in release.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixCaches(IRemoteCacheService remoteService, IRemoteCacheObserver remoteWatch) {
        Map map = this.caches;
        synchronized (map) {
            this.remoteService = remoteService;
            this.remoteWatch.setCacheWatch(remoteWatch);
            Iterator en = this.caches.values().iterator();
            while (en.hasNext()) {
                RemoteCacheNoWait cache = (RemoteCacheNoWait)en.next();
                cache.fixCache(this.remoteService);
            }
        }
    }

    public int getCacheType() {
        return 4;
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Observed shutdown request.");
        }
        this.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Location {
        public final String host;
        public final int port;

        public Location(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Location)) {
                return false;
            }
            Location l = (Location)obj;
            if (this.host == null && l.host != null) {
                return false;
            }
            return this.host.equals(l.host) && this.port == l.port;
        }

        public int hashCode() {
            return this.host == null ? this.port : this.host.hashCode() ^ this.port;
        }
    }
}

