/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;

public final class Type
extends Parameter {
    private static final long serialVersionUID = -3644362129355908795L;
    public static final Type HOME = new Type("home");
    public static final Type WORK = new Type("work");
    public static final Type PREF = new Type("pref");
    private final String[] types;

    public Type(String value) {
        super(Parameter.Id.TYPE);
        this.types = value.split(",");
    }

    public Type(String ... types) {
        super(Parameter.Id.TYPE);
        this.types = types;
    }

    public Type(Type ... types) {
        super(Parameter.Id.TYPE);
        ArrayList<String> typeList = new ArrayList<String>();
        for (Type type : types) {
            typeList.addAll(Arrays.asList(type.getTypes()));
        }
        this.types = typeList.toArray(new String[typeList.size()]);
    }

    public String[] getTypes() {
        return this.types;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.types.length; ++i) {
            b.append(this.types[i]);
            if (i >= this.types.length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    public static class Factory
    extends AbstractFactory
    implements ParameterFactory<Type> {
        public Factory() {
            super(Parameter.Id.TYPE.toString(), "HOME", "WORK", "MSG", "VOICE", "FAX", "CELL", "VIDEO", "PAGER", "BBS", "MODEM", "CAR", "ISDN", "PCS", "INTERNET", "X400", "DOM", "INTL", "POSTAL", "PARCEL");
        }

        @Override
        public Type createParameter(String name, String value) {
            Type parameter = null;
            try {
                parameter = Parameter.Id.valueOf(name.toUpperCase()) == Parameter.Id.TYPE ? (HOME.getValue().equals(value) ? HOME : (PREF.getValue().equals(value) ? PREF : (WORK.getValue().equals(value) ? WORK : new Type(value)))) : new Type(name);
            }
            catch (IllegalArgumentException iae) {
                parameter = new Type(name);
            }
            return parameter;
        }
    }
}

