/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final long serialVersionUID = -1464177816435975623L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyImpl.class);
    public static final String XML_ELEMENT = "Agency";
    private static final String XML_ELEMENT_AGENT = "Agent";
    private static final String XML_ELEMENT_CONTACT = "Contact";
    private static final String XML_ELEMENT_ESTATE = "Estate";
    private AgentImpl agencyAgent = new AgentImpl();
    private Map<String, AgentContactImpl> agencyContacts = new TreeMap<String, AgentContactImpl>();
    private Map<String, EstateImpl> agencyEstates = new TreeMap<String, EstateImpl>();

    public AgencyImpl() {
    }

    public AgencyImpl(Document document) throws DocumentException {
        this();
        this.readFromXml(document);
    }

    public AgentImpl getAgent() {
        return this.agencyAgent;
    }

    public Map<String, AgentContactImpl> getContacts() {
        return this.agencyContacts;
    }

    public Map<String, EstateImpl> getEstates() {
        return this.agencyEstates;
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        for (Node node : AgencyImpl.selectChildElements(element)) {
            AbstractImplItem abstractImplItem;
            if (XML_ELEMENT_AGENT.equals(node.getName())) {
                this.agencyAgent.readFromXml((Element)node);
                continue;
            }
            if (XML_ELEMENT_CONTACT.equals(node.getName())) {
                abstractImplItem = new AgentContactImpl();
                ((AgentContactImpl)abstractImplItem).readFromXml((Element)node);
                this.agencyContacts.put(((AgentContactImpl)abstractImplItem).getId(), (AgentContactImpl)abstractImplItem);
                continue;
            }
            if (!XML_ELEMENT_ESTATE.equals(node.getName())) continue;
            abstractImplItem = new EstateImpl();
            ((EstateImpl)abstractImplItem).readFromXml((Element)node);
            this.agencyEstates.put(((EstateImpl)abstractImplItem).getId(), (EstateImpl)abstractImplItem);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.agencyAgent.serializeToXml(element.addElement(XML_ELEMENT_AGENT));
        for (AgentContactImpl abstractImplItem : this.agencyContacts.values()) {
            abstractImplItem.serializeToXml(element.addElement(XML_ELEMENT_CONTACT));
        }
        for (EstateImpl estateImpl : this.agencyEstates.values()) {
            estateImpl.serializeToXml(element.addElement(XML_ELEMENT_ESTATE));
        }
    }

    public void setAgent(AgentImpl agentImpl) {
        this.agencyAgent = agentImpl;
    }
}

