/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AddressImpl;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstateAddressImpl
extends AddressImpl {
    private static final long serialVersionUID = 2742922091558208350L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EstateAddressImpl.class);
    public static final String XML_ATTRIB_PUBLISHED = "Published";
    private static final String OLD_XML_ATTRIB_PUBLISH_ADRESS = "PublishAdress";

    @Deprecated
    public boolean isAdressPublished() {
        return this.isPublished();
    }

    public boolean isPublished() {
        return (Boolean)this.getValue(XML_ATTRIB_PUBLISHED, Boolean.FALSE);
    }

    @Override
    public void readFromMap(Map<String, String> map, String string) {
        String string2 = string != null && string.length() > 0 ? string + "address." : "address.";
        this.setPublished(Boolean.TRUE.toString().equalsIgnoreCase(map.get(string2 + "published")));
        super.readFromMap(map, string);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.readFromXml(element);
        Boolean bl = EstateAddressImpl.selectAttributeAsBoolean(element, XML_ATTRIB_PUBLISHED, null);
        if (bl == null) {
            bl = EstateAddressImpl.selectAttributeAsBoolean(element, OLD_XML_ATTRIB_PUBLISH_ADRESS, null);
        }
        this.setPublished(Boolean.TRUE.equals(bl));
    }

    @Override
    public void serializeToMap(Map<String, String> map, String string) {
        String string2 = string != null && string.length() > 0 ? string + "address." : "address.";
        map.put(string2 + "published", String.valueOf(this.isPublished()));
        super.serializeToMap(map, string);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.serializeToXml(element);
        element.addAttribute(XML_ATTRIB_PUBLISHED, String.valueOf(this.isPublished()));
    }

    @Deprecated
    public void setAdressPublished(boolean bl) {
        this.setPublished(bl);
    }

    public void setPublished(boolean bl) {
        this.putValue(XML_ATTRIB_PUBLISHED, bl);
    }

    @Override
    public String writeStreet() {
        return this.isPublished() ? super.writeStreet() : "";
    }

    public String writeStreet(boolean bl) {
        return bl ? super.writeStreet() : this.writeStreet();
    }
}

