/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexStringAttrib
extends ComplexAttrib<Map<String, String>> {
    private static final long serialVersionUID = -6310316225039002638L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexStringAttrib.class);
    private static final String XML_ATTRIB_LANGUAGE = "Language";
    private static final String XML_ELEMENT_TEXT = "Text";
    private final int maxLength;
    private Map<String, String> value = new HashMap<String, String>();

    public ComplexStringAttrib(OpenEstateAttrib openEstateAttrib, int n, String[] stringArray) {
        super(openEstateAttrib, stringArray);
        this.maxLength = n > 0 ? n : 0;
    }

    @Override
    public Map<String, String> getDefaultValue() {
        return new HashMap<String, String>();
    }

    protected static String get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        return ComplexStringAttrib.get(estateImpl, openEstateAttrib, locale != null ? locale.toString() : null);
    }

    protected static String get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        string = (String)StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)Locale.getDefault().getLanguage());
        try {
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
            Object object = complexStringAttrib != null ? complexStringAttrib.getValue() : null;
            return object != null && !object.isEmpty() && object.containsKey(string) ? (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)object.get(string)), null) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public String getFormattedValue(Map<String, String> map, Locale locale, String string) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        String string2 = locale != null ? locale.getLanguage() : Locale.getDefault().getLanguage();
        return StringUtils.trimToEmpty((String)map.get(string2));
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Map<String, String> getValue() {
        return this.value;
    }

    public String getValue(String string) {
        Object object = this.getValue();
        return StringUtils.trimToNull((String)((String)object.get(string)));
    }

    public String[] getValueLanguages() {
        Object object = this.getValue();
        return object == null || object.isEmpty() ? new String[]{} : object.keySet().toArray(new String[0]);
    }

    @Override
    public boolean hasEmptyValue() {
        Object object = this.getValue();
        if (object == null || object.isEmpty()) {
            return true;
        }
        for (String string : object.values()) {
            if (StringUtils.isBlank((CharSequence)string)) continue;
            return false;
        }
        return true;
    }

    public boolean hasValueForLanguage(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        Object object = this.getValue();
        return object != null && object.containsKey(string);
    }

    public final boolean isString() {
        return this.maxLength > 0 && this.maxLength < 256;
    }

    public final boolean isText() {
        return !this.isString();
    }

    @Override
    protected Map<String, String> parseNode(Element element) {
        if (element == null) {
            return null;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (element.isTextOnly()) {
                String string = StringUtils.trimToNull((String)this.parseString(element.getStringValue()));
                if (string != null) {
                    hashMap.put(Locale.getDefault().getLanguage(), string);
                }
            } else {
                for (Object e : element.selectNodes("*")) {
                    if (!(e instanceof Element)) continue;
                    Element element2 = (Element)e;
                    if (!element2.getName().equals(XML_ELEMENT_TEXT)) {
                        LOGGER.warn("Invalid node \"" + element2.getName() + "\" for a string attribute!");
                        continue;
                    }
                    String string = StringUtils.trimToNull((String)element2.attributeValue(XML_ATTRIB_LANGUAGE));
                    if (string == null) {
                        LOGGER.warn("Empty langauge for a string attribute!");
                        continue;
                    }
                    String string2 = StringUtils.trimToNull((String)this.parseString(element2.getStringValue()));
                    if (string2 == null) continue;
                    hashMap.put(string, StringEscapeUtils.unescapeHtml4((String)string2));
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse string attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    private String parseString(String string) {
        String string2 = OpenEstateUtils.parseString(string);
        return this.maxLength > 0 ? StringUtils.abbreviate((String)string2, (int)this.maxLength) : string2;
    }

    @Override
    public Map<String, String> parseValue(Object object) {
        if (object == null) {
            return null;
        }
        String string = this.parseString(object.toString());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Locale.getDefault().getLanguage(), string);
        return hashMap;
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Map<String, String> map) {
        try {
            if (map == null || map.isEmpty()) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)openEstateAttrib.createImpl();
                complexStringAttrib.setValue(map);
                estateImpl.putAttribute(complexStringAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put string attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void putValue(Locale locale, String string) {
        if (locale != null) {
            this.putValue(locale.toString(), string);
        }
    }

    public void putValue(String string, String string2) {
        string = StringUtils.trimToNull((String)string);
        string2 = StringUtils.trimToNull((String)string2);
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = this.getValue();
        if (string2 == null) {
            if (hashMap != null) {
                hashMap.remove(string);
            }
        } else {
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(string, string2);
        }
        this.setValue((Map<String, String>)hashMap);
    }

    protected static void putValue(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale, String string) {
        if (locale != null) {
            ComplexStringAttrib.putValue(estateImpl, openEstateAttrib, locale.toString(), string);
        }
    }

    protected static void putValue(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        string2 = StringUtils.trimToNull((String)string2);
        if (!estateImpl.hasAttribute(openEstateAttrib)) {
            if (string2 != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(string, string2);
                ComplexStringAttrib.put(estateImpl, openEstateAttrib, hashMap);
            }
        } else {
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
            complexStringAttrib.putValue(string, string2);
            if (complexStringAttrib.getValue().isEmpty()) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                estateImpl.putAttribute(complexStringAttrib);
            }
        }
    }

    @Override
    public void setValue(Map<String, String> map) {
        this.value = map;
    }

    @Deprecated
    public void setValue(String string, String string2) {
        this.putValue(string2, string);
    }

    @Override
    protected void writeNode(Element element, Map<String, String> map) {
        if (element == null || map == null || map.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                if (StringUtils.isBlank((CharSequence)string)) {
                    LOGGER.warn("Empty language code!");
                    continue;
                }
                String string2 = this.writeString(entry.getValue(), System.lineSeparator());
                if (StringUtils.isBlank((CharSequence)string2)) continue;
                Element element2 = element.addElement(XML_ELEMENT_TEXT);
                element2.addAttribute(XML_ATTRIB_LANGUAGE, string);
                element2.setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)string2)));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write length attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private String writeString(String string, String string2) {
        string = (String)StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)"");
        string = this.maxLength > 0 ? StringUtils.abbreviate((String)string, (int)this.maxLength) : string;
        return OpenEstateUtils.serializeString(string, string2);
    }
}

