/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleBooleanAttrib
extends SimpleAttrib<Boolean> {
    private static final long serialVersionUID = 3777018077349350044L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBooleanAttrib.class);
    private Boolean value = null;

    public SimpleBooleanAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public Boolean getDefaultValue() {
        return false;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    protected static Boolean get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        try {
            SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)estateImpl.getAttribute(openEstateAttrib);
            return simpleBooleanAttrib != null ? simpleBooleanAttrib.getValue() : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as Boolean!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return SimpleBooleanAttrib.getAsString(estateImpl, openEstateAttrib, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        try {
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public String getFormattedValue(Boolean bl, Locale locale, String string) {
        if (Boolean.TRUE.equals(bl)) {
            return OpenEstateConstant.YES.getTranslation(locale);
        }
        if (Boolean.FALSE.equals(bl)) {
            return OpenEstateConstant.NO.getTranslation(locale);
        }
        return "";
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    public final Boolean parseValue(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        if (string.equalsIgnoreCase(Boolean.TRUE.toString()) || string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(Boolean.FALSE.toString()) || string.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            SimpleBooleanAttrib.put(estateImpl, openEstateAttrib, (Boolean)null);
        } else if (string.equalsIgnoreCase(Boolean.TRUE.toString()) || string.equals("1")) {
            SimpleBooleanAttrib.put(estateImpl, openEstateAttrib, true);
        } else if (string.equalsIgnoreCase(Boolean.FALSE.toString()) || string.equals("0")) {
            SimpleBooleanAttrib.put(estateImpl, openEstateAttrib, false);
        } else {
            SimpleBooleanAttrib.put(estateImpl, openEstateAttrib, (Boolean)null);
        }
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Boolean bl) {
        try {
            if (bl == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)openEstateAttrib.createImpl();
                simpleBooleanAttrib.setValue(bl);
                estateImpl.putAttribute(simpleBooleanAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put boolean attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(Boolean bl) {
        this.value = bl;
    }

    @Override
    protected String writeValue(Boolean bl) {
        return bl != null ? bl.toString().trim() : "";
    }
}

