/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.administration;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class Usage
extends ComplexEnumAttrib<Option> {
    public Usage() {
        super(OpenEstateAttrib.ADMINISTRATION_USAGE, null);
    }

    public Usage(Option option) {
        Option[] optionArray;
        if (option != null) {
            Option[] optionArray2 = new Option[1];
            optionArray = optionArray2;
            optionArray2[0] = option;
        } else {
            optionArray = null;
        }
        this(optionArray);
    }

    public Usage(Option[] optionArray) {
        this();
        if (optionArray != null) {
            ((AbstractAttribImpl)this).setValue(optionArray);
        }
    }

    public static Option[] get(EstateImpl estateImpl) {
        return (Option[])Usage.get(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option[] optionArray = Usage.get(estateImpl);
        if (optionArray != null) {
            arrayList.addAll(Arrays.asList(optionArray));
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl, String string) {
        return Usage.getAsString(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, string);
    }

    public static String getAsString(EstateImpl estateImpl, String string, Locale locale) {
        return Usage.getAsString(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, string, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public Option[] getOptionsArray(Collection<Option> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(new Option[collection.size()]) : new Option[]{};
    }

    public static boolean hasOption(EstateImpl estateImpl, Option option) {
        return Usage.hasOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, option);
    }

    public static void put(EstateImpl estateImpl, Option[] optionArray) {
        Usage.put(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, optionArray);
    }

    public static void put(EstateImpl estateImpl, String[] stringArray) {
        Usage.put(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, stringArray);
    }

    public static void putOption(EstateImpl estateImpl, Option option) {
        Usage.putOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, option);
    }

    public static void putOption(EstateImpl estateImpl, String string) {
        Usage.putOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, string);
    }

    public static void removeOption(EstateImpl estateImpl, Option option) {
        Usage.removeOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, option);
    }

    public static void removeOption(EstateImpl estateImpl, String string) {
        Usage.removeOption(estateImpl, OpenEstateAttrib.ADMINISTRATION_USAGE, string);
    }

    public static enum Option implements Translatable
    {
        INVESTMENT(I18n.marktr((String)"investment")),
        RESIDENTIAL(I18n.marktr((String)"residence")),
        COMMERCIAL(I18n.marktr((String)"commercial")),
        LEISURE(I18n.marktr((String)"leisure")),
        GARDEN(I18n.marktr((String)"garden")),
        MISC(I18n.marktr((String)"miscellaneous"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

