/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.surroundings;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class CommercialZone
extends SimpleEnumAttrib<Option> {
    public CommercialZone() {
        super(OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE, null);
    }

    public CommercialZone(Option option) {
        this();
        if (option != null) {
            this.setValue(option);
        }
    }

    public static Option get(EstateImpl estateImpl) {
        return (Option)CommercialZone.get(estateImpl, OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option = CommercialZone.get(estateImpl);
        if (option != null) {
            arrayList.add(option);
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl) {
        return CommercialZone.getAsString(estateImpl, OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return CommercialZone.getAsString(estateImpl, OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public static void put(EstateImpl estateImpl, Option option) {
        CommercialZone.put(estateImpl, OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE, option);
    }

    public static void put(EstateImpl estateImpl, String string) {
        CommercialZone.put(estateImpl, OpenEstateAttrib.SURROUNDINGS_COMMERCIAL_ZONE, string);
    }

    public static enum Option implements Translatable
    {
        LOCATION_A(I18n.marktr((String)"triple A-location")),
        LOCATION_B(I18n.marktr((String)"secondary location (B)")),
        LOCATION_1A(I18n.marktr((String)"triple A-location")),
        LOCATION_2A(I18n.marktr((String)"secondary location (2A)")),
        LOCATION_1B(I18n.marktr((String)"secondary location (1B)")),
        LOCATION_2B(I18n.marktr((String)"secondary location (2B)")),
        SHOPPING_CENTER(I18n.marktr((String)"shopping center")),
        PREDESTRIAN_ZONE(I18n.marktr((String)"pedestrian zone"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

