/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.EstateLinkProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbLink
implements Serializable {
    private static final long serialVersionUID = 464429522812189175L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLink.class);
    public long id = 0L;
    public long objectId = 0L;
    public int position = 0;
    public boolean published = true;
    public URI webLinkUrl = null;
    public EstateLinkProvider provider = null;
    public String providerLinkId = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public Map<String, Translation> translations = null;

    public String getTitle(Locale locale) {
        return this.getTitle(locale.toString());
    }

    public String getTitle(String string) {
        return this.translations != null && this.translations.containsKey(string) ? this.translations.get((Object)string).title : null;
    }

    public URI getUrl() {
        if (this.webLinkUrl != null) {
            return this.webLinkUrl;
        }
        if (this.provider != null && this.providerLinkId != null) {
            return this.provider.getUrlFromLinkId(this.providerLinkId);
        }
        return null;
    }

    public String getUrlValue() {
        URI uRI = this.getUrl();
        return uRI != null ? uRI.toString() : null;
    }

    public void initTranslations() {
        this.translations = new HashMap<String, Translation>();
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.toString());
    }

    public void setTitle(String string, String string2) {
        if (this.translations == null) {
            return;
        }
        if (string == null || string.trim().length() < 1) {
            this.translations.remove(string2);
        } else {
            if (!this.translations.containsKey(string2)) {
                this.translations.put(string2, new Translation());
            }
            this.translations.get((Object)string2).title = string;
        }
    }

    public void setUrl(URI uRI) {
        this.provider = null;
        this.providerLinkId = null;
        this.webLinkUrl = null;
        if (uRI == null) {
            return;
        }
        String string = uRI.toString();
        for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
            String string2 = StringUtils.trimToNull((String)estateLinkProvider.getLinkIdFromUrl(string));
            if (string2 == null) continue;
            this.provider = estateLinkProvider;
            this.providerLinkId = string2;
            break;
        }
        if (this.provider == null) {
            this.webLinkUrl = uRI;
        }
    }

    public void setUrlValue(String string) throws URISyntaxException {
        this.setUrl((string = StringUtils.trimToNull((String)string)) != null ? new URI(string) : null);
    }

    public static class Translation
    implements Serializable {
        private static final long serialVersionUID = 4966293673542674736L;
        public String title = null;
    }
}

