/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEstateTypeTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -1977510081260551251L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JEstateTypeTreeNode.class);
    private Locale nodeLocale = OpenEstateUtils.DEFAULT_LOCALE;

    public JEstateTypeTreeNode() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public JEstateTypeTreeNode(Locale locale) {
        super(null);
        this.nodeLocale = locale;
        for (OpenEstateType openEstateType : OpenEstateType.getRootTypes()) {
            this.add(new JEstateTypeTreeNode(openEstateType, this.nodeLocale));
        }
    }

    public JEstateTypeTreeNode(OpenEstateType openEstateType, Locale locale) {
        super(openEstateType);
        if (openEstateType.hasChildTypes()) {
            for (OpenEstateType openEstateType2 : openEstateType.getChildTypes(false)) {
                this.add(new JEstateTypeTreeNode(openEstateType2, locale));
            }
        }
    }

    public OpenEstateType getEstateType() {
        return (OpenEstateType)this.getUserObject();
    }

    public void setLocale(Locale locale) {
        this.nodeLocale = locale;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((JEstateTypeTreeNode)this.getChildAt(i)).setLocale(locale);
        }
    }

    @Override
    public String toString() {
        OpenEstateType openEstateType = this.getEstateType();
        return openEstateType != null ? openEstateType.getTranslation(this.nodeLocale) : "ROOT";
    }
}

