/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class IndentAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int INDENT = 0;
    public static final int OUTDENT = 1;
    protected int direction;

    public IndentAction(int n) throws IllegalArgumentException {
        super("");
        if (n == 0) {
            this.putValue("Name", "Indent");
        } else if (n == 1) {
            this.putValue("Name", "Outdent");
        } else {
            throw new IllegalArgumentException("Invalid indentation direction");
        }
        this.direction = n;
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
    }

    private void insertHTML(String string, HTML.Tag tag, HTML.Tag tag2, ActionEvent actionEvent) {
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertHTML", string, tag2, tag);
        insertHTMLTextAction.actionPerformed(actionEvent);
    }

    private HTML.Tag getRootTag(Element element) {
        HTML.Tag tag = HTML.Tag.BODY;
        if (HTMLUtils.getListParent(element) != null) {
            tag = HTML.Tag.UL;
        } else if (HTMLUtils.getParent(element, HTML.Tag.TD) != null) {
            tag = HTML.Tag.TD;
        } else if (HTMLUtils.getParent(element, HTML.Tag.BLOCKQUOTE) != null) {
            tag = HTML.Tag.BLOCKQUOTE;
        }
        return tag;
    }

    private int getIndentationLevel(Element element) {
        int n = 0;
        while (!element.getName().equals("body") && !element.getName().equals("td")) {
            if (element.getName().equals("blockquote")) {
                ++n;
            }
            element = element.getParentElement();
        }
        return n;
    }

    private Map getListElems(List list) {
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = HTMLUtils.getParent((Element)iterator.next(), HTML.Tag.LI);
            if (element == null) continue;
            Element element2 = HTMLUtils.getListParent(element);
            if (!hashMap.containsKey(element2)) {
                hashMap.put(element2, new ArrayList());
            }
            List list2 = (List)hashMap.get(element2);
            list2.add(element);
        }
        return hashMap;
    }

    private void unindent(ActionEvent actionEvent, JEditorPane jEditorPane) {
        List list = this.getParagraphElements(jEditorPane);
        if (list.size() == 0) {
            return;
        }
        List list2 = this.getLeadingTralingListElems(list);
        list.removeAll(list2);
        HashSet<Element> hashSet = new HashSet<Element>();
        HashSet<Element> hashSet2 = new HashSet<Element>();
        Element element = null;
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            Element element3 = HTMLUtils.getParent(element2, HTML.Tag.BLOCKQUOTE);
            if (element3 == null) continue;
            if (element == null || element3.getStartOffset() >= element.getEndOffset()) {
                hashSet2.add(element3);
                element = element3;
            }
            if (i != 0 && i != list.size() - 1) continue;
            int n = element3.getElementCount();
            for (int j = 0; j < n; ++j) {
                Element element4 = element3.getElement(j);
                int n2 = element4.getStartOffset();
                int n3 = element4.getEndOffset();
                if (n3 >= jEditorPane.getSelectionStart() && n2 <= jEditorPane.getSelectionEnd()) continue;
                hashSet.add(element4);
            }
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        this.adjustListElemsIndent(list2, hTMLDocument);
        this.blockquoteElements(new ArrayList(hashSet), hTMLDocument);
        this.unblockquoteElements(new ArrayList(hashSet2), hTMLDocument);
    }

    private void adjustListElemsIndent(List list, HTMLDocument hTMLDocument) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Element> hashSet2 = new HashSet<Element>();
        for (int i = 0; i < list.size(); ++i) {
            Element element = HTMLUtils.getParent((Element)list.get(i), HTML.Tag.LI);
            if (element == null) continue;
            hashSet2.add(element);
            object = HTMLUtils.getListParent(element);
            if (object == null) continue;
            while (HTMLUtils.getListParent(object.getParentElement()) != null) {
                object = HTMLUtils.getListParent(object.getParentElement());
            }
            hashSet.add(object);
        }
        for (Element element : hashSet) {
            object = this.buildListHTML(element, new ArrayList(hashSet2));
            System.err.println((String)object);
            try {
                hTMLDocument.setInnerHTML(element, (String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private List getItems(Element element, List list, int n) {
        int n2 = element.getElementCount();
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        for (int i = 0; i < n2; ++i) {
            Element element2 = element.getElement(i);
            if (element2.getName().equals("li")) {
                ListItem listItem = new ListItem();
                listItem.listTag = HTML.getTag(element.getName());
                listItem.level = n;
                if (list.contains(element2)) {
                    if (this.direction == 0) {
                        ++listItem.level;
                    } else if (listItem.level > 0) {
                        --listItem.level;
                    }
                }
                listItem.html = HTMLUtils.getElementHTML(element2, true);
                arrayList.add(listItem);
                continue;
            }
            if (HTMLUtils.getListParent(element2) != element2) continue;
            arrayList.addAll(this.getItems(element2, list, n + 1));
        }
        return arrayList;
    }

    private String buildListHTML(Element element, List list) {
        List list2 = this.getItems(element, list, 0);
        ListItem listItem = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list2.size(); ++i) {
            ListItem listItem2 = (ListItem)list2.get(i);
            if (!(listItem == null || listItem.level == listItem2.level && listItem.listTag.equals(listItem2.listTag))) {
                if (listItem.level > listItem2.level) {
                    stringBuffer.append(this.openOrCloseList(listItem.listTag, -1 * (listItem.level - listItem2.level)));
                    stringBuffer.append(listItem2.html);
                } else if (listItem2.level > listItem.level) {
                    stringBuffer.append(this.openOrCloseList(listItem2.listTag, listItem2.level - listItem.level));
                    stringBuffer.append(listItem2.html);
                } else {
                    stringBuffer.append(listItem2.html);
                }
            } else {
                if (listItem == null) {
                    stringBuffer.append(this.openOrCloseList(listItem2.listTag, listItem2.level));
                }
                stringBuffer.append(listItem2.html);
            }
            listItem = listItem2;
        }
        if (listItem != null) {
            stringBuffer.append(this.openOrCloseList(listItem.listTag, -1 * listItem.level));
        }
        return stringBuffer.toString();
    }

    private String openOrCloseList(HTML.Tag tag, int n) {
        String string = n < 0 ? "</" + tag + ">\n" : "<" + tag + ">\n";
        int n2 = Math.abs(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private List getLeadingTralingListElems(List list) {
        Element element;
        int n;
        HashSet<Element> hashSet = new HashSet<Element>();
        for (n = 0; n < list.size() && HTMLUtils.getListParent(element = (Element)list.get(n)) != null; ++n) {
            hashSet.add(element);
        }
        for (n = list.size() - 1; n >= 0 && HTMLUtils.getListParent(element = (Element)list.get(n)) != null; --n) {
            hashSet.add(element);
        }
        return new ArrayList(hashSet);
    }

    private void indent1(ActionEvent actionEvent, JEditorPane jEditorPane) {
        List list = this.getParagraphElements(jEditorPane);
        if (list.size() == 0) {
            return;
        }
        List list2 = this.getLeadingTralingListElems(list);
        list.removeAll(list2);
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        this.blockquoteElements(list, hTMLDocument);
        this.adjustListElemsIndent(list2, hTMLDocument);
    }

    private void indent(ActionEvent actionEvent, JEditorPane jEditorPane) {
        List list = this.getParagraphElements(jEditorPane);
        if (list.size() == 0) {
            return;
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        LinkedList<Element> linkedList = new LinkedList<Element>();
        Object object = list.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (HTMLUtils.getListParent(element) != null) continue;
            linkedList.add(element);
            object.remove();
        }
        this.blockquoteElements(linkedList, hTMLDocument);
        object = this.getListElems(list);
        for (Element element : object.keySet()) {
            Element element2;
            int n;
            List list2 = (List)object.get(element);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<" + element.getName() + ">\n");
            for (n = 0; n < list2.size(); ++n) {
                element2 = (Element)list2.get(n);
                stringBuffer.append(HTMLUtils.getElementHTML(element2, true));
            }
            stringBuffer.append("</" + element.getName() + ">\n");
            System.err.println(stringBuffer);
            for (n = list2.size() - 1; n >= 0; --n) {
                element2 = (Element)list2.get(n);
                try {
                    if (n == 0) {
                        hTMLDocument.setOuterHTML(element2, stringBuffer.toString());
                        continue;
                    }
                    HTMLUtils.removeElement(element2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void unblockquoteElements(List list, HTMLDocument hTMLDocument) {
        for (Element element : list) {
            if (!element.getName().equals("blockquote")) continue;
            String string = HTMLUtils.getElementHTML(element, false);
            HTML.Tag tag = HTMLUtils.getStartTag(string);
            if (tag == null || !tag.breaksFlow()) {
                string = "<p>\n" + string + "</p>\n";
            }
            try {
                hTMLDocument.setOuterHTML(element, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void blockquoteElements(List list, HTMLDocument hTMLDocument) {
        for (Element element : list) {
            String string = HTMLUtils.getElementHTML(element, true);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<blockquote>\n");
            stringBuffer.append(string);
            stringBuffer.append("</blockquote>\n");
            try {
                hTMLDocument.setOuterHTML(element, stringBuffer.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public List getParagraphElements(JEditorPane jEditorPane) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            Element element = this.getParaElement(hTMLDocument, jEditorPane.getSelectionStart());
            Element element2 = this.getParaElement(hTMLDocument, jEditorPane.getSelectionEnd());
            while (element.getEndOffset() <= element2.getEndOffset()) {
                arrayList.add(element);
                if ((element = this.getParaElement(hTMLDocument, element.getEndOffset() + 1)).getEndOffset() < hTMLDocument.getLength()) continue;
                break;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return arrayList;
    }

    private Element getParaElement(HTMLDocument hTMLDocument, int n) {
        Element element = hTMLDocument.getParagraphElement(n);
        return element;
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        int n = jEditorPane.getCaretPosition();
        CompoundUndoManager.beginCompoundEdit(jEditorPane.getDocument());
        if (this.direction == 0) {
            this.indent1(actionEvent, jEditorPane);
        } else {
            this.unindent(actionEvent, jEditorPane);
        }
        CompoundUndoManager.endCompoundEdit(jEditorPane.getDocument());
        jEditorPane.setCaretPosition(n);
    }

    private class ListItem {
        String html;
        int level;
        HTML.Tag listTag;

        private ListItem() {
        }
    }
}

