/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkAttributesPanel;

public class LinkPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private JPanel hlinkPanel = null;
    private JLabel urlLabel = null;
    private JLabel textLabel = null;
    private JTextField urlField = null;
    private JTextField textField = null;
    private HTMLAttributeEditorPanel linkAttrPanel = null;
    private boolean urlFieldEnabled;

    public LinkPanel() {
        this(true);
    }

    public LinkPanel(boolean bl) {
        this(new Hashtable(), bl);
    }

    public LinkPanel(Hashtable hashtable, boolean bl) {
        this(hashtable, bl, null);
    }

    public LinkPanel(Hashtable hashtable, boolean bl, Set<String> set) {
        this.urlFieldEnabled = bl;
        this.initialize();
        this.setHiddenAttributes(set);
        this.setAttributes(hashtable);
        this.updateComponentsFromAttribs();
    }

    @Override
    public void updateComponentsFromAttribs() {
        this.linkAttrPanel.updateComponentsFromAttribs();
        if (this.attribs.containsKey("href")) {
            this.urlField.setText(this.attribs.get("href").toString());
        } else {
            this.urlField.setText("");
        }
    }

    @Override
    public void updateAttribsFromComponents() {
        this.linkAttrPanel.updateAttribsFromComponents();
        this.attribs.put("href", this.urlField.getText());
    }

    @Override
    public void setAttributes(Map map) {
        super.setAttributes(map);
        this.linkAttrPanel.setAttributes(this.attribs);
    }

    @Override
    public void setHiddenAttributes(Set set) {
        super.setHiddenAttributes(set);
        this.linkAttrPanel.setHiddenAttributes(this.hiddenAttribs);
    }

    public void setLinkText(String string) {
        this.textField.setText(string);
    }

    public String getLinkText() {
        return this.textField.getText();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.setSize(328, 218);
        this.add((Component)this.getHlinkPanel(), "North");
        this.add((Component)this.getLinkAttrPanel(), "Center");
        TextEditPopupManager textEditPopupManager = TextEditPopupManager.getInstance();
        textEditPopupManager.registerJTextComponent(this.urlField);
        textEditPopupManager.registerJTextComponent(this.textField);
    }

    private JPanel getHlinkPanel() {
        if (this.hlinkPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints3.gridy = 1;
            this.textLabel = new JLabel();
            this.textLabel.setText(i18n.str("text"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.gridy = 0;
            this.urlLabel = new JLabel();
            this.urlLabel.setText(i18n.str("url"));
            this.hlinkPanel = new JPanel();
            this.hlinkPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("link"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.hlinkPanel.setLayout(new GridBagLayout());
            this.hlinkPanel.add((Component)this.urlLabel, gridBagConstraints4);
            this.hlinkPanel.add((Component)this.textLabel, gridBagConstraints3);
            this.hlinkPanel.add((Component)this.getUrlField(), gridBagConstraints2);
            this.hlinkPanel.add((Component)this.getTextField(), gridBagConstraints);
        }
        return this.hlinkPanel;
    }

    private JTextField getUrlField() {
        if (this.urlField == null) {
            this.urlField = new JTextField();
            this.urlField.setEditable(this.urlFieldEnabled);
        }
        return this.urlField;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
        }
        return this.textField;
    }

    private JPanel getLinkAttrPanel() {
        if (this.linkAttrPanel == null) {
            this.linkAttrPanel = new LinkAttributesPanel();
        }
        return this.linkAttrPanel;
    }
}

