/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

public class SwingException
extends Exception {
    protected StackTraceElement[] callingStackTrace;

    public SwingException() {
    }

    public SwingException(String message) {
        super(message);
    }

    public SwingException(Throwable cause) {
        super(cause);
    }

    public SwingException(String message, Throwable cause) {
        super(message, cause);
    }

    public SwingException(String message, Throwable cause, StackTraceElement[] callingStack) {
        super(message, cause);
        this.setCallingStack(callingStack);
    }

    public void setCallingStack(StackTraceElement[] swingCallingStack) {
        this.callingStackTrace = swingCallingStack;
    }

    public StackTraceElement[] getCallingStack() {
        return this.callingStackTrace;
    }

    public void printStackTrace(PrintStream ps) {
        PrintWriter pw = new PrintWriter(ps, true);
        this.printStackTrace(pw);
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this);
        if (this.callingStackTrace != null) {
            pw.println("Calling stack:");
            int i = 0;
            while (i < this.callingStackTrace.length) {
                pw.println("\tat " + this.callingStackTrace[i]);
                ++i;
            }
            pw.println("Stack after call:");
        }
        super.printStackTrace(pw);
    }
}

