/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import org.java.plugin.registry.ExtensionMultiplicity;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.ParameterMultiplicity;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.xml.BaseHandler;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.ModelDocumentation;
import org.java.plugin.registry.xml.ModelDocumentationReference;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.SimpleStack;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

final class ManifestHandler
extends BaseHandler {
    private ModelPluginManifest manifest = null;
    private ModelDocumentation documentation = null;
    private ModelPrerequisite prerequisite;
    private ModelLibrary library;
    private ModelExtensionPoint extensionPoint;
    private ModelExtension extension;
    private StringBuilder docText = null;
    private SimpleStack<ModelAttribute> attributeStack = null;
    private ModelAttribute attribute;
    private SimpleStack<ModelParameterDef> paramDefStack = null;
    private ModelParameterDef paramDef;
    private SimpleStack<ModelParameter> paramStack = null;
    private ModelParameter param;
    private StringBuilder paramValue = null;

    ManifestHandler(EntityResolver anEntityResolver) {
        super(anEntityResolver);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("startElement - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
        }
        if ("plugin".equals(name = qName)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + name + "] element (manifest already defined)");
            }
            this.manifest = new ModelPluginDescriptor();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
            this.manifest.setDocsPath(attributes.getValue("docs-path"));
            ((ModelPluginDescriptor)this.manifest).setClassName(attributes.getValue("class"));
        } else if ("plugin-fragment".equals(name)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + name + "] element (manifest already defined)");
            }
            this.manifest = new ModelPluginFragment();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
            this.manifest.setDocsPath(attributes.getValue("docs-path"));
            ((ModelPluginFragment)this.manifest).setPluginId(attributes.getValue("plugin-id"));
            if (attributes.getValue("plugin-version") != null) {
                ((ModelPluginFragment)this.manifest).setPluginVersion(attributes.getValue("plugin-version"));
            }
            if (attributes.getValue("match") != null) {
                ((ModelPluginFragment)this.manifest).setMatchingRule(MatchingRule.fromCode(attributes.getValue("match")));
            } else {
                ((ModelPluginFragment)this.manifest).setMatchingRule(MatchingRule.COMPATIBLE);
            }
        } else if ("doc".equals(name)) {
            this.documentation = new ModelDocumentation();
            this.documentation.setCaption(attributes.getValue("caption"));
        } else if ("doc-ref".equals(name)) {
            if (this.documentation == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[doc-ref] element found outside of [doc] element");
                }
                this.log.warn((Object)"[doc-ref] element found outside of [doc] element");
                return;
            }
            ModelDocumentationReference docRef = new ModelDocumentationReference();
            docRef.setPath(attributes.getValue("path"));
            docRef.setCaption(attributes.getValue("caption"));
            this.documentation.getReferences().add(docRef);
        } else if ("doc-text".equals(name)) {
            if (this.documentation == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[doc-text] element found outside of [doc] element");
                }
                this.log.warn((Object)"[doc-text] element found outside of [doc] element");
                return;
            }
            this.docText = new StringBuilder();
        } else if ("attributes".equals(name)) {
            this.attributeStack = new SimpleStack();
        } else if ("attribute".equals(name)) {
            if (this.attributeStack == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[attribute] element found outside of [attributes] element");
                }
                this.log.warn((Object)"[attribute] element found outside of [attributes] element");
                return;
            }
            if (this.attribute != null) {
                this.attributeStack.push(this.attribute);
            }
            this.attribute = new ModelAttribute();
            this.attribute.setId(attributes.getValue("id"));
            this.attribute.setValue(attributes.getValue("value"));
        } else if (!"requires".equals(name)) {
            if ("import".equals(name)) {
                this.prerequisite = new ModelPrerequisite();
                if (attributes.getValue("id") != null) {
                    this.prerequisite.setId(attributes.getValue("id"));
                }
                this.prerequisite.setPluginId(attributes.getValue("plugin-id"));
                if (attributes.getValue("plugin-version") != null) {
                    this.prerequisite.setPluginVersion(attributes.getValue("plugin-version"));
                }
                if (attributes.getValue("match") != null) {
                    this.prerequisite.setMatchingRule(MatchingRule.fromCode(attributes.getValue("match")));
                } else {
                    this.prerequisite.setMatchingRule(MatchingRule.COMPATIBLE);
                }
                this.prerequisite.setExported(attributes.getValue("exported"));
                this.prerequisite.setOptional(attributes.getValue("optional"));
                this.prerequisite.setReverseLookup(attributes.getValue("reverse-lookup"));
            } else if (!"runtime".equals(name)) {
                if ("library".equals(name)) {
                    this.library = new ModelLibrary();
                    this.library.setId(attributes.getValue("id"));
                    this.library.setPath(attributes.getValue("path"));
                    this.library.setCodeLibrary(attributes.getValue("type"));
                    if (attributes.getValue("version") != null) {
                        this.library.setVersion(attributes.getValue("version"));
                    }
                } else if ("export".equals(name)) {
                    if (this.library == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[export] element found outside of [library] element");
                        }
                        this.log.warn((Object)"[export] element found outside of [library] element");
                        return;
                    }
                    this.library.getExports().add(attributes.getValue("prefix"));
                } else if ("extension-point".equals(name)) {
                    this.extensionPoint = new ModelExtensionPoint();
                    this.extensionPoint.setId(attributes.getValue("id"));
                    this.extensionPoint.setParentPluginId(attributes.getValue("parent-plugin-id"));
                    this.extensionPoint.setParentPointId(attributes.getValue("parent-point-id"));
                    if (attributes.getValue("extension-multiplicity") != null) {
                        this.extensionPoint.setExtensionMultiplicity(ExtensionMultiplicity.fromCode(attributes.getValue("extension-multiplicity")));
                    } else {
                        this.extensionPoint.setExtensionMultiplicity(ExtensionMultiplicity.ANY);
                    }
                    this.paramDefStack = new SimpleStack();
                } else if ("parameter-def".equals(name)) {
                    if (this.extensionPoint == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[parameter-def] element found outside of [extension-point] element");
                        }
                        this.log.warn((Object)"[parameter-def] element found outside of [extension-point] element");
                        return;
                    }
                    if (this.paramDef != null) {
                        this.paramDefStack.push(this.paramDef);
                    }
                    this.paramDef = new ModelParameterDef();
                    this.paramDef.setId(attributes.getValue("id"));
                    if (attributes.getValue("multiplicity") != null) {
                        this.paramDef.setMultiplicity(ParameterMultiplicity.fromCode(attributes.getValue("multiplicity")));
                    } else {
                        this.paramDef.setMultiplicity(ParameterMultiplicity.ONE);
                    }
                    if (attributes.getValue("type") != null) {
                        this.paramDef.setType(ParameterType.fromCode(attributes.getValue("type")));
                    } else {
                        this.paramDef.setType(ParameterType.STRING);
                    }
                    this.paramDef.setCustomData(attributes.getValue("custom-data"));
                    this.paramDef.setDefaultValue(attributes.getValue("default-value"));
                } else if ("extension".equals(name)) {
                    this.extension = new ModelExtension();
                    this.extension.setId(attributes.getValue("id"));
                    this.extension.setPluginId(attributes.getValue("plugin-id"));
                    this.extension.setPointId(attributes.getValue("point-id"));
                    this.extension.setOptional(attributes.getValue("optional"));
                    this.paramStack = new SimpleStack();
                } else if ("parameter".equals(name)) {
                    if (this.extension == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[parameter] element found outside of [extension] element");
                        }
                        this.log.warn((Object)"[parameter] element found outside of [extension] element");
                        return;
                    }
                    if (this.param != null) {
                        this.paramStack.push(this.param);
                    }
                    this.param = new ModelParameter();
                    this.param.setId(attributes.getValue("id"));
                    this.param.setValue(attributes.getValue("value"));
                } else if ("value".equals(name)) {
                    if (this.param == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[value] element found outside of [parameter] element");
                        }
                        this.log.warn((Object)"[value] element found outside of [parameter] element");
                        return;
                    }
                    this.paramValue = new StringBuilder();
                } else {
                    if (this.entityResolver != null) {
                        throw new SAXException("unexpected manifest element - [" + uri + "]/[" + localName + "]/[" + qName + "]");
                    }
                    this.log.warn((Object)("unexpected manifest element - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        String name;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("endElement - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
        }
        if (!"plugin".equals(name = qName) && !"plugin-fragment".equals(name)) {
            if ("doc".equals(name)) {
                if (this.param != null) {
                    this.param.setDocumentation(this.documentation);
                } else if (this.extension != null) {
                    this.extension.setDocumentation(this.documentation);
                } else if (this.paramDef != null) {
                    this.paramDef.setDocumentation(this.documentation);
                } else if (this.extensionPoint != null) {
                    this.extensionPoint.setDocumentation(this.documentation);
                } else if (this.library != null) {
                    this.library.setDocumentation(this.documentation);
                } else if (this.prerequisite != null) {
                    this.prerequisite.setDocumentation(this.documentation);
                } else if (this.attribute != null) {
                    this.attribute.setDocumentation(this.documentation);
                } else {
                    this.manifest.setDocumentation(this.documentation);
                }
                this.documentation = null;
            } else if (!"doc-ref".equals(name)) {
                if ("doc-text".equals(name)) {
                    this.documentation.setText(this.docText.toString());
                    this.docText = null;
                } else if ("attributes".equals(name)) {
                    this.attributeStack = null;
                } else if ("attribute".equals(name)) {
                    if (this.attributeStack.size() == 0) {
                        this.manifest.getAttributes().add(this.attribute);
                        this.attribute = null;
                    } else {
                        ModelAttribute temp = this.attribute;
                        this.attribute = this.attributeStack.pop();
                        this.attribute.getAttributes().add(temp);
                        temp = null;
                    }
                } else if (!"requires".equals(name)) {
                    if ("import".equals(name)) {
                        this.manifest.getPrerequisites().add(this.prerequisite);
                        this.prerequisite = null;
                    } else if (!"runtime".equals(name)) {
                        if ("library".equals(name)) {
                            this.manifest.getLibraries().add(this.library);
                            this.library = null;
                        } else if (!"export".equals(name)) {
                            if ("extension-point".equals(name)) {
                                this.manifest.getExtensionPoints().add(this.extensionPoint);
                                this.extensionPoint = null;
                                this.paramDefStack = null;
                            } else if ("parameter-def".equals(name)) {
                                if (this.paramDefStack.size() == 0) {
                                    this.extensionPoint.getParamDefs().add(this.paramDef);
                                    this.paramDef = null;
                                } else {
                                    ModelParameterDef temp = this.paramDef;
                                    this.paramDef = this.paramDefStack.pop();
                                    this.paramDef.getParamDefs().add(temp);
                                    temp = null;
                                }
                            } else if ("extension".equals(name)) {
                                this.manifest.getExtensions().add(this.extension);
                                this.extension = null;
                                this.paramStack = null;
                            } else if ("parameter".equals(name)) {
                                if (this.paramStack.size() == 0) {
                                    this.extension.getParams().add(this.param);
                                    this.param = null;
                                } else {
                                    ModelParameter temp = this.param;
                                    this.param = this.paramStack.pop();
                                    this.param.getParams().add(temp);
                                    temp = null;
                                }
                            } else if ("value".equals(name)) {
                                this.param.setValue(this.paramValue.toString());
                                this.paramValue = null;
                            } else {
                                this.log.warn((Object)("ignoring manifest element - [" + uri + "]/[" + localName + "]/[" + qName + "]"));
                            }
                        }
                    }
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.docText != null) {
            this.docText.append(ch, start, length);
        } else if (this.paramValue != null) {
            this.paramValue.append(ch, start, length);
        } else {
            if (this.entityResolver != null) {
                throw new SAXException("unexpected character data");
            }
            this.log.warn((Object)("ignoring character data - [" + new String(ch, start, length) + "]"));
        }
    }

    ModelPluginManifest getResult() {
        return this.manifest;
    }
}

