/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.positioners;

import java.awt.Point;
import java.awt.Rectangle;
import net.java.balloontip.positioners.BalloonTipPositioner;

public class CenteredPositioner
extends BalloonTipPositioner {
    protected int x = 0;
    protected int y = 0;
    protected boolean flipY = false;
    protected int preferredVerticalOffset;
    protected boolean orientationCorrection = true;
    protected boolean fixedAttachLocation = false;
    protected float attachLocationY = 0.0f;

    public CenteredPositioner(int vO) {
        this.preferredVerticalOffset = vO;
    }

    public int getPreferredVerticalOffset() {
        return this.preferredVerticalOffset;
    }

    public void setPreferredVerticalOffset(int preferredVerticalOffset) {
        this.preferredVerticalOffset = preferredVerticalOffset;
        this.balloonTip.getStyle().setVerticalOffset(preferredVerticalOffset);
    }

    public boolean isOrientationCorrected() {
        return this.orientationCorrection;
    }

    public void enableOrientationCorrection(boolean orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public boolean isFixedAttachLocation() {
        return this.fixedAttachLocation;
    }

    public void enableFixedAttachLocation(boolean fixedAttachLocation) {
        this.fixedAttachLocation = fixedAttachLocation;
    }

    public float getAttachLocationY() {
        return this.attachLocationY;
    }

    public void setAttachLocation(float attachLocationX, float attachLocationY) {
        this.attachLocationY = attachLocationY;
    }

    public Point getTipLocation() {
        int tipX = this.x + this.balloonTip.getWidth() / 2;
        int tipY = this.y + this.balloonTip.getHeight();
        if (this.flipY) {
            tipY = this.y;
        }
        return new Point(tipX, tipY);
    }

    public void determineAndSetLocation(Rectangle attached) {
        this.determineLocation(attached);
        this.balloonTip.getStyle().flip(false, this.flipY);
        this.balloonTip.setBounds(this.x, this.y, this.balloonTip.getPreferredSize().width, this.balloonTip.getPreferredSize().height);
        this.balloonTip.revalidate();
    }

    protected void determineLocation(Rectangle attached) {
        int balloonWidth = this.balloonTip.getPreferredSize().width;
        int balloonHeight = this.balloonTip.getPreferredSize().height;
        this.flipY = false;
        int hOffset = balloonWidth / 2;
        float attachLocationX = 0.5f;
        this.x = new Float((float)attached.x + (float)attached.width * attachLocationX).intValue() - hOffset;
        this.y = this.fixedAttachLocation ? new Float((float)attached.y + (float)attached.height * this.attachLocationY).intValue() - balloonHeight : attached.y - balloonHeight;
        if (this.orientationCorrection && this.y < 0) {
            this.flipY = true;
            this.y = this.fixedAttachLocation ? (this.y += balloonHeight) : attached.y + attached.height;
        }
        this.balloonTip.getStyle().setHorizontalOffset(hOffset);
    }

    protected void onStyleChange() {
        this.balloonTip.getStyle().setHorizontalOffset(this.getBalloonTip().getWidth() / 2);
        this.balloonTip.getStyle().setVerticalOffset(this.preferredVerticalOffset);
    }
}

