/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.tool.server.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MigrationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(MigrationUtils.class);

    private MigrationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateFromOldDatabase(File file, String string) throws IOException {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File file2 = new File(file, string + ".script");
        File file3 = new File(file, string + ".properties");
        if (!file3.isFile() || !file2.isFile()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file3);
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        String string2 = StringUtils.trimToEmpty((String)properties.getProperty("version"));
        if (string2.startsWith("2.2.")) {
            LOGGER.info("Migrating database '" + file.getAbsolutePath() + "' from " + string2 + " to " + "2.3.5" + ".");
            FileWriterWithEncoding fileWriterWithEncoding = null;
            File file4 = new File(file, file2.getName() + ".new");
            File file5 = new File(file, file2.getName() + ".old");
            Pattern pattern = Pattern.compile("SELECT ([\\w]*) INTO ([\\w]*) FROM ([\\w\\.]*) WHERE ([\\w]*)\\s?=\\s?CURRENT VALUE FOR ([\\w\\.]*);");
            try {
                fileWriterWithEncoding = new FileWriterWithEncoding(file4, "UTF-8");
                for (String string3 : FileUtils.readLines((File)file2, (String)"UTF-8")) {
                    Matcher matcher = pattern.matcher(string3);
                    while (matcher.find()) {
                        string3 = StringUtils.replace((String)string3, (String)matcher.group(0), (String)("SET " + matcher.group(2) + " = IDENTITY();"));
                    }
                    fileWriterWithEncoding.write(string3);
                    fileWriterWithEncoding.write(SystemUtils.LINE_SEPARATOR);
                }
                fileWriterWithEncoding.flush();
                IOUtils.closeQuietly((Writer)fileWriterWithEncoding);
                FileUtils.copyFile((File)file2, (File)file5);
                FileUtils.copyFile((File)file4, (File)file2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriterWithEncoding);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriterWithEncoding);
        }
    }
}

