/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.IdentityImpl;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginFragmentImpl
extends IdentityImpl
implements PluginFragment {
    private final PluginRegistry registry;
    private final ModelPluginFragment model;
    private Documentation<PluginFragment> doc;

    PluginFragmentImpl(PluginRegistry aRegistry, ModelPluginFragment aModel) throws ManifestProcessingException {
        super(aModel.getId());
        this.registry = aRegistry;
        this.model = aModel;
        if (this.model.getVendor() == null) {
            this.model.setVendor("");
        }
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "fragmentPliginIdIsBlank", this.getId());
        }
        if (this.getId().equals(this.model.getPluginId())) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidFragmentPluginId", this.getId());
        }
        if (this.model.getDocsPath() == null || this.model.getDocsPath().trim().length() == 0) {
            this.model.setDocsPath("docs");
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl<PluginFragmentImpl>(this, this.model.getDocumentation());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    ModelPluginFragment getModel() {
        return this.model;
    }

    @Override
    public String getUniqueId() {
        return this.registry.makeUniqueId(this.getId(), this.model.getVersion());
    }

    @Override
    public String getVendor() {
        return this.model.getVendor();
    }

    @Override
    public Version getVersion() {
        return this.model.getVersion();
    }

    @Override
    public String getPluginId() {
        return this.model.getPluginId();
    }

    @Override
    public Version getPluginVersion() {
        return this.model.getPluginVersion();
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean matches(PluginDescriptor descr) {
        return PluginPrerequisiteImpl.matches(this.model.getPluginVersion(), descr.getVersion(), this.model.getMatchingRule());
    }

    @Override
    public MatchingRule getMatchingRule() {
        return this.model.getMatchingRule();
    }

    @Override
    public Documentation<PluginFragment> getDocumentation() {
        return this.doc;
    }

    @Override
    public String getDocsPath() {
        return this.model.getDocsPath();
    }

    @Override
    public URL getLocation() {
        return this.model.getLocation();
    }

    @Override
    protected boolean isEqualTo(Identity idt) {
        if (!(idt instanceof PluginFragmentImpl)) {
            return false;
        }
        PluginFragmentImpl other = (PluginFragmentImpl)idt;
        return this.getUniqueId().equals(other.getUniqueId()) && this.getLocation().toExternalForm().equals(other.getLocation().toExternalForm());
    }

    public String toString() {
        return "{PluginFragment: uid=" + this.getUniqueId() + "}";
    }
}

