/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(ErrorHandler.class);

    public static void handleError(Throwable throwable) {
        ErrorHandler.handleError(throwable, null);
    }

    public static void handleError(Throwable throwable, Component component) {
        LOGGER.error(throwable.getLocalizedMessage(), throwable);
        try {
            ErrorHandler.showError(component, I18N.tr("technical error"), I18N.tr("technical error"), throwable);
        }
        catch (Exception exception) {
            ErrorHandler.showError(component, "Error message", "Error message", exception);
        }
    }

    public static void showError(Component component, String string, String string2, Throwable throwable) {
        if (throwable != null) {
            Window window = null;
            if (component != null) {
                window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            }
            DetailsDialog detailsDialog = null;
            detailsDialog = window instanceof Frame ? new DetailsDialog((Frame)window, string, 0) : (window instanceof Dialog ? new DetailsDialog((Dialog)window, string, 0) : new DetailsDialog(string, 0));
            if (string2 == null || string2.length() == 0) {
                detailsDialog.setMsgText(throwable.getMessage());
            } else {
                detailsDialog.setMsgText(string2);
            }
            detailsDialog.setDetailsText(ErrorHandler.getStackTrace(throwable));
            detailsDialog.setLocationRelativeTo(component);
            detailsDialog.setVisible(true);
            detailsDialog.requestFocus();
        } else {
            ErrorHandler.showError(component, string, string2);
        }
    }

    public static void showError(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private static class DetailsDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JLabel msg;
        private JTextArea details;

        public DetailsDialog(String string, int n) {
            super((Frame)null, string, false);
            this.setup(n);
        }

        public DetailsDialog(Frame frame, String string, int n) {
            super(frame, string, true);
            this.setup(n);
        }

        public DetailsDialog(Dialog dialog, String string, int n) {
            super(dialog, string, true);
            this.setup(n);
        }

        private void setup(int n) {
            this.setModal(true);
            this.msg = new JLabel();
            this.msg.setIcon(ErrorHandler.getIconForType(n));
            this.details = new JTextArea();
            this.details.setLineWrap(false);
            this.details.setWrapStyleWord(false);
            final JScrollPane jScrollPane = new JScrollPane(this.details);
            jScrollPane.setVisible(false);
            JButton jButton = new JButton(I18N.tr("OK"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DetailsDialog.this.dispose();
                }
            });
            final String string = I18N.tr("show details");
            final String string2 = I18N.tr("hide details");
            final JButton jButton2 = new JButton(string);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jScrollPane.isVisible()) {
                        jScrollPane.setVisible(false);
                        jButton2.setText(string);
                        DetailsDialog.this.doSizePack();
                    } else {
                        jScrollPane.setVisible(true);
                        jButton2.setText(string2);
                        DetailsDialog.this.doSizePack();
                    }
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 0));
            jPanel.add(jButton2);
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)this.msg, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel2.add((Component)jPanel, "South");
            jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setContentPane(jPanel2);
            this.doSizePack();
        }

        public void setMsgText(String string) {
            this.msg.setText(string);
            this.doSizePack();
        }

        public void setDetailsText(String string) {
            this.details.setText(string);
            this.doSizePack();
        }

        private void doSizePack() {
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            Point point = this.getParent().getLocation();
            this.setLocation(point.x + 25, point.y + 25);
            Point point2 = this.getLocation();
            int n = -1;
            int n2 = -1;
            if (dimension2.height + point2.y > dimension.height) {
                n2 = dimension.height - point2.y - 30;
            }
            if (dimension2.width + point2.x > dimension.width) {
                n = dimension.width - point2.x;
            }
            if (dimension2.width < 300) {
                n = 300;
            }
            if (dimension2.width > 640) {
                n = 750;
            }
            if (dimension2.height > 480) {
                n2 = 550;
            }
            if (n != -1 || n2 != -1) {
                this.setSize(new Dimension(n == -1 ? dimension2.width : n, n2 == -1 ? dimension2.height : n2));
                this.doLayout();
            }
        }
    }
}

