/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.DateUtil;
import bizcal.util.Interval;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateInterval
extends Interval {
    private static final long serialVersionUID = 1L;
    private long _duration;

    public DateInterval(Interval interval) {
        this.setStart(interval.getStart());
        this.setEndDate((Date)interval.getEnd());
        this.setIncludeStart(interval.isIncludeStart());
        this.setIncludeEnd(interval.isIncludeEnd());
    }

    public DateInterval() {
    }

    public DateInterval(Date date, Date date2) {
        this.setStartDate(date);
        this.setEndDate(date2);
    }

    public DateInterval(Date date) {
        Date date2 = DateUtil.round2Day(date);
        this.setStartDate(date2);
        Date date3 = DateUtil.getDiffDay(date2, 1);
        this.setEndDate(date3);
    }

    public DateInterval(Date date, int n) {
        this.setStartDate(date);
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTime(date);
        calendar.add(n, 1);
        this.setEndDate(calendar.getTime());
    }

    public DateInterval(Date date, int n, int n2) {
        this.setStartDate(date);
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTime(date);
        calendar.add(n, n2);
        this.setEndDate(calendar.getTime());
    }

    public DateInterval(Date date, long l) {
        this(date, new Date(date.getTime() + l));
    }

    public Date getStartDate() {
        return (Date)this.getStart();
    }

    public void setStartDate(Date date) {
        this.setStart(date);
    }

    public Date getEndDate() {
        return (Date)this.getEnd();
    }

    public void setEndDate(Date date) {
        this.setEnd(date);
        if (this.getStartDate() == null) {
            return;
        }
        if (date == null) {
            return;
        }
        long l = date.getTime() - this.getStartDate().getTime();
        long l2 = Math.abs(DateUtil.getDaylightSavingOffset(date)) - Math.abs(DateUtil.getDaylightSavingOffset(this.getStartDate()));
        this._duration = (long)((int)l) + l2;
    }

    public void setDuration(long l) {
        this._duration = l;
        this.setEnd(new Date(this.getStartDate().getTime() + l));
    }

    public long getDuration() {
        return this._duration;
    }

    public DateInterval intersection(DateInterval dateInterval) {
        Interval interval = this.intersection((Interval)dateInterval);
        return new DateInterval((Date)interval.getStart(), (Date)interval.getEnd());
    }

    public boolean isDayIn(Date date) {
        return this.getStartDate().before(date) && this.getEndDate().after(date);
    }

    public int getDiffInDays() {
        return (int)(DateUtil.getDiffDay(this.getStartDate(), this.getEndDate()) / 86400000L);
    }
}

