/*
 * Decompiled with CFR 0.152.
 */
package bizcal.web;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.util.DateInterval;
import bizcal.web.WebCalendarCallback;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ecs.Element;
import org.apache.ecs.html.Font;
import org.apache.ecs.html.Script;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;

public abstract class CalendarView {
    private CalendarViewConfig config;
    private CalendarModel _callback;
    private DateInterval interval;
    private WebCalendarCallback webCallback;

    public DateInterval getInterval() {
        return this.interval;
    }

    public void setInterval(DateInterval dateInterval) {
        this.interval = dateInterval;
    }

    public void setDescriptor(CalendarViewConfig calendarViewConfig) {
        CalendarViewConfig calendarViewConfig2 = calendarViewConfig;
        this.setCalendarCallback(calendarViewConfig2.getCallback());
    }

    public void setCalendarCallback(CalendarModel calendarModel) {
        this._callback = calendarModel;
    }

    protected CalendarModel getCalendarCallback() {
        return this._callback;
    }

    public abstract Element getContent() throws Exception;

    protected String fixLength(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        for (int i = string.length(); i < n; ++i) {
            string = string + "&nbsp;";
        }
        return string;
    }

    public TD createCell(Event event, DateInterval dateInterval, Calendar calendar, Date date) throws Exception {
        TD tD = new TD();
        Font font = new Font();
        tD.addElement((Element)font);
        font.addElement(event.getSummary());
        tD.setBgColor(this.toHTML(event.getColor()));
        if (event.isEditable()) {
            tD.setOnClick("openOld('eventid=" + event.getId() + "')");
            tD.setOnMouseOver("this.style.cursor='pointer'");
        } else if (event.isBackground()) {
            tD.setOnClick(this.getOpenNewStatement(calendar, date));
        }
        DateInterval dateInterval2 = new DateInterval(event.getStart(), event.getEnd());
        if (dateInterval.getStartDate().after(dateInterval2.getStartDate())) {
            dateInterval2.setStartDate(dateInterval.getStartDate());
        }
        if (dateInterval.getEndDate().before(dateInterval2.getEndDate())) {
            dateInterval2.setEndDate(dateInterval.getEndDate());
        }
        if (!event.isBackground()) {
            int n = (int)(dateInterval2.getDuration() / this.getResolution());
            tD.setRowSpan(n);
        }
        return tD;
    }

    public TD createFreeCell(Calendar calendar, Date date) throws Exception {
        TD tD = new TD();
        tD.setBgColor(this.toHTML(calendar.getColor()));
        if (calendar.isBlankIsAvailible()) {
            tD.setOnClick(this.getOpenNewStatement(calendar, date));
            tD.setOnMouseOver("this.style.cursor='pointer'");
        }
        return tD;
    }

    private String getOpenNewStatement(Calendar calendar, Date date) throws Exception {
        String string = this.getWebCallback().getStarttimeParamName();
        String string2 = this.getWebCallback().getCalendarParamName();
        String string3 = string2 + "=" + calendar.getId();
        string3 = string3 + "&" + string;
        string3 = string3 + "=\\\"" + date.getTime() + "\\\"";
        return "openNew('" + string3 + "')";
    }

    public Script getScript() throws Exception {
        Script script = new Script();
        script.setLanguage("JavaScript");
        String string = "newEvent";
        String string2 = this.getWebCallback().getDetailURL();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function openNew(keys)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\thref = '" + string2 + "?detail=true&popup=true&' + keys;\n");
        stringBuffer.append("\twindow.open(href, 'detail');\n");
        stringBuffer.append("}\n");
        stringBuffer.append("function openOld(keys)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\thref = '" + string2 + "?detail=true&popup=true&' + keys;\n");
        stringBuffer.append("\twindow.open(href, 'detail');\n");
        stringBuffer.append("}\n");
        script.addElement(stringBuffer.toString());
        return script;
    }

    protected List createSlots(List list, DateInterval dateInterval) throws Exception {
        int n = (int)(dateInterval.getDuration() / this.getResolution());
        ArrayList<Event> arrayList = new ArrayList<Event>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        for (Event event : list) {
            long l = event.getStart().getTime();
            int n2 = this.getSlotNo(l, dateInterval);
            while (l < event.getEnd().getTime()) {
                if (n2 >= 0 && n2 < n) {
                    Event event2 = (Event)arrayList.get(n2);
                    if (event2 != null) {
                        if (event2.getLevel() < event.getLevel()) {
                            arrayList.set(n2, event);
                        }
                    } else {
                        arrayList.set(n2, event);
                    }
                }
                l += this.getResolution();
                ++n2;
            }
        }
        return arrayList;
    }

    public int getSlotNo(long l, DateInterval dateInterval) throws Exception {
        long l2 = l - dateInterval.getStartDate().getTime();
        return (int)(l2 / this.getResolution());
    }

    protected long getResolution() throws Exception {
        return this.getCalendarCallback().getResolution();
    }

    private String toHTML(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(Integer.toString(color.getRed(), 16));
        stringBuffer.append(Integer.toString(color.getGreen(), 16));
        stringBuffer.append(Integer.toString(color.getBlue(), 16));
        return stringBuffer.toString();
    }

    public void setStartDate(Date date) throws Exception {
        this.setInterval(new DateInterval(date, 6));
    }

    protected TR createHeaderRow() throws Exception {
        TR tR = new TR();
        return tR;
    }

    protected TH createHeaderCell(String string) throws Exception {
        TH tH = new TH();
        Font font = new Font();
        font.addElement(string);
        tH.addElement((Element)font);
        return tH;
    }

    public void setWebCallback(WebCalendarCallback webCalendarCallback) {
        this.webCallback = webCalendarCallback;
    }

    protected WebCalendarCallback getWebCallback() {
        return this.webCallback;
    }

    protected CalendarViewConfig getConfig() {
        return this.config;
    }

    protected CalendarModel getModel() {
        return this._callback;
    }
}

