/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views;

import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.MonthView;
import bizcal.util.DateInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JToggleButton;
import lu.tudor.santec.bizcal.AbstractCalendarView;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.print.PrintUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MonthViewPanel
extends AbstractCalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonthViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(MonthViewPanel.class);
    private static final long serialVersionUID = 1L;
    private JToggleButton button = new JToggleButton(CalendarIcons.getMediumIcon("cal_month.png"));
    private MonthView monthView;
    private EventModel monthModel;
    public static final String VIEW_NAME = "MONTH_VIEW";

    public MonthViewPanel(EventModel eventModel) {
        this.button.setToolTipText(I18N.tr("month view"));
        this.setLayout(new BorderLayout());
        this.monthModel = eventModel;
        try {
            this.monthView = new MonthView(new CalendarViewConfig());
            this.monthView.setModel(this.monthModel);
            this.monthModel.addCalendarView(this.monthView);
            this.add((Component)this.monthView.getComponent(), "Center");
            this.monthView.refresh0();
        }
        catch (Exception exception) {
            LOGGER.error("Can't init month view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void addCalendarListener(CalendarListener calendarListener) {
        this.monthView.addListener(calendarListener);
    }

    @Override
    public JToggleButton getButton() {
        return this.button;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void dateChanged(Date date) {
        this.monthModel.setDate(date);
        try {
            this.monthView.refresh0();
        }
        catch (Exception exception) {
            LOGGER.error("Can't refresh month view.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void activeCalendarsChanged(Collection<NamedCalendar> collection) {
    }

    @Override
    public void selectedCalendarChanged(NamedCalendar namedCalendar) {
    }

    @Override
    public List<Event> getEvents() {
        try {
            DateInterval dateInterval = this.monthModel.getInterval();
            Date date = (Date)dateInterval.getStart();
            Date date2 = (Date)dateInterval.getEnd();
            List<Event> list = this.monthModel.getEvents(null);
            ArrayList<Event> arrayList = new ArrayList<Event>();
            if (list != null) {
                for (Event event : list) {
                    if (!event.getStart().after(date) || !event.getStart().before(date2)) continue;
                    arrayList.add(event);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void print(boolean bl) {
        PrintUtilities.printComponent(this, bl, true);
    }

    @Override
    public CalendarView getView() {
        return this.monthView;
    }
}

