/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFileAppender
extends FileAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFileAppender.class);
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Date currentDate;
    private long nextDateStamp;
    private String scheduledFilename;
    protected int maxBackupIndex = 7;

    public CustomFileAppender() {
        this.dateFormat.setTimeZone(GMT_TIMEZONE);
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.fileName != null) {
            File file = new File(this.fileName);
            this.currentDate = new Date(file.lastModified());
            this.nextDateStamp = CustomFileAppender.getNextDateStamp(this.currentDate);
            this.scheduledFilename = this.fileName + "." + this.dateFormat.format(this.currentDate);
            this.cleanUp();
        } else {
            LogLog.error((String)("File option is not set for appender [" + this.name + "]."));
        }
    }

    private void cleanUp() {
        String string = new File(this.fileName).getName();
        File file = new File(this.fileName).getParentFile();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Object[] objectArray = file.list();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                if (!((String)object).startsWith(string + ".")) continue;
                treeSet.add(object);
            }
        }
        Object[] objectArray2 = treeSet.toArray(new String[0]);
        for (int i = 0; i < objectArray2.length - this.maxBackupIndex; ++i) {
            File file2 = new File(file.getAbsolutePath(), (String)objectArray2[i]);
            if (!file2.isFile()) continue;
            LogLog.debug((String)("Cleanup -> " + file2.getAbsolutePath()));
            if (FileUtils.deleteQuietly((File)file2)) continue;
            LogLog.error((String)("Failed to remove [" + file2.getAbsolutePath() + "]."));
        }
    }

    private static Calendar getGmtCalendar() {
        return Calendar.getInstance(GMT_TIMEZONE);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int n) {
        this.maxBackupIndex = n;
    }

    private static long getNextDateStamp(Date date) {
        Calendar calendar = CustomFileAppender.getGmtCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(6, 1);
        return calendar.getTimeInMillis();
    }

    private void rollOver() {
        File file;
        String string = this.fileName + "." + this.dateFormat.format(this.currentDate);
        if (this.scheduledFilename.equals(string)) {
            return;
        }
        this.closeFile();
        File file2 = new File(this.scheduledFilename);
        if (file2.isFile() && !FileUtils.deleteQuietly((File)file2)) {
            LogLog.error((String)("Failed to remove [" + file2.getAbsolutePath() + "]."));
        }
        if ((file = new File(this.fileName)).renameTo(file2)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException iOException) {
            this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
        }
        this.scheduledFilename = string;
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        long l = System.currentTimeMillis();
        if (l >= this.nextDateStamp) {
            this.currentDate.setTime(l);
            this.nextDateStamp = CustomFileAppender.getNextDateStamp(this.currentDate);
            this.rollOver();
            this.cleanUp();
        }
        super.subAppend(loggingEvent);
    }
}

