/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlLocalDump {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlLocalDump.class);
    private static long stamp = System.currentTimeMillis();

    public static void dump(Connection connection, File file) throws IOException, SQLException {
        HSqlLocalDump.dump(connection, file, null);
    }

    public static void dump(Connection connection, File file, String string) throws IOException, SQLException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Can't create directory: " + file.getAbsolutePath());
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + "lobs");
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException("Can't create directory: " + file2.getAbsolutePath());
        }
        string = (String)StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)"dump");
        File file3 = new File(file.getAbsolutePath() + File.separator + string + ".script");
        HSqlLocalDump.dumpSchema(connection, file3);
        File file4 = new File(file.getAbsolutePath() + File.separator + "lobs.sql");
        HSqlLocalDump.dumpLobs(connection, file4, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpLobs(Connection connection, File file, File file2) throws IOException, SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = file.exists();
        try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file, "UTF-8", bl);){
            statement = connection.prepareStatement("SELECT * FROM information_schema.system_columns WHERE type_name IN (?, ?) AND table_cat IN (?) AND table_name IN (SELECT table_name FROM information_schema.system_tables WHERE table_type=?);");
            int n = 0;
            statement.setString(++n, "BLOB");
            statement.setString(++n, "CLOB");
            statement.setString(++n, "PUBLIC");
            statement.setString(++n, "TABLE");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString("table_cat");
                String string2 = resultSet.getString("table_schem");
                String string3 = resultSet.getString("table_name");
                String string4 = resultSet.getString("column_name");
                String string5 = resultSet.getString("type_name");
                HSqlLocalDump.dumpLobsFromColumn(connection, (Writer)fileWriterWithEncoding, file2, string, string2, string3, string4, string5);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    private static void dumpLobsFromColumn(Connection var0, Writer var1_1, File var2_2, String var3_3, String var4_4, String var5_5, String var6_6, String var7_7) throws SQLException {
        if (!"BLOB".equalsIgnoreCase(var7_7) && !"CLOB".equalsIgnoreCase(var7_7)) {
            HSqlLocalDump.LOGGER.warn("Column '" + var4_4 + "." + var5_5 + "." + var6_6 + "' is neither a BLOB nor a CLOB!");
            return;
        }
        var8_8 = HSqlLocalDump.getPrimaryKeys(var0, var3_3, var4_4, var5_5);
        if (ArrayUtils.isEmpty((Object[])var8_8)) {
            HSqlLocalDump.LOGGER.warn("Can't export LOBS from '" + var4_4 + "." + var5_5 + "." + var6_6 + "' without primary key!");
            return;
        }
        var9_9 = null;
        var10_10 = null;
        try {
            var11_11 = new ArrayList<Object>(Arrays.asList(var8_8));
            var11_11.add(var6_6);
            var9_9 = var0.prepareStatement("SELECT " + StringUtils.join(var11_11, (String)",") + " FROM " + var5_5 + " ORDER BY " + StringUtils.join((Object[])var8_8, (String)", ") + ";");
            var10_10 = var9_9.executeQuery();
            while (var10_10.next()) {
                var12_12 = new ArrayList<String>();
                var13_13 = false;
                for (Object var17_21 : var8_8) {
                    var18_22 = var10_10.getObject((String)var17_21);
                    if (var18_22 instanceof Number) {
                        var12_12.add((String)var17_21 + " = " + var18_22.toString());
                        continue;
                    }
                    if (var18_22 instanceof String) {
                        var12_12.add((String)var17_21 + " = '" + var18_22.toString() + "'");
                        continue;
                    }
                    if (var18_22 == null) {
                        HSqlLocalDump.LOGGER.warn("Empty primary key in '" + var4_4 + "." + var5_5 + "." + (String)var17_21 + "'");
                    } else {
                        HSqlLocalDump.LOGGER.warn("Unsupported type of primary key in '" + var4_4 + "." + var5_5 + "." + (String)var17_21 + "' (" + var18_22.getClass().getName() + ")");
                    }
                    var13_13 = true;
                    break;
                }
                if (var13_13) continue;
                try {
                    var14_14 /* !! */  = null;
                    if ("BLOB".equalsIgnoreCase(var7_7)) {
                        var15_17 = null;
                        try {
                            var15_17 = var10_10.getBlob(var6_6);
                            if (var15_17 == null) ** GOTO lbl64
                            var16_19 = HSqlLocalDump.writeBlob((Blob)var15_17, var2_2);
                            var17_21 = var16_19.getAbsolutePath().substring(var2_2.getParentFile().getAbsolutePath().length() + 1);
                            var14_14 /* !! */  = "LOAD_FILE('" + (String)var17_21 + "')";
                        }
                        finally {
                            if (var15_17 != null) {
                                var15_17.free();
                            }
                        }
                    } else {
                        if (!"CLOB".equalsIgnoreCase(var7_7)) continue;
                        var15_17 = null;
                        try {
                            var15_17 = var10_10.getClob(var6_6);
                            if (var15_17 != null) {
                                var16_20 = HSqlLocalDump.writeClob((Clob)var15_17, var2_2);
                                var17_21 = var16_20.getAbsolutePath().substring(var2_2.getParentFile().getAbsolutePath().length() + 1);
                                var14_14 /* !! */  = "LOAD_FILE('" + (String)var17_21 + "', '" + "UTF-8" + "')";
                            }
                        }
                        finally {
                            if (var15_17 != null) {
                                var15_17.free();
                            }
                        }
                    }
                    if (var14_14 /* !! */  == null) continue;
                    var1_1.write("UPDATE " + var4_4 + "." + var5_5 + " SET " + var6_6 + " = " + (String)var14_14 /* !! */  + " WHERE " + StringUtils.join(var12_12, (String)" AND ") + ";");
                    var1_1.write(System.lineSeparator());
                }
                catch (Exception var14_15) {
                    HSqlLocalDump.LOGGER.warn("Can't write LOB!");
                    HSqlLocalDump.LOGGER.warn("> table       : " + var4_4 + "." + var5_5);
                    HSqlLocalDump.LOGGER.warn("> lob column  : " + var6_6);
                    HSqlLocalDump.LOGGER.warn("> primary key : " + StringUtils.join(var12_12, (String)", "));
                    HSqlLocalDump.LOGGER.warn("> " + var14_15.getLocalizedMessage(), (Throwable)var14_15);
                }
            }
        }
        finally {
            if (var9_9 != null) {
                var9_9.close();
            }
            if (var10_10 != null) {
                var10_10.close();
            }
        }
    }

    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="The non-constant string is properly escaped.")
    private static void dumpSchema(Connection connection, File file) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SCRIPT '" + StringUtils.replace((String)file.getAbsolutePath(), (String)"'", (String)"\\'") + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getPrimaryKeys(Connection connection, String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            preparedStatement = connection.prepareStatement("SELECT column_name FROM information_schema.system_primarykeys WHERE table_cat = ? AND table_schem = ? AND table_name = ? ORDER BY key_seq ASC;");
            int n = 0;
            preparedStatement.setString(++n, string);
            preparedStatement.setString(++n, string2);
            preparedStatement.setString(++n, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("column_name"));
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            return stringArray;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        File file;
        File file2;
        String string;
        String string2 = stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
        String string3 = string = stringArray != null && stringArray.length > 1 ? stringArray[1] : null;
        if (StringUtils.isBlank((CharSequence)string2) || StringUtils.isBlank((CharSequence)string)) {
            LOGGER.error("Invalid parameters!");
            System.exit(1);
        }
        if ((file2 = new File(string)).isFile()) {
            LOGGER.error("Provided directory is a file: " + file2.getAbsolutePath());
            System.exit(1);
        }
        if (!(file = new File(file2.getAbsolutePath() + File.separator + System.currentTimeMillis())).exists() && !file.mkdirs()) {
            LOGGER.error("Can't create directory: " + file.getAbsolutePath());
            System.exit(1);
        }
        Connection connection = null;
        try {
            try {
                LOGGER.info("Connecting to database...");
                LOGGER.info("> at: " + string2);
                Class.forName("org.hsqldb.jdbc.JDBCDriver");
                connection = DriverManager.getConnection(string2);
            }
            catch (Exception exception) {
                LOGGER.error("Can't create database connection!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(1);
            }
            try {
                LOGGER.info("Save database dump...");
                LOGGER.info("> to: " + file.getAbsolutePath());
                HSqlLocalDump.dump(connection, file);
            }
            catch (Exception exception) {
                LOGGER.error("Can't save database dump!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                System.exit(1);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't close database connection!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File writeBlob(Blob blob, File file) throws IOException, SQLException {
        Object object = HSqlLocalDump.class;
        synchronized (HSqlLocalDump.class) {
            // ** MonitorExit[object] (shouldn't be in output)
            object = new File(file.getAbsolutePath() + File.separator + ++stamp + ".blob");
            try (FileOutputStream fileOutputStream = new FileOutputStream((File)object);){
                IOUtils.copy((InputStream)blob.getBinaryStream(), (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                Object object2 = object;
                return object2;
            }
            catch (IOException | SQLException fileOutputStream2) {
                FileUtils.deleteQuietly((File)object);
                throw fileOutputStream2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File writeClob(Clob clob, File file) throws IOException, SQLException {
        Object object = HSqlLocalDump.class;
        synchronized (HSqlLocalDump.class) {
            // ** MonitorExit[object] (shouldn't be in output)
            object = new File(file.getAbsolutePath() + File.separator + ++stamp + ".clob");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");){
                IOUtils.copy((Reader)clob.getCharacterStream(), (Writer)outputStreamWriter);
                ((Writer)outputStreamWriter).flush();
                Object object2 = object;
                return object2;
            }
            catch (IOException | SQLException outputStreamWriter2) {
                FileUtils.deleteQuietly((File)object);
                throw outputStreamWriter2;
            }
        }
    }
}

