/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImplItem
implements Serializable {
    private static final long serialVersionUID = 2757194514833214425L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImplItem.class);
    private final Map<String, Object> values = new HashMap<String, Object>();

    protected AbstractImplItem() {
    }

    public Object getValue(String string) {
        return this.getValue(string, null);
    }

    protected Object getValue(String string, Object object) {
        return this.values.containsKey(string) ? this.values.get(string) : object;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void merge(AbstractImplItem abstractImplItem) {
        this.getValues().putAll(abstractImplItem.getValues());
    }

    protected void putValue(String string, Object object) {
        if (object == null) {
            this.values.remove(string);
        } else {
            this.values.put(string, object);
        }
    }

    public static String selectAttribute(Element element, String string) {
        return AbstractImplItem.selectAttribute(element, string, null);
    }

    public static String selectAttribute(Element element, String string, String string2) {
        Node node = element.selectSingleNode("@" + string);
        return node != null ? node.getStringValue() : string2;
    }

    public static BigDecimal selectAttributeAsBigDecimal(Element element, String string) {
        return AbstractImplItem.selectAttributeAsBigDecimal(element, string, null);
    }

    public static BigDecimal selectAttributeAsBigDecimal(Element element, String string, BigDecimal bigDecimal) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? new BigDecimal(string2) : bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("invalid big-decimal for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage());
            return bigDecimal;
        }
    }

    public static BigInteger selectAttributeAsBigInteger(Element element, String string) {
        return AbstractImplItem.selectAttributeAsBigInteger(element, string, null);
    }

    public static BigInteger selectAttributeAsBigInteger(Element element, String string, BigInteger bigInteger) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? BigInteger.valueOf(Long.parseLong(string2)) : bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("invalid big-integer for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage());
            return bigInteger;
        }
    }

    public static Boolean selectAttributeAsBoolean(Element element, String string) {
        return AbstractImplItem.selectAttributeAsBoolean(element, string, null);
    }

    public static Boolean selectAttributeAsBoolean(Element element, String string, Boolean bl) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? Boolean.valueOf(string2) : bl;
        }
        catch (Exception exception) {
            LOGGER.warn("invalid boolean for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + exception.getLocalizedMessage());
            return bl;
        }
    }

    public static Currency selectAttributeAsCurrency(Element element, String string) {
        return AbstractImplItem.selectAttributeAsCurrency(element, string, null);
    }

    public static Currency selectAttributeAsCurrency(Element element, String string, Currency currency) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? Currency.getInstance(string2) : currency;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("invalid currency for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + illegalArgumentException.getLocalizedMessage());
            return currency;
        }
    }

    public static Date selectAttributeAsDate(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDate(element, string, null);
    }

    public static Date selectAttributeAsDate(Element element, String string, Date date) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? OpenEstateUtils.getXsdDateFormat().parse(string2) : date;
        }
        catch (ParseException parseException) {
            LOGGER.warn("invalid currency for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + parseException.getLocalizedMessage());
            return date;
        }
    }

    public static Date selectAttributeAsDateTime(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDateTime(element, string, null);
    }

    public static Date selectAttributeAsDateTime(Element element, String string, Date date) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? OpenEstateUtils.getXsdDateTimeFormat().parse(string2) : date;
        }
        catch (ParseException parseException) {
            LOGGER.warn("invalid currency for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + parseException.getLocalizedMessage());
            return date;
        }
    }

    public static Double selectAttributeAsDouble(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDouble(element, string, null);
    }

    public static Double selectAttributeAsDouble(Element element, String string, Double d) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? Double.valueOf(string2) : d;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("invalid float for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage());
            return d;
        }
    }

    public static Float selectAttributeAsFloat(Element element, String string) {
        return AbstractImplItem.selectAttributeAsFloat(element, string, null);
    }

    public static Float selectAttributeAsFloat(Element element, String string, Float f) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? Float.valueOf(string2) : f;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("invalid float for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage());
            return f;
        }
    }

    public static URI selectAttributeAsURI(Element element, String string) {
        return AbstractImplItem.selectAttributeAsURI(element, string, null);
    }

    public static URI selectAttributeAsURI(Element element, String string, URI uRI) {
        String string2 = AbstractImplItem.selectAttribute(element, string, null);
        try {
            return string2 != null ? new URI(string2) : uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("invalid URI for " + element.getName() + " = '" + (String)ObjectUtils.defaultIfNull((Object)string2, (Object)"") + "'");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage());
            return uRI;
        }
    }

    public static List<Node> selectChildElements(Element element) {
        return element != null ? new ArrayList(element.selectNodes("*")) : null;
    }
}

