/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoAreaLevel;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstateImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final long serialVersionUID = -2737172806495929689L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EstateImpl.class);
    public static final String XML_ATTRIB_ID = "Id";
    public static final String XML_ATTRIB_CONTACT_ID = "ContactId";
    public static final String XML_ATTRIB_CURRENCY = "Currency";
    public static final String XML_ATTRIB_GROUP_ID = "GroupId";
    public static final String XML_ATTRIB_HIDDEN_PRICES = "HiddenPrices";
    public static final String XML_ATTRIB_LANGUAGES = "Languages";
    public static final String XML_ATTRIB_PUBLIC_ID = "PublicId";
    public static final String XML_ATTRIB_PUBLISH_BEGIN = "PublishBegin";
    public static final String XML_ATTRIB_PUBLISH_END = "PublishEnd";
    private static final String OLD_XML_ATTRIB_TITLE = "Title";
    public static final String XML_ELEMENT = "Estate";
    public static final String XML_ELEMENT_ADDRESS = "Address";
    public static final String XML_ELEMENT_TITLE = "Title";
    public static final String XML_ELEMENT_TITLE_TEXT = "Text";
    public static final String XML_ELEMENT_TITLE_LANGUAGE = "Language";
    public static final String XML_ELEMENT_ATTACHMENT = "Attachment";
    public static final String XML_ELEMENT_LINK = "Link";
    public static final String XML_ELEMENT_ACTION = "Action";
    public static final String XML_ELEMENT_ATTRIBUTES = "Attributes";
    public static final String XML_ELEMENT_VALUES = "CustomValues";
    @Deprecated
    private static final String OLD_XML_ELEMENT_ADRESS = "Adress";
    private OpenEstateAction action = null;
    private AbstractTypeImpl typeSpec = null;
    private EstateAddressImpl address = this.createAddress();
    private Map<OpenEstateAttrib, AbstractAttribImpl> attributes = new EnumMap<OpenEstateAttrib, AbstractAttribImpl>(OpenEstateAttrib.class);
    private Map<String, String> titles = new HashMap<String, String>();
    private List<String> languages = new ArrayList<String>();
    private List<EstateAttachmentImpl> attachments = new ArrayList<EstateAttachmentImpl>();
    private List<EstateLinkImpl> links = new ArrayList<EstateLinkImpl>();
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public EstateImpl() {
    }

    public EstateImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    protected EstateAddressImpl createAddress() {
        return new EstateAddressImpl();
    }

    protected EstateAttachmentImpl createAttachment() {
        return new EstateAttachmentImpl();
    }

    protected EstateLinkImpl createLink() {
        return new EstateLinkImpl();
    }

    public OpenEstateAction getAction() {
        return this.action;
    }

    public EstateAddressImpl getAddress() {
        return this.address;
    }

    public List<EstateAttachmentImpl> getAttachments() {
        return this.attachments;
    }

    public AbstractAttribImpl getAttribute(OpenEstateAttrib openEstateAttrib) {
        return openEstateAttrib != null && this.attributes != null && this.attributes.containsKey(openEstateAttrib) ? this.attributes.get(openEstateAttrib) : null;
    }

    public Map<OpenEstateAttrib, AbstractAttribImpl> getAttributes() {
        return this.attributes;
    }

    public String getContactId() {
        return (String)this.getValue(XML_ATTRIB_CONTACT_ID);
    }

    public Currency getCurrency() {
        return (Currency)this.getValue(XML_ATTRIB_CURRENCY);
    }

    public GeoAreaImpl getCustomGeoArea(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        String string2 = "geodb." + string + ".";
        GeoAreaImpl geoAreaImpl = null;
        if (this.getCustomValues().hasCustomValue(string2 + "area.id")) {
            geoAreaImpl = new GeoAreaImpl();
            geoAreaImpl.setId(this.getCustomValues().getCustomValue(string2 + "area.id").getString());
        }
        if (this.getCustomValues().hasCustomValue(string2 + "area.providerId")) {
            if (geoAreaImpl == null) {
                geoAreaImpl = new GeoAreaImpl();
            }
            geoAreaImpl.setProviderId(this.getCustomValues().getCustomValue(string2 + "area.providerId").getString());
        }
        if (this.getCustomValues().hasCustomValue(string2 + "area.name")) {
            if (geoAreaImpl == null) {
                geoAreaImpl = new GeoAreaImpl();
            }
            geoAreaImpl.setName(this.getCustomValues().getCustomValue(string2 + "area.name").getString());
        }
        if (this.getCustomValues().hasCustomValue(string2 + "area.level")) {
            if (geoAreaImpl == null) {
                geoAreaImpl = new GeoAreaImpl();
            }
            geoAreaImpl.setLevel(this.getCustomValues().getCustomValue(string2 + "area.level").getString());
        }
        return geoAreaImpl;
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public String getFallbackTitle() {
        return this.getFallbackTitle(Locale.getDefault());
    }

    public String getFallbackTitle(Locale locale) {
        if (this.typeSpec == null) {
            return "";
        }
        String string = this.typeSpec.getTranslation(locale);
        String string2 = this.action != null ? this.action.getTranslation(locale) : null;
        return StringUtils.isBlank((CharSequence)string2) ? string : string + " / " + string2;
    }

    public String getGroupId() {
        return (String)this.getValue(XML_ATTRIB_GROUP_ID);
    }

    public String getId() {
        return (String)this.getValue(XML_ATTRIB_ID);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public List<EstateLinkImpl> getLinks() {
        return this.links;
    }

    public List<OpenEstateAttrib> getMissingRequiredAttributes() {
        if (this.typeSpec == null) {
            throw new NullPointerException("No estate type was specified!");
        }
        if (this.action == null) {
            throw new NullPointerException("No estate action was specified!");
        }
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (OpenEstateAttrib openEstateAttrib : this.typeSpec.getAttribs(this.action)) {
            AbstractAttribImpl abstractAttribImpl;
            if (!this.typeSpec.isAttribRequired(openEstateAttrib) || (abstractAttribImpl = this.getAttribute(openEstateAttrib)) != null && !abstractAttribImpl.hasEmptyValue()) continue;
            arrayList.add(openEstateAttrib);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public AreaValue getPrimaryAreaValue() {
        if (this.typeSpec == null) {
            return null;
        }
        OpenEstateAttrib openEstateAttrib = this.typeSpec.getPrimaryAreaAttrib();
        AbstractAttribImpl abstractAttribImpl = this.getAttribute(openEstateAttrib);
        return abstractAttribImpl instanceof ComplexAreaAttrib ? ((ComplexAreaAttrib)abstractAttribImpl).getValue() : null;
    }

    public CurrencyValue getPrimaryPriceValue() {
        if (this.typeSpec == null) {
            return null;
        }
        OpenEstateAttrib openEstateAttrib = this.typeSpec.getPrimaryPriceAttrib(this.action);
        AbstractAttribImpl abstractAttribImpl = this.getAttribute(openEstateAttrib);
        return abstractAttribImpl instanceof ComplexCurrencyAttrib ? ((ComplexCurrencyAttrib)abstractAttribImpl).getValue() : null;
    }

    public String getPublicId() {
        return (String)this.getValue(XML_ATTRIB_PUBLIC_ID);
    }

    public Date getPublishBegin() {
        return (Date)this.getValue(XML_ATTRIB_PUBLISH_BEGIN);
    }

    public Date getPublishEnd() {
        return (Date)this.getValue(XML_ATTRIB_PUBLISH_END);
    }

    public String getTitle() {
        return this.getTitle(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.getLanguage());
    }

    public String getTitle(String string) {
        if (string != null && this.titles.containsKey(string)) {
            return this.titles.get(string);
        }
        return null;
    }

    public String[] getTitleLanguages() {
        return this.titles.keySet().toArray(new String[0]);
    }

    public synchronized OpenEstateType getType() {
        return this.typeSpec != null ? this.typeSpec.getType() : null;
    }

    public AbstractTypeImpl getTypeSpec() {
        return this.typeSpec;
    }

    public boolean hasAttribute(String string, String string2) {
        try {
            return StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && this.hasAttribute(OpenEstateAttrib.valueOf(string + "_" + string2));
        }
        catch (Exception exception) {
            LOGGER.warn("Unknown attribute \"" + string + " / " + string2 + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean hasAttribute(OpenEstateAttrib openEstateAttrib) {
        return openEstateAttrib != null && this.attributes.containsKey(openEstateAttrib);
    }

    public boolean isAddressPublished() {
        return this.address != null && this.address.isPublished();
    }

    @Deprecated
    public boolean isAdressPublished() {
        return this.isAddressPublished();
    }

    public boolean isHiddenPrices() {
        return (Boolean)this.getValue(XML_ATTRIB_HIDDEN_PRICES, Boolean.FALSE);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        super.merge(abstractImplItem);
        if (abstractImplItem instanceof EstateImpl) {
            EstateImpl estateImpl = (EstateImpl)abstractImplItem;
            this.action = estateImpl.getAction();
            this.titles.putAll(estateImpl.titles);
            this.languages.addAll(estateImpl.languages);
            this.typeSpec = estateImpl.getTypeSpec();
            this.address.merge(estateImpl.getAddress());
            this.attributes.putAll(estateImpl.attributes);
            this.attachments.addAll(estateImpl.getAttachments());
            this.customValues.merge(estateImpl.getCustomValues());
            this.setGroupId(StringUtils.trimToNull((String)estateImpl.getGroupId()));
            this.updateCurrencyAttributes();
        }
    }

    public void putAttribute(AbstractAttribImpl abstractAttribImpl) {
        if (abstractAttribImpl != null) {
            if (abstractAttribImpl.hasEmptyValue()) {
                this.removeAttribute(abstractAttribImpl.getAttrib());
            } else {
                ComplexCurrencyAttrib complexCurrencyAttrib;
                CurrencyValue currencyValue;
                if (abstractAttribImpl instanceof ComplexCurrencyAttrib && (currencyValue = (complexCurrencyAttrib = (ComplexCurrencyAttrib)abstractAttribImpl).getValue()) != null) {
                    currencyValue.setUnit(this.getCurrency());
                    complexCurrencyAttrib.setValue(currencyValue);
                }
                this.attributes.put(abstractAttribImpl.getAttrib(), abstractAttribImpl);
            }
        }
    }

    public void putCustomGeoArea(String string, GeoAreaImpl geoAreaImpl) {
        if (geoAreaImpl != null) {
            this.putCustomGeoArea(string, geoAreaImpl.getId(), geoAreaImpl.getProviderId(), geoAreaImpl.getName(), geoAreaImpl.getLevel());
        } else {
            this.removeCustomGeoArea(string);
        }
    }

    public void putCustomGeoArea(String string, String string2, String string3, String string4, GeoAreaLevel geoAreaLevel) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return;
        }
        String string5 = "geodb." + string + ".";
        if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
            this.removeCustomGeoArea(string);
            return;
        }
        this.getCustomValues().putCustomValue(string5 + "area.id", String.valueOf(string2), 5);
        string3 = StringUtils.trimToNull((String)string3);
        if (string3 != null) {
            this.getCustomValues().putCustomValue(string5 + "area.providerId", string3, 5);
        }
        if ((string4 = StringUtils.trimToNull((String)string4)) != null) {
            this.getCustomValues().putCustomValue(string5 + "area.name", string4, 5);
        }
        if (geoAreaLevel != null) {
            this.getCustomValues().putCustomValue(string5 + "area.level", geoAreaLevel.name(), 5);
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public synchronized void readFromXml(Element element) throws DocumentException {
        String string;
        Object object;
        Node node2;
        Object object4;
        String string2;
        String[] stringArray;
        this.setId(EstateImpl.selectAttribute(element, XML_ATTRIB_ID, null));
        this.setPublicId(EstateImpl.selectAttribute(element, XML_ATTRIB_PUBLIC_ID, null));
        this.setGroupId(EstateImpl.selectAttribute(element, XML_ATTRIB_GROUP_ID, null));
        this.setContactId(EstateImpl.selectAttribute(element, XML_ATTRIB_CONTACT_ID, ""));
        this.setCurrency(EstateImpl.selectAttributeAsCurrency(element, XML_ATTRIB_CURRENCY));
        this.setPublishBegin(EstateImpl.selectAttributeAsDate(element, XML_ATTRIB_PUBLISH_BEGIN));
        this.setPublishEnd(EstateImpl.selectAttributeAsDate(element, XML_ATTRIB_PUBLISH_END));
        this.setHiddenPrices(EstateImpl.selectAttributeAsBoolean(element, XML_ATTRIB_HIDDEN_PRICES, Boolean.FALSE));
        this.getLanguages().clear();
        String string3 = StringUtils.trimToNull((String)EstateImpl.selectAttribute(element, XML_ATTRIB_LANGUAGES));
        boolean bl = false;
        if (string3 != null) {
            bl = true;
            stringArray = string3.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = stringArray[i];
                object4 = string2.trim();
                if (((String)object4).length() != 2) continue;
                this.getLanguages().add(((String)object4).toLowerCase());
            }
        }
        if (!StringUtils.isBlank((CharSequence)(stringArray = EstateImpl.selectAttribute(element, "Title", "")))) {
            this.setTitle((String)stringArray);
        }
        this.links.clear();
        this.attachments.clear();
        OpenEstateType openEstateType = null;
        string2 = null;
        for (Node object32 : EstateImpl.selectChildElements(element)) {
            if (XML_ELEMENT_ADDRESS.equals(object32.getName())) {
                this.getAddress().readFromXml((Element)object32);
                continue;
            }
            if (OLD_XML_ELEMENT_ADRESS.equals(object32.getName())) {
                this.getAddress().readFromXml((Element)object32);
                continue;
            }
            if ("Title".equals(object32.getName())) {
                for (Node node2 : EstateImpl.selectChildElements((Element)object32)) {
                    if (!XML_ELEMENT_TITLE_TEXT.equals(node2.getName()) || ((String)(object = EstateImpl.selectAttribute((Element)node2, XML_ELEMENT_TITLE_LANGUAGE, "").trim().toLowerCase())).length() != 2) continue;
                    string = node2.getStringValue();
                    if (!StringUtils.isBlank((CharSequence)string)) {
                        this.setTitle(StringEscapeUtils.unescapeHtml4((String)string.trim()), (String)object);
                    } else {
                        this.setTitle(null, (String)object);
                    }
                    if (bl) continue;
                    this.getLanguages().add((String)object);
                }
                continue;
            }
            if (XML_ELEMENT_ATTACHMENT.equals(object32.getName())) {
                EstateAttachmentImpl estateAttachmentImpl = this.createAttachment();
                estateAttachmentImpl.readFromXml((Element)object32);
                this.attachments.add(estateAttachmentImpl);
                continue;
            }
            if (XML_ELEMENT_LINK.equals(object32.getName())) {
                EstateLinkImpl estateLinkImpl = this.createLink();
                estateLinkImpl.readFromXml((Element)object32);
                this.links.add(estateLinkImpl);
                continue;
            }
            if (XML_ELEMENT_VALUES.equals(object32.getName())) {
                this.customValues.readFromXml((Element)object32);
                continue;
            }
            openEstateType = OpenEstateUtils.lookupEstate(OpenEstateUtils.makeUnCamelCase(object32.getName()));
            string2 = (DefaultElement)object32;
        }
        if (string2 == null) {
            throw new DocumentException("Can't find estate type node of object '" + this.getId() + "'!");
        }
        if (openEstateType == null) {
            throw new DocumentException("Can't find estate type of object '" + this.getId() + "'!");
        }
        object4 = new ArrayList<Node>();
        for (Node node3 : EstateImpl.selectChildElements((Element)string2)) {
            if (XML_ELEMENT_ACTION.equals(node3.getName())) {
                node2 = node3.selectSingleNode("*");
                OpenEstateAction openEstateAction = OpenEstateUtils.lookupAction(OpenEstateUtils.makeUnCamelCase(node2.getName()));
                try {
                    this.setType(openEstateType, openEstateAction);
                    ((ArrayList)object4).addAll(EstateImpl.selectChildElements((Element)node2));
                    continue;
                }
                catch (Exception exception) {
                    throw new DocumentException("Can't read estate type!", (Throwable)exception);
                }
            }
            if (XML_ELEMENT_ATTRIBUTES.equals(node3.getName())) {
                ((ArrayList)object4).addAll(EstateImpl.selectChildElements((Element)node3));
                continue;
            }
            throw new DocumentException("Unknown XML element '" + node3.getName() + "' of object '" + this.getId() + "'!");
        }
        Iterator iterator = ((ArrayList)object4).iterator();
        while (iterator.hasNext()) {
            Node node4 = (Node)iterator.next();
            node2 = (DefaultElement)node4;
            object = node2.getName().split("_");
            if (((String[])object).length < 2) continue;
            string = OpenEstateUtils.makeUnCamelCase(object[0]);
            OpenEstateAttribGroup openEstateAttribGroup = OpenEstateUtils.lookupAttribGroup(string);
            if (openEstateAttribGroup == null) {
                LOGGER.warn("Unsupported attribute group '" + string + "' of object '" + this.getId() + "'!");
                continue;
            }
            String string4 = OpenEstateUtils.makeUnCamelCase((String)object[1]);
            OpenEstateAttrib openEstateAttrib = OpenEstateUtils.lookupAttrib(string, string4);
            if (openEstateAttrib == null) {
                LOGGER.warn("Unsupported attribute '" + string + " / " + string4 + "' of object '" + this.getId() + "'!");
                continue;
            }
            if (!this.typeSpec.hasAttrib(openEstateAttrib)) {
                LOGGER.warn("Unsupported attribute '" + string + " / " + string4 + "' by estate type '" + this.typeSpec.getName() + "' of object '" + this.getId() + "'!");
                continue;
            }
            try {
                AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
                if (abstractAttribImpl == null) {
                    throw new Exception("Can't create attribute (" + openEstateAttrib + ")!");
                }
                abstractAttribImpl.readFromXml((Element)node2);
                if (abstractAttribImpl.hasEmptyValue()) {
                    LOGGER.warn("Can't read value for attribute '" + string + " / " + string4 + "' of object '" + this.getId() + "'!");
                    continue;
                }
                this.attributes.put(openEstateAttrib, abstractAttribImpl);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read attribute '" + string + " / " + string4 + "' of object '" + this.getId() + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public AbstractAttribImpl removeAttribute(OpenEstateAttrib openEstateAttrib) {
        return openEstateAttrib != null && this.attributes != null && this.attributes.containsKey(openEstateAttrib) ? this.attributes.remove(openEstateAttrib) : null;
    }

    public void removeCustomGeoArea(String string) {
        String[] stringArray;
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return;
        }
        String string2 = "geodb." + string + ".";
        Map<String, CustomValueImpl> map = this.getCustomValues().getValueMap();
        for (String string3 : stringArray = map.keySet().toArray(new String[0])) {
            if (!string3.startsWith(string2)) continue;
            map.remove(string3);
        }
    }

    public void removeCustomGeoAreas() {
        String[] stringArray;
        String string = "geodb.";
        Map<String, CustomValueImpl> map = this.getCustomValues().getValueMap();
        for (String string2 : stringArray = map.keySet().toArray(new String[0])) {
            if (!string2.startsWith(string)) continue;
            map.remove(string2);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        AbstractAttribImpl abstractAttribImpl;
        Object object;
        Object object2;
        String string;
        DateFormat dateFormat = OpenEstateUtils.getXsdDateFormat();
        element.addAttribute(XML_ATTRIB_ID, this.getId());
        element.addAttribute(XML_ATTRIB_HIDDEN_PRICES, Boolean.toString(this.isHiddenPrices()));
        if (this.getPublicId() != null) {
            element.addAttribute(XML_ATTRIB_PUBLIC_ID, this.getPublicId());
        }
        if (this.getGroupId() != null) {
            element.addAttribute(XML_ATTRIB_GROUP_ID, this.getGroupId());
        }
        if (this.getContactId() != null) {
            element.addAttribute(XML_ATTRIB_CONTACT_ID, this.getContactId());
        }
        if (this.getCurrency() != null) {
            element.addAttribute(XML_ATTRIB_CURRENCY, this.getCurrency().getCurrencyCode());
        }
        if (this.getPublishBegin() != null) {
            element.addAttribute(XML_ATTRIB_PUBLISH_BEGIN, dateFormat.format(this.getPublishBegin()));
        }
        if (this.getPublishEnd() != null) {
            element.addAttribute(XML_ATTRIB_PUBLISH_END, dateFormat.format(this.getPublishEnd()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String object52 : this.getLanguages()) {
            String string2;
            if (object52 == null || (string2 = object52.trim().toLowerCase()).length() != 2) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
        element.addAttribute(XML_ATTRIB_LANGUAGES, stringBuilder.toString());
        this.address.serializeToXml(element.addElement(XML_ELEMENT_ADDRESS));
        Element element2 = element.addElement("Title");
        for (Map.Entry<String, String> entry : this.titles.entrySet()) {
            string = entry.getKey();
            object2 = StringUtils.trimToNull((String)entry.getValue());
            object = element2.addElement(XML_ELEMENT_TITLE_TEXT);
            object.addAttribute(XML_ELEMENT_TITLE_LANGUAGE, string);
            object.setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)object2)));
        }
        Element element3 = element.addElement(this.getType().getTagName());
        Element element4 = element3.addElement(XML_ELEMENT_ACTION);
        string = element4.addElement(this.getAction().getTagName());
        object2 = new ArrayList();
        object = new TreeMap();
        for (OpenEstateAttrib openEstateAttrib : this.typeSpec.getAttribsByAction(this.getAction())) {
            if (!this.attributes.containsKey(openEstateAttrib) || (abstractAttribImpl = this.attributes.get(openEstateAttrib)) == null || abstractAttribImpl.hasEmptyValue()) continue;
            object.put(openEstateAttrib.getTagName(), openEstateAttrib);
            object2.add(openEstateAttrib);
        }
        for (Map.Entry entry : object.entrySet()) {
            String string3 = (String)entry.getKey();
            OpenEstateAttrib openEstateAttrib = (OpenEstateAttrib)entry.getValue();
            this.attributes.get(openEstateAttrib).serializeToXml(string.addElement(string3));
        }
        string = element3.addElement(XML_ELEMENT_ATTRIBUTES);
        object.clear();
        for (OpenEstateAttrib openEstateAttrib : this.typeSpec.getAttribs()) {
            if (!this.attributes.containsKey(openEstateAttrib) || object2.contains(openEstateAttrib) || (abstractAttribImpl = this.attributes.get(openEstateAttrib)) == null || abstractAttribImpl.hasEmptyValue()) continue;
            object.put(openEstateAttrib.getTagName(), openEstateAttrib);
        }
        for (Map.Entry entry : object.entrySet()) {
            String string4 = (String)entry.getKey();
            OpenEstateAttrib openEstateAttrib = (OpenEstateAttrib)entry.getValue();
            this.attributes.get(openEstateAttrib).serializeToXml(string.addElement(string4));
        }
        for (EstateAttachmentImpl estateAttachmentImpl : this.attachments) {
            estateAttachmentImpl.serializeToXml(element.addElement(XML_ELEMENT_ATTACHMENT));
        }
        for (EstateLinkImpl estateLinkImpl : this.links) {
            estateLinkImpl.serializeToXml(element.addElement(XML_ELEMENT_LINK));
        }
        if (!this.customValues.getValueMap().isEmpty()) {
            this.customValues.serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setAddressPublished(boolean bl) {
        this.address.setPublished(bl);
    }

    @Deprecated
    public void setAdressPublished(boolean bl) {
        this.setAddressPublished(bl);
    }

    public void setContactId(String string) {
        this.putValue(XML_ATTRIB_CONTACT_ID, string);
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            currency = Currency.getInstance("EUR");
        }
        this.putValue(XML_ATTRIB_CURRENCY, currency);
        this.updateCurrencyAttributes(currency);
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setGroupId(String string) {
        this.putValue(XML_ATTRIB_GROUP_ID, string);
    }

    public void setHiddenPrices(Boolean bl) {
        this.putValue(XML_ATTRIB_HIDDEN_PRICES, bl);
    }

    public void setId(String string) {
        this.putValue(XML_ATTRIB_ID, string);
    }

    public void setPrimaryAreaValue(AreaValue areaValue) {
        if (this.typeSpec == null) {
            throw new RuntimeException("No estate type was specified!");
        }
        OpenEstateAttrib openEstateAttrib = this.typeSpec.getPrimaryAreaAttrib();
        if (openEstateAttrib == null) {
            throw new RuntimeException("Can't find a primary area attribute for " + this.typeSpec.getName() + "!");
        }
        ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)openEstateAttrib.createImpl();
        if (complexAreaAttrib == null) {
            return;
        }
        if (areaValue != null) {
            complexAreaAttrib.setValue(areaValue);
        }
        this.putAttribute(complexAreaAttrib);
    }

    public void setPrimaryPriceValue(CurrencyValue currencyValue) {
        if (this.typeSpec == null) {
            throw new RuntimeException("No estate type was specified!");
        }
        OpenEstateAttrib openEstateAttrib = this.typeSpec.getPrimaryPriceAttrib(this.action);
        if (openEstateAttrib == null) {
            throw new RuntimeException("Can't find a primary price attribute for " + this.typeSpec.getName() + "!");
        }
        ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)openEstateAttrib.createImpl();
        if (complexCurrencyAttrib == null) {
            return;
        }
        if (currencyValue != null) {
            complexCurrencyAttrib.setValue(currencyValue);
        }
        this.putAttribute(complexCurrencyAttrib);
    }

    public void setPublicId(String string) {
        this.putValue(XML_ATTRIB_PUBLIC_ID, string);
    }

    public void setPublishBegin(Date date) {
        this.putValue(XML_ATTRIB_PUBLISH_BEGIN, date);
    }

    public void setPublishEnd(Date date) {
        this.putValue(XML_ATTRIB_PUBLISH_END, date);
    }

    public void setTitle(String string) {
        this.setTitle(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.getLanguage());
    }

    public void setTitle(String string, String string2) {
        if (string2 == null || string2.trim().length() != 2) {
            throw new IllegalArgumentException("Invalid language!");
        }
        if (!StringUtils.isBlank((CharSequence)string)) {
            this.titles.put(string2, string.trim());
        } else {
            this.titles.remove(string2);
        }
    }

    public void setType(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("An empty estate type was provided!");
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new IllegalArgumentException("An empty estate action was provided!");
        }
        this.setType(OpenEstateUtils.lookupEstate(string), OpenEstateUtils.lookupAction(string2));
    }

    public void setType(OpenEstateType openEstateType, OpenEstateAction openEstateAction) {
        if (openEstateType == null) {
            throw new IllegalArgumentException("An empty estate type was provided!");
        }
        if (openEstateAction == null) {
            throw new IllegalArgumentException("An empty estate action was provided!");
        }
        this.setType(openEstateType.createImpl(), openEstateAction);
    }

    public synchronized void setType(AbstractTypeImpl abstractTypeImpl, OpenEstateAction openEstateAction) {
        OpenEstateAttrib[] openEstateAttribArray;
        if (abstractTypeImpl == null) {
            throw new IllegalArgumentException("An empty estate type was provided!");
        }
        if (openEstateAction == null) {
            throw new IllegalArgumentException("An empty estate action was provided!");
        }
        if (!abstractTypeImpl.hasAction(openEstateAction)) {
            throw new IllegalArgumentException("The action \"" + openEstateAction + "\" is not supported by estate type \"" + abstractTypeImpl.getName() + "\"!");
        }
        this.typeSpec = abstractTypeImpl;
        this.action = openEstateAction;
        for (OpenEstateAttrib openEstateAttrib : openEstateAttribArray = this.attributes.keySet().toArray(new OpenEstateAttrib[0])) {
            if (abstractTypeImpl.hasAttrib(openEstateAttrib)) continue;
            LOGGER.debug("Remove unsupported attribute \"" + openEstateAttrib + "\"");
            this.attributes.remove(openEstateAttrib);
        }
    }

    private void updateCurrencyAttributes() {
        this.updateCurrencyAttributes(null);
    }

    private void updateCurrencyAttributes(Currency currency) {
        if (currency == null) {
            currency = this.getCurrency();
        }
        if (currency == null) {
            currency = Currency.getInstance("EUR");
        }
        for (AbstractAttribImpl abstractAttribImpl : this.attributes.values()) {
            ComplexCurrencyAttrib complexCurrencyAttrib;
            CurrencyValue currencyValue;
            if (!(abstractAttribImpl instanceof ComplexCurrencyAttrib) || (currencyValue = (complexCurrencyAttrib = (ComplexCurrencyAttrib)abstractAttribImpl).getValue()) == null) continue;
            currencyValue.setUnit(currency);
        }
    }
}

