/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstateLinkImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = -5101527275753732639L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EstateLinkImpl.class);
    private static final String XML_ATTRIB_PUBLISHED = "Published";
    private static final String XML_ELEMENT_TITLE = "Title";
    private static final String XML_ELEMENT_TITLE_TEXT = "Text";
    private static final String XML_ELEMENT_TITLE_LANGUAGE = "Language";
    private static final String XML_ELEMENT_WEB_LINK = "WebLink";
    private static final String XML_ELEMENT_PROVIDER_LINK = "ProviderLink";
    private Map<String, String> titles = new HashMap<String, String>();
    private URI webLink;
    private ProviderLink providerLink;

    public ProviderLink getProviderLink() {
        return this.providerLink;
    }

    public String getTitle() {
        return this.getTitle(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.getLanguage());
    }

    public String getTitle(String string) {
        if (string != null && this.titles.containsKey(string)) {
            return this.titles.get(string);
        }
        return null;
    }

    public String[] getTitleLanguages() {
        return this.titles.keySet().toArray(new String[0]);
    }

    public URI getUrl() {
        if (this.webLink != null) {
            return this.webLink;
        }
        if (this.providerLink != null) {
            return this.providerLink.getProvider().getUrlFromLinkId(this.providerLink.getLinkId());
        }
        return null;
    }

    public URI getWebLink() {
        return this.webLink;
    }

    public boolean isProviderLink() {
        return this.providerLink != null;
    }

    public boolean isPublished() {
        Object object = this.getValue(XML_ATTRIB_PUBLISHED);
        return object == null || Boolean.TRUE.equals(object);
    }

    public boolean isWebLink() {
        return this.webLink != null;
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setPublished(EstateLinkImpl.selectAttributeAsBoolean(element, XML_ATTRIB_PUBLISHED));
        for (Node node : EstateLinkImpl.selectChildElements(element)) {
            String string = StringUtils.trimToNull((String)node.getStringValue());
            if (XML_ELEMENT_TITLE.equals(node.getName()) && string != null) {
                for (Node node2 : EstateLinkImpl.selectChildElements((Element)node)) {
                    if (!XML_ELEMENT_TITLE_TEXT.equals(node2.getName())) continue;
                    String string2 = StringUtils.trimToNull((String)EstateLinkImpl.selectAttribute((Element)node2, XML_ELEMENT_TITLE_LANGUAGE));
                    String string3 = StringUtils.trimToNull((String)node2.getStringValue());
                    if (string2 == null || string2.length() != 2) continue;
                    if (string3 != null) {
                        this.setTitle(StringEscapeUtils.unescapeHtml4((String)string3), string2);
                        continue;
                    }
                    this.setTitle(null, string2);
                }
                continue;
            }
            if (XML_ELEMENT_WEB_LINK.equals(node.getName()) && string != null) {
                try {
                    this.setWebLink(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't read web link: " + string);
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
                continue;
            }
            if (!XML_ELEMENT_PROVIDER_LINK.equals(node.getName()) || string == null) continue;
            ProviderLink providerLink = new ProviderLink();
            providerLink.readFromXml((Element)node);
            this.setProviderLink(providerLink);
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        Object object;
        Element element2;
        if (element == null) {
            return;
        }
        element.addAttribute(XML_ATTRIB_PUBLISHED, String.valueOf(this.isPublished()));
        if (this.isWebLink()) {
            element2 = element.addElement(XML_ELEMENT_WEB_LINK);
            object = this.getWebLink();
            if (object != null) {
                element2.setText(((URI)object).toString());
            }
        } else if (this.isProviderLink()) {
            element2 = element.addElement(XML_ELEMENT_PROVIDER_LINK);
            object = this.getProviderLink();
            if (object != null) {
                ((ProviderLink)object).serializeToXml(element2);
            }
        }
        element2 = element.addElement(XML_ELEMENT_TITLE);
        for (Map.Entry entry : this.titles.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = StringUtils.trimToNull((String)((String)entry.getValue()));
            Element element3 = element2.addElement(XML_ELEMENT_TITLE_TEXT);
            element3.addAttribute(XML_ELEMENT_TITLE_LANGUAGE, string);
            element3.setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)string2)));
        }
    }

    public void setProviderLink(ProviderLink providerLink) {
        this.providerLink = providerLink;
        this.webLink = null;
    }

    public void setPublished(Boolean bl) {
        this.putValue(XML_ATTRIB_PUBLISHED, bl != null ? bl : Boolean.TRUE);
    }

    public void setTitle(String string) {
        this.setTitle(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.getLanguage());
    }

    public void setTitle(String string, String string2) {
        if ((string2 = StringUtils.trimToNull((String)string2)) == null || string2.length() != 2) {
            throw new IllegalArgumentException("Invalid language (" + string2 + ")!");
        }
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.titles.remove(string2);
        } else {
            this.titles.put(string2, string);
        }
    }

    public void setWebLink(URI uRI) {
        this.webLink = uRI;
        this.providerLink = null;
    }

    public static class ProviderLink
    extends AbstractImplItem
    implements SerializableXmlType {
        private static final long serialVersionUID = 3121038269519970026L;
        private static final String XML_ATTRIB_PROVIDER = "Provider";
        private static final String XML_ATTRIB_LINK_ID = "LinkId";

        public ProviderLink() {
        }

        public ProviderLink(String string, EstateLinkProvider estateLinkProvider) {
            this.setLinkId(string);
            this.setProvider(estateLinkProvider);
        }

        public String getLinkId() {
            return (String)this.getValue(XML_ATTRIB_LINK_ID);
        }

        public EstateLinkProvider getProvider() {
            String string = (String)this.getValue(XML_ATTRIB_PROVIDER);
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                if (!string.equalsIgnoreCase(estateLinkProvider.getXmlName())) continue;
                return estateLinkProvider;
            }
            return null;
        }

        public boolean isVideo() {
            EstateLinkProvider estateLinkProvider = this.getProvider();
            return estateLinkProvider != null && estateLinkProvider.getXmlName().toLowerCase().startsWith("video@");
        }

        @Override
        public void readFromXml(Element element) throws DocumentException {
            if (element == null) {
                return;
            }
            this.setLinkId(ProviderLink.selectAttribute(element, XML_ATTRIB_LINK_ID));
            String string = ProviderLink.selectAttribute(element, XML_ATTRIB_PROVIDER);
            for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                if (!estateLinkProvider.getXmlName().equalsIgnoreCase(string)) continue;
                this.setProvider(estateLinkProvider);
                break;
            }
        }

        @Override
        public void serializeToXml(Element element) throws DocumentException {
            if (element == null) {
                return;
            }
            element.addAttribute(XML_ATTRIB_LINK_ID, this.getLinkId());
            EstateLinkProvider estateLinkProvider = this.getProvider();
            if (estateLinkProvider != null) {
                element.addAttribute(XML_ATTRIB_PROVIDER, estateLinkProvider.getXmlName());
            }
        }

        public final void setLinkId(String string) {
            this.putValue(XML_ATTRIB_LINK_ID, string);
        }

        public final void setProvider(EstateLinkProvider estateLinkProvider) {
            this.putValue(XML_ATTRIB_PROVIDER, estateLinkProvider != null ? estateLinkProvider.getXmlName() : null);
        }
    }
}

