/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.GeoAreaLevel;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoAreaImpl
extends AbstractImplItem {
    private static final long serialVersionUID = 152411778409993910L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoAreaImpl.class);
    public static final GeoAreaLevel LEVEL_REGION = GeoAreaLevel.REGION;
    public static final GeoAreaLevel LEVEL_CITY = GeoAreaLevel.CITY;
    public static final GeoAreaLevel LEVEL_CITY_PART = GeoAreaLevel.CITY_PART;
    public static final String XML_ATTRIB_ID = "Id";
    public static final String XML_ATTRIB_LEVEL = "Level";
    public static final String XML_ATTRIB_NAME = "Name";
    public static final String XML_ATTRIB_OLD_ID = "OldId";
    public static final String XML_ATTRIB_PROVIDER_ID = "ProviderId";
    private static final String XML_ELEMENT_AREA = "Area";
    private final List<GeoAreaImpl> areas = new ArrayList<GeoAreaImpl>();

    public List<GeoAreaImpl> getAreas() {
        return this.areas;
    }

    public String getId() {
        return (String)this.getValue(XML_ATTRIB_ID);
    }

    public GeoAreaLevel getLevel() {
        return (GeoAreaLevel)((Object)this.getValue(XML_ATTRIB_LEVEL));
    }

    public String getName() {
        return (String)this.getValue(XML_ATTRIB_NAME);
    }

    public String getOldId() {
        return (String)this.getValue(XML_ATTRIB_OLD_ID);
    }

    public String getProviderId() {
        return (String)this.getValue(XML_ATTRIB_PROVIDER_ID);
    }

    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setId(GeoAreaImpl.selectAttribute(element, XML_ATTRIB_ID));
        this.setLevel(GeoAreaImpl.selectAttribute(element, XML_ATTRIB_LEVEL));
        this.setName(GeoAreaImpl.selectAttribute(element, XML_ATTRIB_NAME));
        this.setProviderId(GeoAreaImpl.selectAttribute(element, XML_ATTRIB_PROVIDER_ID));
        this.setOldId(GeoAreaImpl.selectAttribute(element, XML_ATTRIB_OLD_ID));
        for (Node node : GeoAreaImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_AREA.equals(node.getName())) continue;
            GeoAreaImpl geoAreaImpl = new GeoAreaImpl();
            geoAreaImpl.readFromXml((Element)node);
            this.areas.add(geoAreaImpl);
        }
    }

    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        if (this.getId() != null) {
            element.addAttribute(XML_ATTRIB_ID, this.getId());
        }
        if (this.getLevel() != null) {
            element.addAttribute(XML_ATTRIB_LEVEL, this.getLevel().toString());
        }
        if (this.getName() != null) {
            element.addAttribute(XML_ATTRIB_NAME, this.getName());
        }
        if (this.getProviderId() != null) {
            element.addAttribute(XML_ATTRIB_PROVIDER_ID, this.getProviderId());
        }
        if (this.getOldId() != null) {
            element.addAttribute(XML_ATTRIB_OLD_ID, this.getOldId());
        }
        for (GeoAreaImpl geoAreaImpl : this.getAreas()) {
            geoAreaImpl.serializeToXml(element.addElement(XML_ELEMENT_AREA));
        }
    }

    public void setId(String string) {
        this.putValue(XML_ATTRIB_ID, string);
    }

    public void setLevel(String string) {
        this.setLevel(string != null ? GeoAreaLevel.valueOf(string) : null);
    }

    public void setLevel(GeoAreaLevel geoAreaLevel) {
        this.putValue(XML_ATTRIB_LEVEL, (Object)geoAreaLevel);
    }

    public void setName(String string) {
        this.putValue(XML_ATTRIB_NAME, string);
    }

    public void setOldId(String string) {
        this.putValue(XML_ATTRIB_OLD_ID, string);
    }

    public void setProviderId(String string) {
        this.putValue(XML_ATTRIB_PROVIDER_ID, string);
    }
}

