/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.SerializableXmlType;
import com.openindex.openestate.impl.utils.Translatable;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttribImpl<ObjectType>
implements Serializable,
SerializableXmlType,
Translatable {
    private static final long serialVersionUID = -2059832406027697328L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAttribImpl.class);
    private final OpenEstateAttrib attrib;
    private final String[] countries;

    protected AbstractAttribImpl(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        this.attrib = openEstateAttrib;
        this.countries = stringArray != null && stringArray.length > 0 ? (String[])ArrayUtils.clone((Object[])stringArray) : null;
    }

    public final OpenEstateAttrib getAttrib() {
        return this.attrib;
    }

    @Deprecated
    public final OpenEstateAttribGroup getAttribGroup() {
        return this.getGroup();
    }

    public final String getAttribName() {
        return this.attrib.getAttribName();
    }

    public final String[] getCountries() {
        return (String[])ArrayUtils.clone((Object[])this.countries);
    }

    public abstract ObjectType getDefaultValue();

    public final String getFormattedValue() {
        return this.getFormattedValue(this.getValue(), null, null);
    }

    public final String getFormattedValue(Locale locale) {
        return this.getFormattedValue(this.getValue(), locale, null);
    }

    public final String getFormattedValue(String string) {
        return this.getFormattedValue(this.getValue(), null, string);
    }

    public final String getFormattedValue(Locale locale, String string) {
        return this.getFormattedValue(this.getValue(), locale, string);
    }

    public final String getFormattedValue(ObjectType ObjectType) {
        return this.getFormattedValue(ObjectType, null, null);
    }

    public final String getFormattedValue(ObjectType ObjectType, Locale locale) {
        return this.getFormattedValue(ObjectType, locale, null);
    }

    public final String getFormattedValue(ObjectType ObjectType, String string) {
        return this.getFormattedValue(ObjectType, null, string);
    }

    public abstract String getFormattedValue(ObjectType var1, Locale var2, String var3);

    public final OpenEstateAttribGroup getGroup() {
        return this.attrib.getGroup();
    }

    public final String getGroupName() {
        return this.attrib.getGroupName();
    }

    public final String getTagName() {
        return this.attrib.getTagName();
    }

    @Override
    public final String getTranslation() {
        return this.attrib.getTranslation();
    }

    @Override
    public final String getTranslation(Locale locale) {
        return this.attrib.getTranslation(locale);
    }

    public abstract ObjectType getValue();

    public boolean isCountrySpecific() {
        return !ArrayUtils.isEmpty((Object[])this.countries);
    }

    public boolean isCountrySupported(String string) {
        if (!this.isCountrySpecific()) {
            return true;
        }
        for (String string2 : this.countries) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmptyValue() {
        return this.getValue() == null;
    }

    @Override
    public abstract void readFromXml(Element var1) throws DocumentException;

    @Override
    public abstract void serializeToXml(Element var1) throws DocumentException;

    public abstract void setValue(ObjectType var1);
}

