/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.values.AreaValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexAreaAttrib
extends ComplexAttrib<AreaValue> {
    private static final long serialVersionUID = -5595499409738400104L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexAreaAttrib.class);
    private static final String XML_ATTRIB_UNIT = "Unit";
    private AreaValue value = null;

    public ComplexAreaAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public AreaValue getDefaultValue() {
        return new AreaValue(BigDecimal.ZERO, null);
    }

    protected static AreaValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return ComplexAreaAttrib.get(estateImpl, openEstateAttrib, AreaValue.Unit.getBaseUnit());
    }

    protected static AreaValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        try {
            ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexAreaAttrib == null) {
                return null;
            }
            AreaValue areaValue = complexAreaAttrib.getValue();
            return unit == null || unit == areaValue.getUnit() ? areaValue : new AreaValue(AreaValue.convert(areaValue, unit), unit);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as AreaValue!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? areaValue.getValue() : null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? areaValue.getValue().toBigInteger() : null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? Double.valueOf(areaValue.doubleValue()) : null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? Float.valueOf(areaValue.floatValue()) : null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? Integer.valueOf(areaValue.intValue()) : null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
        return areaValue != null ? Long.valueOf(areaValue.longValue()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit) {
        return ComplexAreaAttrib.getAsString(estateImpl, openEstateAttrib, unit, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue.Unit unit, Locale locale) {
        try {
            AreaValue areaValue = ComplexAreaAttrib.get(estateImpl, openEstateAttrib, unit);
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return areaValue != null && abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(areaValue, locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    @Override
    public String getFormattedValue(AreaValue areaValue, Locale locale, String string) {
        if (areaValue == null) {
            return "";
        }
        String string2 = OpenEstateUtils.isApproximatedAttributes() ? OpenEstateConstant.APPROX.getTranslation(locale) + " " : "";
        return string2 + this.getFormat(locale).format(areaValue.getValue()) + " " + areaValue.getUnit().write();
    }

    @Override
    public AreaValue getValue() {
        return this.value;
    }

    @Override
    protected AreaValue parseNode(Element element) {
        AreaValue.Unit unit;
        if (element == null) {
            return null;
        }
        Number number = OpenEstateUtils.parseNumber(element.getStringValue(), this.getFormat());
        Node node = element.selectSingleNode("@Unit");
        String string = StringUtils.trimToNull((String)(node != null ? node.getStringValue() : null));
        try {
            unit = string != null ? AreaValue.Unit.valueOf(string.toUpperCase()) : AreaValue.Unit.SQM;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse area unit \"" + string + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        return number != null ? AreaValue.parse(number, unit) : null;
    }

    @Override
    public AreaValue parseValue(Object object) {
        return AreaValue.parse(object);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, AreaValue.Unit unit) {
        ComplexAreaAttrib.put(estateImpl, openEstateAttrib, string != null ? AreaValue.parse(string, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number, AreaValue.Unit unit) {
        ComplexAreaAttrib.put(estateImpl, openEstateAttrib, number != null ? AreaValue.parse(number, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, AreaValue areaValue) {
        try {
            if (areaValue == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)openEstateAttrib.createImpl();
                if (complexAreaAttrib != null) {
                    complexAreaAttrib.setValue(areaValue);
                    estateImpl.putAttribute(complexAreaAttrib);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put area attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(AreaValue areaValue) {
        this.value = areaValue;
    }

    @Override
    protected void writeNode(Element element, AreaValue areaValue) {
        if (element == null || areaValue == null || areaValue.getValue() == null) {
            return;
        }
        try {
            element.setText(areaValue.getValue().toString());
            element.addAttribute(XML_ATTRIB_UNIT, areaValue.getUnit() != null ? areaValue.getUnit().name() : AreaValue.Unit.SQM.name());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write area attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

