/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.surroundings;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class Zone
extends SimpleEnumAttrib<Option> {
    public Zone() {
        super(OpenEstateAttrib.SURROUNDINGS_ZONE, null);
    }

    public Zone(Option option) {
        this();
        if (option != null) {
            this.setValue(option);
        }
    }

    public static Option get(EstateImpl estateImpl) {
        return (Option)Zone.get(estateImpl, OpenEstateAttrib.SURROUNDINGS_ZONE);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option = Zone.get(estateImpl);
        if (option != null) {
            arrayList.add(option);
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl) {
        return Zone.getAsString(estateImpl, OpenEstateAttrib.SURROUNDINGS_ZONE);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return Zone.getAsString(estateImpl, OpenEstateAttrib.SURROUNDINGS_ZONE, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public static void put(EstateImpl estateImpl, Option option) {
        Zone.put(estateImpl, OpenEstateAttrib.SURROUNDINGS_ZONE, option);
    }

    public static void put(EstateImpl estateImpl, String string) {
        Zone.put(estateImpl, OpenEstateAttrib.SURROUNDINGS_ZONE, string);
    }

    public static enum Option implements Translatable
    {
        RESIDENTIAL(I18n.marktr((String)"residential zone")),
        COMMERCIAL(I18n.marktr((String)"commercial zone")),
        INDUSTRIAL(I18n.marktr((String)"industrial zone")),
        MIXED(I18n.marktr((String)"mixed")),
        DEVELOPMENT(I18n.marktr((String)"development zone")),
        CITY(I18n.marktr((String)"city")),
        VILLAGE(I18n.marktr((String)"village")),
        SUBURBS(I18n.marktr((String)"suburbs")),
        DISTRICT(I18n.marktr((String)"district")),
        CITY_CENTER(I18n.marktr((String)"city center")),
        SUBSIDIARY_CENTER(I18n.marktr((String)"subsidiary center")),
        RURAL(I18n.marktr((String)"rural area")),
        VILLAGE_CENTER(I18n.marktr((String)"center of the village")),
        VILLAGE_EDGE(I18n.marktr((String)"edge of the village"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

