/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.EstateAttachmentType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbFile
implements Serializable {
    private static final long serialVersionUID = 7233331059983089340L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbFile.class);
    public long id = 0L;
    public long objectId = 0L;
    public long size = 0L;
    public int position = 0;
    public int imageHeight = 0;
    public int imageWidth = 0;
    public boolean published = true;
    public String name = null;
    public URI url = null;
    public String hash = null;
    public String mimeType = null;
    public EstateAttachmentType type = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public Map<String, Translation> translations = null;

    public int calculateHash() {
        int n = DbFile.class.getName().hashCode();
        n += Long.valueOf(this.id).hashCode();
        n += Long.valueOf(this.objectId).hashCode();
        n += Long.valueOf(this.size).hashCode();
        n += Integer.valueOf(this.position).hashCode();
        n += Integer.valueOf(this.imageHeight).hashCode();
        n += Integer.valueOf(this.imageWidth).hashCode();
        n += Boolean.valueOf(this.published).hashCode();
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.url != null) {
            n += this.url.toString().hashCode();
        }
        if (this.hash != null) {
            n += this.hash.hashCode();
        }
        if (this.mimeType != null) {
            n += this.mimeType.hashCode();
        }
        if (this.type != null) {
            n += this.type.hashCode();
        }
        if (this.translations != null) {
            n += this.translations.size();
            for (Map.Entry<String, Translation> entry : this.translations.entrySet()) {
                Translation translation;
                String string = entry.getKey();
                if (string != null) {
                    n += string.hashCode();
                }
                if ((translation = entry.getValue()) == null || translation.title == null) continue;
                n += translation.title.hashCode();
            }
        }
        return n;
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.toString());
    }

    public String getTitle(String string) {
        return this.translations != null && this.translations.containsKey(string) ? this.translations.get((Object)string).title : null;
    }

    public void initTranslations() {
        this.translations = new HashMap<String, Translation>();
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.toString());
    }

    public void setTitle(String string, String string2) {
        if (this.translations == null) {
            return;
        }
        if (string == null || string.trim().length() < 1) {
            this.translations.remove(string2);
        } else {
            if (!this.translations.containsKey(string2)) {
                this.translations.put(string2, new Translation());
            }
            this.translations.get((Object)string2).title = string;
        }
    }

    public static class Translation
    implements Serializable {
        private static final long serialVersionUID = 4307106881612157749L;
        public String title = null;
    }
}

