/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.types;

import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractTypeImpl
implements Serializable {
    private static final long serialVersionUID = -8862092728583240511L;
    private final OpenEstateType type;
    private final List<OpenEstateAction> supportedActions = new ArrayList<OpenEstateAction>();
    private final Map<OpenEstateAttrib, AttribRelation> supportedAttributes = new EnumMap<OpenEstateAttrib, AttribRelation>(OpenEstateAttrib.class);

    protected AbstractTypeImpl(OpenEstateType openEstateType) {
        this.type = openEstateType;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTypeImpl && this.type.equals(((AbstractTypeImpl)object).type);
    }

    public final OpenEstateAction[] getActions() {
        return this.supportedActions.toArray(new OpenEstateAction[0]);
    }

    public final OpenEstateAttrib[] getAttribs() {
        return this.getAttribs(null, null);
    }

    public final OpenEstateAttrib[] getAttribs(OpenEstateAction openEstateAction) {
        return this.getAttribs(openEstateAction, null);
    }

    public final OpenEstateAttrib[] getAttribs(OpenEstateAction openEstateAction, OpenEstateAttribGroup[] openEstateAttribGroupArray) {
        ArrayList<OpenEstateAttribGroup> arrayList = new ArrayList<OpenEstateAttribGroup>(Arrays.asList(openEstateAttribGroupArray != null ? openEstateAttribGroupArray : OpenEstateAttribGroup.values()));
        ArrayList<OpenEstateAttrib> arrayList2 = new ArrayList<OpenEstateAttrib>();
        for (AttribRelation attribRelation : this.supportedAttributes.values()) {
            if (!arrayList.contains(attribRelation.attrib.getGroup()) || openEstateAction != null && attribRelation.actions != null && !ArrayUtils.contains((Object[])attribRelation.actions, (Object)openEstateAction)) continue;
            arrayList2.add(attribRelation.attrib);
        }
        return arrayList2.toArray(new OpenEstateAttrib[0]);
    }

    public final OpenEstateAttrib[] getAttribsByAction(OpenEstateAction openEstateAction) {
        if (openEstateAction == null || !this.supportedActions.contains(openEstateAction)) {
            return new OpenEstateAttrib[0];
        }
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (AttribRelation attribRelation : this.supportedAttributes.values()) {
            if (attribRelation.actions == null || !ArrayUtils.contains((Object[])attribRelation.actions, (Object)openEstateAction)) continue;
            arrayList.add(attribRelation.attrib);
        }
        return arrayList.toArray(new OpenEstateAttrib[0]);
    }

    public final OpenEstateAttrib[] getAttribsByGroup(OpenEstateAttribGroup openEstateAttribGroup) {
        if (openEstateAttribGroup == null) {
            return new OpenEstateAttrib[0];
        }
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (AttribRelation attribRelation : this.supportedAttributes.values()) {
            if (!attribRelation.attrib.isGroup(openEstateAttribGroup)) continue;
            arrayList.add(attribRelation.attrib);
        }
        return arrayList.toArray(new OpenEstateAttrib[0]);
    }

    public final OpenEstateType[] getChildren() {
        return this.type.getChildTypes(false);
    }

    public final OpenEstateType[] getChildren(boolean bl) {
        return this.type.getChildTypes(bl);
    }

    public final String getName() {
        return this.type.name();
    }

    public final OpenEstateType getParent() {
        return this.type.getParentType();
    }

    public final OpenEstateAttrib getPrimaryAreaAttrib() {
        for (OpenEstateAttrib openEstateAttrib : this.getAttribsByGroup(OpenEstateAttribGroup.MEASURES)) {
            AbstractAttribImpl abstractAttribImpl;
            if (!this.isAttribRequired(openEstateAttrib) || !((abstractAttribImpl = openEstateAttrib.createImpl()) instanceof ComplexAreaAttrib)) continue;
            return openEstateAttrib;
        }
        return null;
    }

    public final OpenEstateAttrib getPrimaryPriceAttrib(OpenEstateAction openEstateAction) {
        if (openEstateAction == null) {
            return null;
        }
        for (OpenEstateAttrib openEstateAttrib : this.getAttribsByAction(openEstateAction)) {
            AbstractAttribImpl abstractAttribImpl;
            if (!this.isAttribRequired(openEstateAttrib) || !OpenEstateAttribGroup.PRICES.equals(openEstateAttrib.getGroup()) || !((abstractAttribImpl = openEstateAttrib.createImpl()) instanceof ComplexCurrencyAttrib)) continue;
            return openEstateAttrib;
        }
        return null;
    }

    public final String getTagName() {
        return this.type.getTagName();
    }

    public final String getTranslation() {
        return this.type.getTranslation();
    }

    public final String getTranslation(Locale locale) {
        return this.type.getTranslation(locale);
    }

    public final OpenEstateType getType() {
        return this.type;
    }

    public final boolean hasAction(OpenEstateAction openEstateAction) {
        return this.supportedActions.contains(openEstateAction);
    }

    @Deprecated
    public final boolean hasAttrib(String string, String string2) {
        return this.hasAttrib(OpenEstateUtils.lookupAttrib(string, string2));
    }

    public final boolean hasAttrib(OpenEstateAttrib openEstateAttrib) {
        return openEstateAttrib != null && this.supportedAttributes.containsKey(openEstateAttrib);
    }

    public final boolean hasChildren() {
        return this.type.hasChildTypes();
    }

    public int hashCode() {
        int n = 7;
        if (this.type != null) {
            n = 89 * n + this.type.hashCode();
        }
        return n;
    }

    public final boolean hasParent() {
        return this.type.hasParentType();
    }

    public final boolean isAttribGeneral(AbstractAttribImpl abstractAttribImpl) {
        return this.isAttribGeneral(abstractAttribImpl.getAttrib());
    }

    @Deprecated
    public final boolean isAttribGeneral(String string, String string2) {
        return this.isAttribGeneral(OpenEstateUtils.lookupAttrib(string, string2));
    }

    public final boolean isAttribGeneral(OpenEstateAttrib openEstateAttrib) {
        AttribRelation attribRelation = this.supportedAttributes.get(openEstateAttrib);
        return attribRelation != null && ArrayUtils.isEmpty((Object[])attribRelation.actions);
    }

    public final boolean isAttribRequired(AbstractAttribImpl abstractAttribImpl) {
        return this.isAttribRequired(abstractAttribImpl.getAttrib());
    }

    @Deprecated
    public final boolean isAttribRequired(String string, String string2) {
        return this.isAttribRequired(OpenEstateUtils.lookupAttrib(string, string2));
    }

    public final boolean isAttribRequired(OpenEstateAttrib openEstateAttrib) {
        AttribRelation attribRelation = this.supportedAttributes.get(openEstateAttrib);
        return attribRelation != null && attribRelation.required;
    }

    @Deprecated
    public static synchronized AbstractTypeImpl newInstance(String string) {
        OpenEstateType openEstateType = OpenEstateUtils.lookupEstate(string);
        return openEstateType != null ? openEstateType.createImpl() : null;
    }

    protected void registerSupportedAction(OpenEstateAction openEstateAction) {
        this.supportedActions.add(openEstateAction);
    }

    protected void registerSupportedAttribute(OpenEstateAttrib openEstateAttrib, boolean bl) {
        this.registerSupportedAttribute(openEstateAttrib, null, bl);
    }

    protected void registerSupportedAttribute(OpenEstateAttrib openEstateAttrib, OpenEstateAction[] openEstateActionArray, boolean bl) {
        if (openEstateAttrib == null) {
            throw new IllegalArgumentException("An empty attribute was provided!");
        }
        this.supportedAttributes.put(openEstateAttrib, new AttribRelation(openEstateAttrib, openEstateActionArray, bl));
    }

    private static class AttribRelation
    implements Serializable {
        private static final long serialVersionUID = 4065720219310081741L;
        private final OpenEstateAttrib attrib;
        private final OpenEstateAction[] actions;
        private final boolean required;

        private AttribRelation(OpenEstateAttrib openEstateAttrib, OpenEstateAction[] openEstateActionArray, boolean bl) {
            this.attrib = openEstateAttrib;
            this.actions = !ArrayUtils.isEmpty((Object[])openEstateActionArray) ? openEstateActionArray : null;
            this.required = bl;
        }
    }
}

