/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.utils.AbstractConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.openestate.io.core.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCsvReader<Parser extends CsvParser>
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCsvReader.class);

    protected abstract Parser createParser(InputStream var1) throws IOException;

    protected abstract Parser createParser(Reader var1) throws IOException;

    public final AgencyImpl readAgency(String string) throws IOException {
        try (StringReader stringReader = new StringReader(string);){
            AgencyImpl agencyImpl = this.readAgency(stringReader);
            return agencyImpl;
        }
    }

    public final AgencyImpl readAgency(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            AgencyImpl agencyImpl = this.readAgency(fileInputStream);
            return agencyImpl;
        }
    }

    public final AgencyImpl readAgency(InputStream inputStream) throws IOException {
        try (Parser Parser2 = this.createParser(inputStream);){
            AgencyImpl agencyImpl = this.readAgency(Parser2);
            return agencyImpl;
        }
    }

    public final AgencyImpl readAgency(Reader reader) throws IOException {
        try (Parser Parser2 = this.createParser(reader);){
            AgencyImpl agencyImpl = this.readAgency(Parser2);
            return agencyImpl;
        }
    }

    protected abstract AgencyImpl readAgency(Parser var1);

    public final TransferImpl readTransfer(String string) throws IOException {
        try (StringReader stringReader = new StringReader(string);){
            TransferImpl transferImpl = this.readTransfer(stringReader);
            return transferImpl;
        }
    }

    public final TransferImpl readTransfer(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            TransferImpl transferImpl = this.readTransfer(fileInputStream);
            return transferImpl;
        }
    }

    public final TransferImpl readTransfer(InputStream inputStream) throws IOException {
        try (Parser Parser2 = this.createParser(inputStream);){
            TransferImpl transferImpl = this.readTransfer(Parser2);
            return transferImpl;
        }
    }

    public final TransferImpl readTransfer(Reader reader) throws IOException {
        try (Parser Parser2 = this.createParser(reader);){
            TransferImpl transferImpl = this.readTransfer(Parser2);
            return transferImpl;
        }
    }

    protected abstract TransferImpl readTransfer(Parser var1);
}

