/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleFactory.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    private ExampleFactory() {
    }

    public static AgencyImpl createAgency() {
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.setAgent(ExampleFactory.createAgent());
        AgentContactImpl agentContactImpl = ExampleFactory.createAgentContact();
        agentContactImpl.setId("Contact.1");
        agencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
        for (int i = 1; i < 4; ++i) {
            EstateImpl estateImpl = ExampleFactory.createEstate();
            estateImpl.setId("Estate." + String.valueOf(i));
            estateImpl.setContactId(agentContactImpl.getId());
            agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        }
        return agencyImpl;
    }

    public static AgentImpl createAgent() {
        AgentImpl agentImpl = new AgentImpl();
        agentImpl.setId("Agent.1");
        agentImpl.setTerms("Allgemeine Gesch\u00e4ftsbedingungen", OpenEstateUtils.DEFAULT_LOCALE);
        agentImpl.getCompany().setCompanyBusiness("Immobilienmakler");
        agentImpl.getCompany().setCompanyDepartment("Zentrale");
        agentImpl.getCompany().setCompanyFax("030/123456790");
        agentImpl.getCompany().setCompanyMail("mustermann@openestate.de");
        agentImpl.getCompany().setCompanyName("Mustermann Immobilien");
        agentImpl.getCompany().setCompanyNameAddition("Beispielmakler");
        agentImpl.getCompany().setCompanyMobilePhone("030/987654321");
        agentImpl.getCompany().setCompanyPhone("030/123456789");
        agentImpl.getCompany().setCompanyPosition("Gesch\u00e4ftsf\u00fchrung");
        agentImpl.getCompany().setCompanyLegalForm("GmbH");
        agentImpl.getCompany().setPersonFax("030/123456790");
        agentImpl.getCompany().setPersonFirstName("Max");
        agentImpl.getCompany().setPersonGender(Gender.MALE);
        agentImpl.getCompany().setPersonLastName("Mustermann");
        agentImpl.getCompany().setPersonMail("max.mustermann@openestate.de");
        agentImpl.getCompany().setPersonMiddleName("Moritz");
        agentImpl.getCompany().setPersonMobilePhone("030/987654321");
        agentImpl.getCompany().setPersonPhone("030/123456789");
        agentImpl.getCompany().setPersonTitle("Dr.");
        agentImpl.getCompany().setCity("Berlin");
        agentImpl.getCompany().setDistrict("Mitte");
        agentImpl.getCompany().setCountry(OpenEstateUtils.DEFAULT_LOCALE.getCountry());
        agentImpl.getCompany().setLatitude(new BigDecimal("52.518333d"));
        agentImpl.getCompany().setLongitude(new BigDecimal("13.408333d"));
        agentImpl.getCompany().setPostalCode("12345");
        agentImpl.getCompany().setStreet("Beispielstra\u00dfe");
        agentImpl.getCompany().setStreetNr("123");
        agentImpl.setCustomValues(ExampleFactory.createCustomValues());
        try {
            agentImpl.getCompany().setCompanyWebsite(new URI("https://openestate.org"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return agentImpl;
    }

    public static AgentContactImpl createAgentContact() {
        AgentContactImpl agentContactImpl = new AgentContactImpl();
        agentContactImpl.setId("Contact.0");
        agentContactImpl.setPersonFax("030/123456790");
        agentContactImpl.setPersonFirstName("Monika");
        agentContactImpl.setPersonGender(Gender.FEMALE);
        agentContactImpl.setPersonLastName("Mustermann");
        agentContactImpl.setPersonMail("monika.mustermann@openestate.de");
        agentContactImpl.setPersonMiddleName("Moni");
        agentContactImpl.setPersonMobilePhone("030/987654321");
        agentContactImpl.setPersonPhone("030/123456789");
        agentContactImpl.setPersonTitle("Dr.");
        agentContactImpl.setCity("Berlin");
        agentContactImpl.setDistrict("Mitte");
        agentContactImpl.setCountry(OpenEstateUtils.DEFAULT_LOCALE.getCountry());
        agentContactImpl.setLatitude(new BigDecimal("52.518333d"));
        agentContactImpl.setLongitude(new BigDecimal("13.408333d"));
        agentContactImpl.setPostalCode("12345");
        agentContactImpl.setStreet("Beispielstra\u00dfe");
        agentContactImpl.setStreetNr("123");
        agentContactImpl.setCustomValues(ExampleFactory.createCustomValues());
        return agentContactImpl;
    }

    public static CustomValuesImpl createCustomValues() {
        SecureRandom secureRandom = new SecureRandom();
        CustomValuesImpl customValuesImpl = new CustomValuesImpl();
        int n = 0;
        for (int i = 0; i <= 8; ++i) {
            int n2 = 1;
            for (int j = 0; j < n2; ++j) {
                String string = "example-" + (++n < 10 ? "0" + n : Integer.valueOf(n));
                Object object = null;
                if (i == 0) {
                    object = j % 2 == 0;
                } else if (i == 1) {
                    object = new Date();
                } else if (i == 2) {
                    object = new Date();
                } else if (i == 3) {
                    object = BigDecimal.valueOf(secureRandom.nextDouble());
                } else if (i == 4) {
                    object = BigInteger.valueOf(secureRandom.nextLong());
                } else if (i == 5) {
                    object = "example " + (j + 1);
                } else if (i == 7) {
                    object = new Date();
                } else if (i == 8) {
                    try {
                        object = new URL("http://www.openestate.org/example" + (j + 1) + "/");
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read URL!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
                customValuesImpl.getValueMap().put(string, new CustomValueImpl(string, object, i));
            }
        }
        return customValuesImpl;
    }

    public static EstateImpl createEstate() {
        OpenEstateType[] openEstateTypeArray = OpenEstateType.values();
        AbstractTypeImpl abstractTypeImpl = openEstateTypeArray[RANDOM.nextInt(openEstateTypeArray.length)].createImpl();
        OpenEstateAction[] openEstateActionArray = abstractTypeImpl.getActions();
        OpenEstateAction openEstateAction = openEstateActionArray[RANDOM.nextInt(openEstateActionArray.length)];
        return ExampleFactory.createEstate(abstractTypeImpl, openEstateAction);
    }

    public static EstateImpl createEstate(AbstractTypeImpl abstractTypeImpl, OpenEstateAction openEstateAction) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        EnumMap<OpenEstateAttrib, AbstractAttribImpl> enumMap = new EnumMap<OpenEstateAttrib, AbstractAttribImpl>(OpenEstateAttrib.class);
        for (OpenEstateAttrib openEstateAttrib : abstractTypeImpl.getAttribs(openEstateAction)) {
            AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
            if (abstractAttribImpl == null) continue;
            if (openEstateAttrib.isGroup(OpenEstateAttribGroup.DESCRIPTIONS)) {
                abstractAttribImpl.setValue("Freitext f\u00fcr " + openEstateAttrib.getTranslation() + System.lineSeparator() + System.lineSeparator() + "\u00e4\u00f6\u00fc\u00df" + System.lineSeparator() + System.lineSeparator() + "http://www.openestate.org");
            } else if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                abstractAttribImpl.setValue(Boolean.FALSE);
            } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
                abstractAttribImpl.setValue(simpleEnumAttrib.getOptions()[0]);
            } else if (abstractAttribImpl instanceof SimpleNumericAttrib) {
                float f = new SecureRandom().nextFloat();
                if (f == 0.0f) {
                    f = 100.0f;
                }
                try {
                    abstractAttribImpl.setValue(numberFormat.parse(numberFormat.format(f * 100.0f)));
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            enumMap.put(openEstateAttrib, abstractAttribImpl);
        }
        return ExampleFactory.createEstate(abstractTypeImpl, openEstateAction, enumMap);
    }

    public static EstateImpl createEstate(AbstractTypeImpl abstractTypeImpl, OpenEstateAction openEstateAction, Map<OpenEstateAttrib, AbstractAttribImpl> map) {
        EstateImpl estateImpl = new EstateImpl();
        estateImpl.setId("Estate.0");
        estateImpl.setPublicId(String.valueOf(System.currentTimeMillis()));
        estateImpl.setCurrency(Currency.getInstance("EUR"));
        estateImpl.setTitle("Beispielinserat", OpenEstateUtils.DEFAULT_LOCALE);
        try {
            estateImpl.setType(abstractTypeImpl, openEstateAction);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getLocalizedMessage(), (Throwable)exception);
        }
        Calendar calendar = Calendar.getInstance();
        estateImpl.setPublishBegin(calendar.getTime());
        calendar.add(6, 14);
        estateImpl.setPublishEnd(calendar.getTime());
        estateImpl.getAddress().setCity("Berlin");
        estateImpl.getAddress().setDistrict("Mitte");
        estateImpl.getAddress().setCountry(OpenEstateUtils.DEFAULT_LOCALE.getCountry());
        estateImpl.getAddress().setLatitude(new BigDecimal("52.518333d"));
        estateImpl.getAddress().setLongitude(new BigDecimal("13.408333d"));
        estateImpl.getAddress().setPostalCode("12345");
        estateImpl.getAddress().setPublished(false);
        estateImpl.getAddress().setStreet("Beispielstra\u00dfe");
        estateImpl.getAddress().setStreetNr("123");
        for (Map.Entry<OpenEstateAttrib, AbstractAttribImpl> object : map.entrySet()) {
            estateImpl.putAttribute(object.getValue());
        }
        estateImpl.setCustomValues(ExampleFactory.createCustomValues());
        for (int i = 0; i < 5; ++i) {
            EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
            estateAttachmentImpl.setMimeType("image/png");
            estateAttachmentImpl.setTitle("Anhang #" + i, OpenEstateUtils.DEFAULT_LOCALE);
            try {
                if (i % 2 == 0) {
                    estateAttachmentImpl.setFile("image_" + i + ".png");
                } else {
                    estateAttachmentImpl.setFile(new URI("https://openestate.org/image_" + i + ".png"));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        return estateImpl;
    }

    public static TransferImpl createTransfer() {
        return ExampleFactory.createTransfer(RANDOM.nextInt(2) == 0);
    }

    public static TransferImpl createTransfer(boolean bl) {
        AgencyImpl agencyImpl = ExampleFactory.createAgency();
        TransferImpl transferImpl = new TransferImpl();
        transferImpl.setSenderSoftwareMail("technik@openestate.org");
        transferImpl.setSenderSoftwareName("OpenEstate Beispielgenerator");
        transferImpl.setSenderSoftwareVersion("1.0");
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setAgent(agencyImpl.getAgent());
        transferAgencyImpl.setCustomValues(ExampleFactory.createCustomValues());
        for (AgentContactImpl abstractImplItem : agencyImpl.getContacts().values()) {
            transferAgencyImpl.getContacts().put(abstractImplItem.getId(), abstractImplItem);
        }
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            transferAgencyImpl.getEstatesToSave().add(estateImpl);
        }
        if (bl) {
            transferAgencyImpl.setRemoveUnmodifiedEstates(true);
        } else {
            transferAgencyImpl.getEstateIdsToRemove().add("4");
            transferAgencyImpl.getEstateIdsToRemove().add("5");
            transferAgencyImpl.getEstateIdsToRemove().add("6");
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        transferImpl.setCustomValues(ExampleFactory.createCustomValues());
        return transferImpl;
    }
}

