/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.values.LengthValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLengthValueField
extends JPanel {
    private static final long serialVersionUID = 2758622055108342481L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JLengthValueField.class);
    private JFormattedTextField valueField;
    private JSpinner unitSpinner;
    private LengthValue.Unit currentUnit = null;

    public JLengthValueField() {
        super(new BorderLayout(5, 0));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        this.valueField = new JFormattedTextField(numberFormat);
        this.valueField.setFocusLostBehavior(0);
        this.add((Component)this.valueField, "Center");
        SpinnerListModel spinnerListModel = new SpinnerListModel(Arrays.asList(LengthValue.Unit.values()));
        this.unitSpinner = new JSpinner(spinnerListModel);
        this.unitSpinner.setValue((Object)LengthValue.Unit.getBaseUnit());
        this.unitSpinner.setPreferredSize(new Dimension(60, this.unitSpinner.getPreferredSize().height));
        this.unitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LengthValue lengthValue = JLengthValueField.this.getValue();
                if (lengthValue == null) {
                    return;
                }
                if (JLengthValueField.this.currentUnit != null) {
                    JLengthValueField.this.valueField.setValue(LengthValue.convert(lengthValue.getValue(), JLengthValueField.this.currentUnit, lengthValue.getUnit()));
                }
                JLengthValueField.this.currentUnit = lengthValue.getUnit();
            }
        });
        this.add((Component)this.unitSpinner, "East");
        this.revalidate();
        this.repaint();
    }

    public JSpinner getUnitSpinner() {
        return this.unitSpinner;
    }

    public LengthValue getValue() {
        try {
            this.valueField.commitEdit();
            return !this.valueField.isEditValid() ? null : LengthValue.parse(this.valueField.getValue(), (LengthValue.Unit)((Object)this.unitSpinner.getValue()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JFormattedTextField getValueField() {
        return this.valueField;
    }

    public void setValue(LengthValue lengthValue) {
        this.currentUnit = lengthValue != null ? lengthValue.getUnit() : LengthValue.Unit.getBaseUnit();
        this.unitSpinner.setValue((Object)this.currentUnit);
        this.valueField.setValue(lengthValue != null ? Double.valueOf(lengthValue.doubleValue()) : null);
    }
}

