/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.values;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.values.UnitValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeValue
extends Number
implements UnitValue<Unit>,
Comparable<VolumeValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VolumeValue.class);
    private BigDecimal value;
    private Unit unit;

    public VolumeValue() {
        this(null, null);
    }

    public VolumeValue(BigDecimal bigDecimal, Unit unit) {
        this.value = bigDecimal;
        this.unit = unit != null ? unit : Unit.getBaseUnit();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(VolumeValue volumeValue) {
        Unit unit;
        if (volumeValue == null) {
            return -1;
        }
        BigDecimal bigDecimal = this.getValue();
        BigDecimal bigDecimal2 = volumeValue.getValue();
        if (bigDecimal == null && bigDecimal2 == null) {
            return 0;
        }
        if (bigDecimal == null) {
            return 1;
        }
        if (bigDecimal2 == null) {
            return -1;
        }
        Unit unit2 = this.getUnit();
        if (unit2 == null) {
            unit2 = Unit.getBaseUnit();
        }
        if ((unit = volumeValue.getUnit()) == null) {
            unit = Unit.getBaseUnit();
        }
        if (unit2 != unit) {
            bigDecimal2 = VolumeValue.convert(bigDecimal2, unit, unit2);
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public static BigDecimal convert(VolumeValue volumeValue, Unit unit) {
        return VolumeValue.convert(volumeValue.getValue(), volumeValue.getUnit(), unit);
    }

    public static BigDecimal convert(BigDecimal bigDecimal, Unit unit, Unit unit2) {
        if (unit == null) {
            throw new IllegalArgumentException("Invalid source unit!");
        }
        if (unit2 == null) {
            throw new IllegalArgumentException("Invalid target unit!");
        }
        if (unit == unit2) {
            return bigDecimal;
        }
        MathContext mathContext = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal bigDecimal2 = unit.getBaseUnitFactor();
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid source unit was provided!");
        }
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2, mathContext);
        if (Unit.getBaseUnit() == unit2) {
            return bigDecimal3;
        }
        BigDecimal bigDecimal4 = unit2.getBaseUnitFactor();
        if (bigDecimal4.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid target unit was provided!");
        }
        return bigDecimal3.divide(bigDecimal4, mathContext);
    }

    @Override
    public double doubleValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.floatValue();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.longValue();
    }

    public static VolumeValue parse(Object object) {
        return VolumeValue.parse(object, null);
    }

    public static VolumeValue parse(Object object, Unit unit) {
        if (object instanceof VolumeValue) {
            return (VolumeValue)object;
        }
        if (unit == null) {
            unit = Unit.getBaseUnit();
        }
        if (object instanceof String) {
            object = OpenEstateUtils.parseNumber((String)object);
        }
        if (object instanceof BigDecimal) {
            return new VolumeValue((BigDecimal)object, unit);
        }
        if (object instanceof BigInteger) {
            return new VolumeValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Long) {
            return new VolumeValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Integer) {
            return new VolumeValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Number) {
            return new VolumeValue(BigDecimal.valueOf(((Number)object).doubleValue()), unit);
        }
        return null;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }

    public static enum Unit {
        ML,
        L,
        CUM,
        CUIN,
        CUFT,
        CUYD,
        GAL,
        BL;


        public static Unit getBaseUnit() {
            return CUM;
        }

        public BigDecimal getBaseUnitFactor() {
            switch (this) {
                case ML: {
                    return new BigDecimal("1e-6");
                }
                case L: {
                    return new BigDecimal("1e-3");
                }
                case CUM: {
                    return BigDecimal.ONE;
                }
                case CUIN: {
                    return new BigDecimal("0.000016387064");
                }
                case CUFT: {
                    return new BigDecimal("0.028316846592");
                }
                case CUYD: {
                    return new BigDecimal("0.764554857984");
                }
                case GAL: {
                    return new BigDecimal("0.00454609");
                }
                case BL: {
                    return new BigDecimal("0.159113");
                }
            }
            return BigDecimal.ZERO;
        }

        public String toString() {
            return this.write();
        }

        public String write() {
            switch (this) {
                case L: {
                    return "l";
                }
                case ML: {
                    return "ml";
                }
                case CUM: {
                    return "m\u00b3";
                }
                case CUIN: {
                    return "in\u00b3";
                }
                case CUFT: {
                    return "ft\u00b3";
                }
                case CUYD: {
                    return "yd\u00b3";
                }
                case GAL: {
                    return "gal";
                }
                case BL: {
                    return "bl";
                }
            }
            return null;
        }
    }
}

