/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.swift.SwiftPattern;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum BbanStructure {
    ALBANIA(IsoCountry.ALBANIA, "8!n16!c", new IsoCountry[0]),
    ANDORRA(IsoCountry.ANDORRA, "4!n4!n12!c", new IsoCountry[0]),
    AUSTRIA(IsoCountry.AUSTRIA, "5!n11!n", new IsoCountry[0]),
    AZERBAIJAN(IsoCountry.AZERBAIJAN, "4!a20!c", new IsoCountry[0]),
    BAHRAIN(IsoCountry.BAHRAIN, "4!a14!c", new IsoCountry[0]),
    BELGIUM(IsoCountry.BELGIUM, "3!n7!n2!n", new IsoCountry[0]),
    BOSNIA_AND_HERZEGOVINA(IsoCountry.BOSNIA_AND_HERZEGOVINA, "3!n3!n8!n2!n", new IsoCountry[0]),
    BRAZIL(IsoCountry.BRAZIL, "8!n5!n10!n1!a1!c", new IsoCountry[0]),
    BULGARIA(IsoCountry.BULGARIA, "4!a4!n2!n8!c", new IsoCountry[0]),
    COSTA_RICA(IsoCountry.COSTA_RICA, "3!n14!n", new IsoCountry[0]),
    CROATIA(IsoCountry.CROATIA, "7!n10!n", new IsoCountry[0]),
    CYPRUS(IsoCountry.CYPRUS, "3!n5!n16!c", new IsoCountry[0]),
    CZECH_REPUBLIC(IsoCountry.CZECH_REPUBLIC, "4!n6!n10!n", new IsoCountry[0]),
    DENMARK(IsoCountry.DENMARK, "4!n9!n1!n", new IsoCountry[0]),
    FAROE_ISLANDS(IsoCountry.FAROE_ISLANDS, "4!n9!n1!n", new IsoCountry[0]),
    GREENLAND(IsoCountry.GREENLAND, "4!n9!n1!n", new IsoCountry[0]),
    DOMINICAN_REPUBLIC(IsoCountry.DOMINICAN_REPUBLIC, "4!c20!n", new IsoCountry[0]),
    ESTONIA(IsoCountry.ESTONIA, "2!n2!n11!n1!n", new IsoCountry[0]),
    FINLAND(IsoCountry.FINLAND, "6!n7!n1!n", new IsoCountry[0]),
    ALAND_ISLANDS(IsoCountry.ALAND_ISLANDS, "6!n7!n1!n", new IsoCountry[0]),
    FRANCE(IsoCountry.FRANCE, "5!n5!n11!c2!n", IsoCountry.FRENCH_GUIANA, IsoCountry.GUADELOUPE, IsoCountry.MARTINIQUE, IsoCountry.REUNION, IsoCountry.FRENCH_POLYNESIA, IsoCountry.FRENCH_SOUTHERN_TERRITORIES, IsoCountry.NEW_CALEDONIA, IsoCountry.SAINT_BARTHELEMY, IsoCountry.SAINT_MARTIN, IsoCountry.SAINT_PIERRE_AND_MIQUELON, IsoCountry.WALLIS_AND_FUTUNA),
    GEORGIA(IsoCountry.GEORGIA, "2!a16!n", new IsoCountry[0]),
    GERMANY(IsoCountry.GERMANY, "8!n10!n", new IsoCountry[0]),
    GIBRALTAR(IsoCountry.GIBRALTAR, "4!a15!c", new IsoCountry[0]),
    GREECE(IsoCountry.GREECE, "3!n4!n16!c", new IsoCountry[0]),
    GUATEMALA(IsoCountry.GUATEMALA, "4!c20!c", new IsoCountry[0]),
    HUNGARY(IsoCountry.HUNGARY, "3!n4!n1!n15!n1!n", new IsoCountry[0]),
    ICELAND(IsoCountry.ICELAND, "4!n2!n6!n10!n", new IsoCountry[0]),
    IRELAND(IsoCountry.IRELAND, "4!a6!n8!n", new IsoCountry[0]),
    ISRAEL(IsoCountry.ISRAEL, "3!n3!n13!n", new IsoCountry[0]),
    ITALY(IsoCountry.ITALY, "1!a5!n5!n12!c", new IsoCountry[0]),
    KAZAKHSTAN(IsoCountry.KAZAKHSTAN, "3!n13!c", new IsoCountry[0]),
    KUWAIT(IsoCountry.KUWAIT, "4!a22!c", new IsoCountry[0]),
    LATVIA(IsoCountry.LATVIA, "4!a13!c", new IsoCountry[0]),
    LEBANON(IsoCountry.LEBANON, "4!n20!c", new IsoCountry[0]),
    LIECHTENSTEIN(IsoCountry.LIECHTENSTEIN, "5!n12!c", new IsoCountry[0]),
    LITHUANIA(IsoCountry.LITHUANIA, "5!n11!n", new IsoCountry[0]),
    LUXEMBOURG(IsoCountry.LUXEMBOURG, "3!n13!c", new IsoCountry[0]),
    MACEDONIA(IsoCountry.MACEDONIA, "3!n10!c2!n", new IsoCountry[0]),
    MALTA(IsoCountry.MALTA, "4!a5!n18!c", new IsoCountry[0]),
    MAURITANIA(IsoCountry.MAURITANIA, "5!n5!n11!n2!n", new IsoCountry[0]),
    MAURITIUS(IsoCountry.MAURITIUS, "4!a2!n2!n12!n3!n3!a", new IsoCountry[0]),
    MOLDOVA(IsoCountry.MOLDOVA, "2!c18!c", new IsoCountry[0]),
    MONACO(IsoCountry.MONACO, "5!n5!n11!c2!n", new IsoCountry[0]),
    MONTENEGRO(IsoCountry.MONTENEGRO, "3!n13!n2!n", new IsoCountry[0]),
    NETHERLANDS(IsoCountry.NETHERLANDS, "4!a10!n", new IsoCountry[0]),
    NORWAY(IsoCountry.NORWAY, "4!n6!n1!n", new IsoCountry[0]),
    PAKISTAN(IsoCountry.PAKISTAN, "4!a16!c", new IsoCountry[0]),
    PALESTINE(IsoCountry.PALESTINE, "4!a21!c", new IsoCountry[0]),
    POLAND(IsoCountry.POLAND, "8!n16!n", new IsoCountry[0]),
    PORTUGAL(IsoCountry.PORTUGAL, "4!n4!n11!n2!n", new IsoCountry[0]),
    ROMANIA(IsoCountry.ROMANIA, "4!a16!c", new IsoCountry[0]),
    SAN_MARINO(IsoCountry.SAN_MARINO, "1!a5!n5!n12!c", new IsoCountry[0]),
    SAUDI_ARABIA(IsoCountry.SAUDI_ARABIA, "2!n18!c", new IsoCountry[0]),
    SERBIA(IsoCountry.SERBIA, "3!n13!n2!n", new IsoCountry[0]),
    SLOVAKIA(IsoCountry.SLOVAKIA, "4!n6!n10!n", new IsoCountry[0]),
    SLOVENIA(IsoCountry.SLOVENIA, "5!n8!n2!n", new IsoCountry[0]),
    SPAIN(IsoCountry.SPAIN, "4!n4!n1!n1!n10!n", new IsoCountry[0]),
    SWEDEN(IsoCountry.SWEDEN, "3!n16!n1!n", new IsoCountry[0]),
    SWITZERLAND(IsoCountry.SWITZERLAND, "5!n12!c", new IsoCountry[0]),
    TUNISIA(IsoCountry.TUNISIA, "2!n3!n13!n2!n", new IsoCountry[0]),
    TURKEY(IsoCountry.TURKEY, "5!n1!c16!c", new IsoCountry[0]),
    UNITED_ARAB_EMIRATES(IsoCountry.UNITED_ARAB_EMIRATES, "3!n16!n", new IsoCountry[0]),
    UNITED_KINGDOM(IsoCountry.UNITED_KINGDOM, "4!a6!n8!n", new IsoCountry[0]),
    BRITISH_VIRGIN_ISLANDS(IsoCountry.BRITISH_VIRGIN_ISLANDS, "4!a16!n", new IsoCountry[0]);

    private final IsoCountry country;
    private final SwiftPattern bbanPattern;
    private final Set<IsoCountry> subdivisions;

    private BbanStructure(IsoCountry country, String bbanSwiftExpression, IsoCountry ... subdivisions) {
        this.country = country;
        this.bbanPattern = SwiftPattern.compile(bbanSwiftExpression);
        this.subdivisions = subdivisions.length == 0 ? EnumSet.noneOf(IsoCountry.class) : EnumSet.copyOf(Arrays.asList(subdivisions));
    }

    public static BbanStructure forCountry(IsoCountry country) {
        if (country == null) {
            return null;
        }
        for (BbanStructure structure : BbanStructure.values()) {
            if (structure.country.equals((Object)country)) {
                return structure;
            }
            for (IsoCountry subdivision : structure.subdivisions) {
                if (!subdivision.equals((Object)country)) continue;
                return structure;
            }
        }
        return null;
    }

    public boolean isBbanValid(String bban) {
        if (bban == null) {
            throw new IllegalArgumentException("the bban argument cannot be null");
        }
        return this.bbanPattern.matcher(bban).matches();
    }

    public IsoCountry getCountry() {
        return this.country;
    }

    public SwiftPattern getBbanPattern() {
        return this.bbanPattern;
    }

    public Set<IsoCountry> getSubdivisions() {
        return this.subdivisions;
    }
}

