/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public enum Gender implements Translatable
{
    FEMALE("F", "\u2640", I18n.marktr((String)"female")),
    MALE("M", "\u2642", I18n.marktr((String)"male"));

    private static final Logger LOGGER;
    private final String shortValue;
    private final String symbol;
    private final String i18nKey;

    private Gender(String string2, String string3, String string4) {
        this.shortValue = string2;
        this.symbol = string3;
        this.i18nKey = string4;
    }

    public static Gender fromShortValue(String string) {
        for (Gender gender : Gender.values()) {
            if (!gender.getShortValue().equalsIgnoreCase(string)) continue;
            return gender;
        }
        return null;
    }

    public static Gender fromSymbol(String string) {
        for (Gender gender : Gender.values()) {
            if (!gender.getSymbol().equalsIgnoreCase(string)) continue;
            return gender;
        }
        return null;
    }

    public String getShortValue() {
        return this.shortValue;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getTranslation() {
        return this.getTranslation(null);
    }

    @Override
    public String getTranslation(Locale locale) {
        return OpenEstateUtils.getI18nString(this.i18nKey, locale);
    }

    @Deprecated
    public String write() {
        return this.getTranslation();
    }

    @Deprecated
    public String write(Locale locale) {
        return this.getTranslation(locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(Gender.class);
    }
}

