/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.types.AgriculturalForestryGround;
import com.openindex.openestate.impl.types.AlpineHut;
import com.openindex.openestate.impl.types.AnimalHusbandry;
import com.openindex.openestate.impl.types.Apartment;
import com.openindex.openestate.impl.types.ApartmentShare;
import com.openindex.openestate.impl.types.ApartmentShareSeniors;
import com.openindex.openestate.impl.types.ApartmentShareStudents;
import com.openindex.openestate.impl.types.AssemblerRoom;
import com.openindex.openestate.impl.types.AssistedLiving;
import com.openindex.openestate.impl.types.Atelier;
import com.openindex.openestate.impl.types.AtticApartment;
import com.openindex.openestate.impl.types.AtticUnderConstruction;
import com.openindex.openestate.impl.types.Barn;
import com.openindex.openestate.impl.types.BeachHouse;
import com.openindex.openestate.impl.types.Berth;
import com.openindex.openestate.impl.types.BistroCafe;
import com.openindex.openestate.impl.types.Bungalow;
import com.openindex.openestate.impl.types.CarPark;
import com.openindex.openestate.impl.types.CarParkUnit;
import com.openindex.openestate.impl.types.CareHome;
import com.openindex.openestate.impl.types.Carport;
import com.openindex.openestate.impl.types.Castle;
import com.openindex.openestate.impl.types.Chalet;
import com.openindex.openestate.impl.types.ColdStorageWarehouse;
import com.openindex.openestate.impl.types.CommercialBuilding;
import com.openindex.openestate.impl.types.CommercialCenter;
import com.openindex.openestate.impl.types.CommercialGround;
import com.openindex.openestate.impl.types.ConsumerStore;
import com.openindex.openestate.impl.types.CoolingHouse;
import com.openindex.openestate.impl.types.Cottage;
import com.openindex.openestate.impl.types.CountryHouse;
import com.openindex.openestate.impl.types.Cultivation;
import com.openindex.openestate.impl.types.DepartmentStore;
import com.openindex.openestate.impl.types.Discotheque;
import com.openindex.openestate.impl.types.DoctorsOfficeHouse;
import com.openindex.openestate.impl.types.DoubleGarage;
import com.openindex.openestate.impl.types.DuplexGarage;
import com.openindex.openestate.impl.types.DuplexHouse;
import com.openindex.openestate.impl.types.ExhibitionArea;
import com.openindex.openestate.impl.types.Farm;
import com.openindex.openestate.impl.types.Farmhouse;
import com.openindex.openestate.impl.types.Finca;
import com.openindex.openestate.impl.types.FishFarming;
import com.openindex.openestate.impl.types.FitnessStudio;
import com.openindex.openestate.impl.types.ForestryHunting;
import com.openindex.openestate.impl.types.ForwardingWarehouse;
import com.openindex.openestate.impl.types.FreeCarParkingSpace;
import com.openindex.openestate.impl.types.Garage;
import com.openindex.openestate.impl.types.GardenGround;
import com.openindex.openestate.impl.types.Gardening;
import com.openindex.openestate.impl.types.Gastronomy;
import com.openindex.openestate.impl.types.GastronomyWithHousing;
import com.openindex.openestate.impl.types.GeneralAgriculture;
import com.openindex.openestate.impl.types.GeneralCommercial;
import com.openindex.openestate.impl.types.GeneralParking;
import com.openindex.openestate.impl.types.GeneralPieceOfLand;
import com.openindex.openestate.impl.types.GeneralResidence;
import com.openindex.openestate.impl.types.GroundFloorApartment;
import com.openindex.openestate.impl.types.GuestRoom;
import com.openindex.openestate.impl.types.Guesthouse;
import com.openindex.openestate.impl.types.HallWarehouse;
import com.openindex.openestate.impl.types.HighRackWarehouse;
import com.openindex.openestate.impl.types.HigherFloorApartment;
import com.openindex.openestate.impl.types.HospitalClinic;
import com.openindex.openestate.impl.types.HospitalityIndustry;
import com.openindex.openestate.impl.types.Hostel;
import com.openindex.openestate.impl.types.Hotel;
import com.openindex.openestate.impl.types.House;
import com.openindex.openestate.impl.types.HousingComplex;
import com.openindex.openestate.impl.types.HuntingGround;
import com.openindex.openestate.impl.types.IndustrialFacility;
import com.openindex.openestate.impl.types.IndustrialGround;
import com.openindex.openestate.impl.types.IndustrialWarehouse;
import com.openindex.openestate.impl.types.IndustrialWarehouseWithOpenSpace;
import com.openindex.openestate.impl.types.Kiosk;
import com.openindex.openestate.impl.types.LakefrontGround;
import com.openindex.openestate.impl.types.LeisureFacility;
import com.openindex.openestate.impl.types.LeisureGround;
import com.openindex.openestate.impl.types.LeisureHome;
import com.openindex.openestate.impl.types.LeisureSportsFacility;
import com.openindex.openestate.impl.types.Loft;
import com.openindex.openestate.impl.types.Maisonette;
import com.openindex.openestate.impl.types.Mansion;
import com.openindex.openestate.impl.types.ManufactoringArea;
import com.openindex.openestate.impl.types.Mezzanine;
import com.openindex.openestate.impl.types.MixedUseGround;
import com.openindex.openestate.impl.types.MultiFamilyHouse;
import com.openindex.openestate.impl.types.MultiFamilyHouseWithCommercial;
import com.openindex.openestate.impl.types.Office;
import com.openindex.openestate.impl.types.OfficeArea;
import com.openindex.openestate.impl.types.OfficeBuilding;
import com.openindex.openestate.impl.types.OfficeCenter;
import com.openindex.openestate.impl.types.OfficeCommercialBuilding;
import com.openindex.openestate.impl.types.OfficeCommercialPremise;
import com.openindex.openestate.impl.types.OfficeFloor;
import com.openindex.openestate.impl.types.OfficeSurgery;
import com.openindex.openestate.impl.types.OneRoomApartment;
import com.openindex.openestate.impl.types.OneRoomPremise;
import com.openindex.openestate.impl.types.OpenSpace;
import com.openindex.openestate.impl.types.OutdoorCarParkingSpace;
import com.openindex.openestate.impl.types.OutlyingFarm;
import com.openindex.openestate.impl.types.Palace;
import com.openindex.openestate.impl.types.ParkingSpace;
import com.openindex.openestate.impl.types.PenthouseApartment;
import com.openindex.openestate.impl.types.PetrolStation;
import com.openindex.openestate.impl.types.Pizzeria;
import com.openindex.openestate.impl.types.Premise;
import com.openindex.openestate.impl.types.Production;
import com.openindex.openestate.impl.types.Residence;
import com.openindex.openestate.impl.types.ResidentialCommercialBuilding;
import com.openindex.openestate.impl.types.ResidentialGround;
import com.openindex.openestate.impl.types.RestOfAFarm;
import com.openindex.openestate.impl.types.Restaurant;
import com.openindex.openestate.impl.types.RestaurantBar;
import com.openindex.openestate.impl.types.Retail;
import com.openindex.openestate.impl.types.RidingEstate;
import com.openindex.openestate.impl.types.Room;
import com.openindex.openestate.impl.types.Rustico;
import com.openindex.openestate.impl.types.SalesArea;
import com.openindex.openestate.impl.types.Sanatorium;
import com.openindex.openestate.impl.types.SelfServiceMarket;
import com.openindex.openestate.impl.types.SemidetachedHouse;
import com.openindex.openestate.impl.types.SeniorHousingComplex;
import com.openindex.openestate.impl.types.ServiceArea;
import com.openindex.openestate.impl.types.ServiceCenter;
import com.openindex.openestate.impl.types.Shop;
import com.openindex.openestate.impl.types.ShoppingCenter;
import com.openindex.openestate.impl.types.Showroom;
import com.openindex.openestate.impl.types.SingleFamilyHouse;
import com.openindex.openestate.impl.types.SmokersPremise;
import com.openindex.openestate.impl.types.SouterrainApartment;
import com.openindex.openestate.impl.types.SpecialHouse;
import com.openindex.openestate.impl.types.SpecialUseGround;
import com.openindex.openestate.impl.types.SportsFacility;
import com.openindex.openestate.impl.types.StorageArea;
import com.openindex.openestate.impl.types.Store;
import com.openindex.openestate.impl.types.Studio;
import com.openindex.openestate.impl.types.SummerHouse;
import com.openindex.openestate.impl.types.Surgery;
import com.openindex.openestate.impl.types.SurgeryArea;
import com.openindex.openestate.impl.types.SurgeryFloor;
import com.openindex.openestate.impl.types.TanningSalon;
import com.openindex.openestate.impl.types.TerraceApartment;
import com.openindex.openestate.impl.types.TerracedHouse;
import com.openindex.openestate.impl.types.TerracedHouseCornerside;
import com.openindex.openestate.impl.types.TerracedHouseMiddle;
import com.openindex.openestate.impl.types.TerracedHouseTail;
import com.openindex.openestate.impl.types.ThemePark;
import com.openindex.openestate.impl.types.TownHouse;
import com.openindex.openestate.impl.types.TwoFamilyHouse;
import com.openindex.openestate.impl.types.UndergroundCarPark;
import com.openindex.openestate.impl.types.UndergroundCarParkUnit;
import com.openindex.openestate.impl.types.Villa;
import com.openindex.openestate.impl.types.Viniculture;
import com.openindex.openestate.impl.types.Warehouse;
import com.openindex.openestate.impl.types.WarehouseStore;
import com.openindex.openestate.impl.types.WarehouseWithOpenSpace;
import com.openindex.openestate.impl.types.Workshop;
import com.openindex.openestate.impl.types.YouthHostel;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public enum OpenEstateType implements Translatable
{
    GENERAL_AGRICULTURE(null, GeneralAgriculture.class, I18n.marktr((String)"agriculture")),
    ANIMAL_HUSBANDRY(GENERAL_AGRICULTURE, AnimalHusbandry.class, I18n.marktr((String)"animal husbandry")),
    BARN(GENERAL_AGRICULTURE, Barn.class, I18n.marktr((String)"barn")),
    CULTIVATION(GENERAL_AGRICULTURE, Cultivation.class, I18n.marktr((String)"cultivation")),
    FARM(GENERAL_AGRICULTURE, Farm.class, I18n.marktr((String)"farm")),
    REST_OF_A_FARM(FARM, RestOfAFarm.class, I18n.marktr((String)"rest of a farm")),
    FISH_FARMING(GENERAL_AGRICULTURE, FishFarming.class, I18n.marktr((String)"fish farming")),
    FORESTRY_HUNTING(GENERAL_AGRICULTURE, ForestryHunting.class, I18n.marktr((String)"forestry / hunting")),
    GARDENING(GENERAL_AGRICULTURE, Gardening.class, I18n.marktr((String)"gardening")),
    HUNTING_GROUND(GENERAL_AGRICULTURE, HuntingGround.class, I18n.marktr((String)"hunting ground")),
    OUTLYING_FARM(GENERAL_AGRICULTURE, OutlyingFarm.class, I18n.marktr((String)"outlying farm")),
    VINICULTURE(GENERAL_AGRICULTURE, Viniculture.class, I18n.marktr((String)"viniculture")),
    GENERAL_COMMERCIAL(null, GeneralCommercial.class, I18n.marktr((String)"commercial property")),
    GASTRONOMY(GENERAL_COMMERCIAL, Gastronomy.class, I18n.marktr((String)"catering business")),
    BISTRO_CAFE(GASTRONOMY, BistroCafe.class, I18n.marktr((String)"bistro / caf\u00e9")),
    DISCOTHEQUE(GASTRONOMY, Discotheque.class, I18n.marktr((String)"discotheque")),
    GASTRONOMY_WITH_HOUSING(GASTRONOMY, GastronomyWithHousing.class, I18n.marktr((String)"gastronomy with apartment")),
    ONE_ROOM_PREMISE(GASTRONOMY, OneRoomPremise.class, I18n.marktr((String)"one-roomed premise")),
    PIZZERIA(GASTRONOMY, Pizzeria.class, I18n.marktr((String)"pizzeria")),
    RESTAURANT(GASTRONOMY, Restaurant.class, I18n.marktr((String)"restaurant")),
    RESTAURANT_BAR(GASTRONOMY, RestaurantBar.class, I18n.marktr((String)"restaurant / bar")),
    SMOKERS_PREMISE(GASTRONOMY, SmokersPremise.class, I18n.marktr((String)"smoker's premise")),
    HALL_WAREHOUSE(GENERAL_COMMERCIAL, HallWarehouse.class, I18n.marktr((String)"hall / warehouse")),
    COLD_STORAGE_WAREHOUSE(HALL_WAREHOUSE, ColdStorageWarehouse.class, I18n.marktr((String)"cold storage warehouse")),
    COOLING_HOUSE(HALL_WAREHOUSE, CoolingHouse.class, I18n.marktr((String)"cooling house")),
    FORWARDING_WAREHOUSE(HALL_WAREHOUSE, ForwardingWarehouse.class, I18n.marktr((String)"forwarding warehouse")),
    HIGH_RACK_WAREHOUSE(HALL_WAREHOUSE, HighRackWarehouse.class, I18n.marktr((String)"high rack warehouse")),
    INDUSTRIAL_WAREHOUSE(HALL_WAREHOUSE, IndustrialWarehouse.class, I18n.marktr((String)"industrial warehouse")),
    INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE(INDUSTRIAL_WAREHOUSE, IndustrialWarehouseWithOpenSpace.class, I18n.marktr((String)"industrial warehouse with open space")),
    OPEN_SPACE(HALL_WAREHOUSE, OpenSpace.class, I18n.marktr((String)"open space")),
    STORAGE_AREA(HALL_WAREHOUSE, StorageArea.class, I18n.marktr((String)"storage area")),
    WAREHOUSE(HALL_WAREHOUSE, Warehouse.class, I18n.marktr((String)"warehouse")),
    WAREHOUSE_WITH_OPEN_SPACE(WAREHOUSE, WarehouseWithOpenSpace.class, I18n.marktr((String)"warehouse with open space")),
    HOSPITALITY_INDUSTRY(GENERAL_COMMERCIAL, HospitalityIndustry.class, I18n.marktr((String)"hospitality industry")),
    GUESTHOUSE(HOSPITALITY_INDUSTRY, Guesthouse.class, I18n.marktr((String)"guesthouse")),
    GUEST_ROOM(HOSPITALITY_INDUSTRY, GuestRoom.class, I18n.marktr((String)"guest room")),
    HOSTEL(HOSPITALITY_INDUSTRY, Hostel.class, I18n.marktr((String)"hostel")),
    HOTEL(HOSPITALITY_INDUSTRY, Hotel.class, I18n.marktr((String)"hotel")),
    YOUTH_HOSTEL(HOSPITALITY_INDUSTRY, YouthHostel.class, I18n.marktr((String)"youth hostel")),
    HOSPITAL_CLINIC(GENERAL_COMMERCIAL, HospitalClinic.class, I18n.marktr((String)"hospital / clinic")),
    SANATORIUM(HOSPITAL_CLINIC, Sanatorium.class, I18n.marktr((String)"sanatorium")),
    HOUSING_COMPLEX(GENERAL_COMMERCIAL, HousingComplex.class, I18n.marktr((String)"housing complex")),
    CARE_HOME(HOUSING_COMPLEX, CareHome.class, I18n.marktr((String)"care home")),
    SENIOR_HOUSING_COMPLEX(HOUSING_COMPLEX, SeniorHousingComplex.class, I18n.marktr((String)"senior housing complex")),
    LEISURE_SPORTS_FACILITY(GENERAL_COMMERCIAL, LeisureSportsFacility.class, I18n.marktr((String)"leisure / sports facility")),
    FITNESS_STUDIO(LEISURE_SPORTS_FACILITY, FitnessStudio.class, I18n.marktr((String)"fitness studio")),
    LEISURE_FACILITY(LEISURE_SPORTS_FACILITY, LeisureFacility.class, I18n.marktr((String)"leisure facility")),
    RIDING_ESTATE(LEISURE_SPORTS_FACILITY, RidingEstate.class, I18n.marktr((String)"riding estate")),
    SPORTS_FACILITY(LEISURE_SPORTS_FACILITY, SportsFacility.class, I18n.marktr((String)"sports facility")),
    TANNING_SALON(LEISURE_SPORTS_FACILITY, TanningSalon.class, I18n.marktr((String)"tanning salon")),
    THEME_PARK(LEISURE_SPORTS_FACILITY, ThemePark.class, I18n.marktr((String)"theme park")),
    OFFICE_COMMERCIAL_BUILDING(GENERAL_COMMERCIAL, OfficeCommercialBuilding.class, I18n.marktr((String)"office / commercial building")),
    COMMERCIAL_BUILDING(OFFICE_COMMERCIAL_BUILDING, CommercialBuilding.class, I18n.marktr((String)"commercial building")),
    COMMERCIAL_CENTER(OFFICE_COMMERCIAL_BUILDING, CommercialCenter.class, I18n.marktr((String)"commercial center")),
    DOCTORS_OFFICE_HOUSE(OFFICE_COMMERCIAL_BUILDING, DoctorsOfficeHouse.class, I18n.marktr((String)"doctor's office house")),
    OFFICE_BUILDING(OFFICE_COMMERCIAL_BUILDING, OfficeBuilding.class, I18n.marktr((String)"office building")),
    OFFICE_CENTER(OFFICE_COMMERCIAL_BUILDING, OfficeCenter.class, I18n.marktr((String)"office center")),
    OFFICE_COMMERCIAL_PREMISE(GENERAL_COMMERCIAL, OfficeCommercialPremise.class, I18n.marktr((String)"office / business premise")),
    OFFICE_SURGERY(GENERAL_COMMERCIAL, OfficeSurgery.class, I18n.marktr((String)"office / surgery")),
    OFFICE(OFFICE_SURGERY, Office.class, I18n.marktr((String)"office")),
    OFFICE_AREA(OFFICE_SURGERY, OfficeArea.class, I18n.marktr((String)"office area")),
    OFFICE_FLOOR(OFFICE_SURGERY, OfficeFloor.class, I18n.marktr((String)"office floor")),
    SURGERY(OFFICE_SURGERY, Surgery.class, I18n.marktr((String)"surgery")),
    SURGERY_AREA(OFFICE_SURGERY, SurgeryArea.class, I18n.marktr((String)"surgery area")),
    SURGERY_FLOOR(OFFICE_SURGERY, SurgeryFloor.class, I18n.marktr((String)"surgery floor")),
    PRODUCTION(GENERAL_COMMERCIAL, Production.class, I18n.marktr((String)"production")),
    INDUSTRIAL_FACILITY(PRODUCTION, IndustrialFacility.class, I18n.marktr((String)"industrial facility")),
    MANUFACTORING_AREA(PRODUCTION, ManufactoringArea.class, I18n.marktr((String)"manufacturing area")),
    RESIDENTIAL_COMMERCIAL_BUILDING(GENERAL_COMMERCIAL, ResidentialCommercialBuilding.class, I18n.marktr((String)"residential / commercial house")),
    RETAIL(GENERAL_COMMERCIAL, Retail.class, I18n.marktr((String)"retail")),
    CONSUMER_STORE(RETAIL, ConsumerStore.class, I18n.marktr((String)"consumer store")),
    DEPARTMENT_STORE(RETAIL, DepartmentStore.class, I18n.marktr((String)"department store")),
    EXHIBITION_AREA(RETAIL, ExhibitionArea.class, I18n.marktr((String)"exhibition area")),
    KIOSK(RETAIL, Kiosk.class, I18n.marktr((String)"kiosk")),
    PREMISE(RETAIL, Premise.class, I18n.marktr((String)"premise")),
    SALES_AREA(RETAIL, SalesArea.class, I18n.marktr((String)"sales area")),
    SELF_SERVICE_MARKET(RETAIL, SelfServiceMarket.class, I18n.marktr((String)"self-service market")),
    SHOP(RETAIL, Shop.class, I18n.marktr((String)"shop")),
    SHOPPING_CENTER(RETAIL, ShoppingCenter.class, I18n.marktr((String)"shopping center")),
    SHOWROOM(RETAIL, Showroom.class, I18n.marktr((String)"showroom")),
    STORE(RETAIL, Store.class, I18n.marktr((String)"store")),
    WAREHOUSE_STORE(RETAIL, WarehouseStore.class, I18n.marktr((String)"warehouse store")),
    SERVICE_AREA(GENERAL_COMMERCIAL, ServiceArea.class, I18n.marktr((String)"service area")),
    PETROL_STATION(SERVICE_AREA, PetrolStation.class, I18n.marktr((String)"petrol station")),
    SERVICE_CENTER(SERVICE_AREA, ServiceCenter.class, I18n.marktr((String)"service center")),
    WORKSHOP(SERVICE_AREA, Workshop.class, I18n.marktr((String)"workshop")),
    GENERAL_PARKING(null, GeneralParking.class, I18n.marktr((String)"parking")),
    CAR_PARK(GENERAL_PARKING, CarPark.class, I18n.marktr((String)"car park")),
    PARKING_SPACE(GENERAL_PARKING, ParkingSpace.class, I18n.marktr((String)"car parking space")),
    BERTH(PARKING_SPACE, Berth.class, I18n.marktr((String)"berth")),
    CARPORT(PARKING_SPACE, Carport.class, I18n.marktr((String)"carport")),
    CAR_PARK_UNIT(PARKING_SPACE, CarParkUnit.class, I18n.marktr((String)"unit within parking structure")),
    DOUBLE_GARAGE(PARKING_SPACE, DoubleGarage.class, I18n.marktr((String)"double garage")),
    DUPLEX_GARAGE(PARKING_SPACE, DuplexGarage.class, I18n.marktr((String)"duplex garage")),
    FREE_CAR_PARKING_SPACE(PARKING_SPACE, FreeCarParkingSpace.class, I18n.marktr((String)"free parking space")),
    GARAGE(PARKING_SPACE, Garage.class, I18n.marktr((String)"garage")),
    OUTDOOR_CAR_PARKING_SPACE(PARKING_SPACE, OutdoorCarParkingSpace.class, I18n.marktr((String)"outdoor car parking space")),
    UNDERGROUND_CAR_PARK_UNIT(PARKING_SPACE, UndergroundCarParkUnit.class, I18n.marktr((String)"unit within underground parking")),
    UNDERGROUND_CAR_PARK(GENERAL_PARKING, UndergroundCarPark.class, I18n.marktr((String)"underground car park")),
    GENERAL_PIECE_OF_LAND(null, GeneralPieceOfLand.class, I18n.marktr((String)"plot of land")),
    AGRICULTURAL_FORESTRY_GROUND(GENERAL_PIECE_OF_LAND, AgriculturalForestryGround.class, I18n.marktr((String)"agricultural / forestry ground")),
    COMMERCIAL_GROUND(GENERAL_PIECE_OF_LAND, CommercialGround.class, I18n.marktr((String)"commercial ground")),
    GARDEN_GROUND(GENERAL_PIECE_OF_LAND, GardenGround.class, I18n.marktr((String)"garden ground")),
    INDUSTRIAL_GROUND(GENERAL_PIECE_OF_LAND, IndustrialGround.class, I18n.marktr((String)"industrial ground")),
    LAKEFRONT_GROUND(GENERAL_PIECE_OF_LAND, LakefrontGround.class, I18n.marktr((String)"lakefront ground")),
    LEISURE_GROUND(GENERAL_PIECE_OF_LAND, LeisureGround.class, I18n.marktr((String)"leisure ground")),
    MIXED_USE_GROUND(GENERAL_PIECE_OF_LAND, MixedUseGround.class, I18n.marktr((String)"mixed-use ground")),
    RESIDENTIAL_GROUND(GENERAL_PIECE_OF_LAND, ResidentialGround.class, I18n.marktr((String)"residential ground")),
    SPECIAL_USE_GROUND(GENERAL_PIECE_OF_LAND, SpecialUseGround.class, I18n.marktr((String)"ground for special use")),
    GENERAL_RESIDENCE(null, GeneralResidence.class, I18n.marktr((String)"residential property")),
    APARTMENT_SHARE(GENERAL_RESIDENCE, ApartmentShare.class, I18n.marktr((String)"apartment- sharing community")),
    APARTMENT_SHARE_SENIORS(APARTMENT_SHARE, ApartmentShareSeniors.class, I18n.marktr((String)"seniors apartment share")),
    APARTMENT_SHARE_STUDENTS(APARTMENT_SHARE, ApartmentShareStudents.class, I18n.marktr((String)"students apartment share")),
    ASSISTED_LIVING(APARTMENT_SHARE, AssistedLiving.class, I18n.marktr((String)"assisted living")),
    HOUSE(GENERAL_RESIDENCE, House.class, I18n.marktr((String)"house")),
    COUNTRY_HOUSE(HOUSE, CountryHouse.class, I18n.marktr((String)"country house")),
    FARMHOUSE(COUNTRY_HOUSE, Farmhouse.class, I18n.marktr((String)"farmhouse")),
    FINCA(COUNTRY_HOUSE, Finca.class, I18n.marktr((String)"finca")),
    RUSTICO(COUNTRY_HOUSE, Rustico.class, I18n.marktr((String)"rustico")),
    DUPLEX_HOUSE(HOUSE, DuplexHouse.class, I18n.marktr((String)"duplex house")),
    LEISURE_HOME(HOUSE, LeisureHome.class, I18n.marktr((String)"leisure home")),
    ALPINE_HUT(LEISURE_HOME, AlpineHut.class, I18n.marktr((String)"alpine hut")),
    BEACH_HOUSE(LEISURE_HOME, BeachHouse.class, I18n.marktr((String)"beach house")),
    COTTAGE(LEISURE_HOME, Cottage.class, I18n.marktr((String)"cottage")),
    SUMMER_HOUSE(LEISURE_HOME, SummerHouse.class, I18n.marktr((String)"summer house")),
    MULTI_FAMILY_HOUSE(HOUSE, MultiFamilyHouse.class, I18n.marktr((String)"multi-family house")),
    MULTI_FAMILY_HOUSE_WITH_COMMERCIAL(MULTI_FAMILY_HOUSE, MultiFamilyHouseWithCommercial.class, I18n.marktr((String)"multi-family house with commercial")),
    TOWN_HOUSE(MULTI_FAMILY_HOUSE, TownHouse.class, I18n.marktr((String)"town house")),
    TWO_FAMILY_HOUSE(MULTI_FAMILY_HOUSE, TwoFamilyHouse.class, I18n.marktr((String)"two-family house")),
    SINGLE_FAMILY_HOUSE(HOUSE, SingleFamilyHouse.class, I18n.marktr((String)"single-family house")),
    BUNGALOW(SINGLE_FAMILY_HOUSE, Bungalow.class, I18n.marktr((String)"bungalow")),
    CHALET(SINGLE_FAMILY_HOUSE, Chalet.class, I18n.marktr((String)"chalet")),
    SEMIDETACHED_HOUSE(SINGLE_FAMILY_HOUSE, SemidetachedHouse.class, I18n.marktr((String)"semidetached house")),
    TERRACED_HOUSE(SINGLE_FAMILY_HOUSE, TerracedHouse.class, I18n.marktr((String)"terraced house")),
    TERRACED_HOUSE_CORNERSIDE(TERRACED_HOUSE, TerracedHouseCornerside.class, I18n.marktr((String)"terraced house (at corner)")),
    TERRACED_HOUSE_MIDDLE(TERRACED_HOUSE, TerracedHouseMiddle.class, I18n.marktr((String)"terraced house (at middle)")),
    TERRACED_HOUSE_TAIL(TERRACED_HOUSE, TerracedHouseTail.class, I18n.marktr((String)"terraced house (at tail)")),
    SPECIAL_HOUSE(HOUSE, SpecialHouse.class, I18n.marktr((String)"special house")),
    CASTLE(SPECIAL_HOUSE, Castle.class, I18n.marktr((String)"castle")),
    MANSION(SPECIAL_HOUSE, Mansion.class, I18n.marktr((String)"mansion")),
    PALACE(SPECIAL_HOUSE, Palace.class, I18n.marktr((String)"palace")),
    VILLA(SPECIAL_HOUSE, Villa.class, I18n.marktr((String)"villa")),
    RESIDENCE(GENERAL_RESIDENCE, Residence.class, I18n.marktr((String)"residence")),
    APARTMENT(RESIDENCE, Apartment.class, I18n.marktr((String)"apartment")),
    ATELIER(RESIDENCE, Atelier.class, I18n.marktr((String)"atelier")),
    ATTIC_APARTMENT(RESIDENCE, AtticApartment.class, I18n.marktr((String)"attic apartment")),
    ATTIC_UNDER_CONSTRUCTION(RESIDENCE, AtticUnderConstruction.class, I18n.marktr((String)"attic under construction")),
    GROUND_FLOOR_APARTMENT(RESIDENCE, GroundFloorApartment.class, I18n.marktr((String)"ground floor apartment")),
    HIGHER_FLOOR_APARTMENT(RESIDENCE, HigherFloorApartment.class, I18n.marktr((String)"apartment on higher floor")),
    LOFT(RESIDENCE, Loft.class, I18n.marktr((String)"loft")),
    MAISONETTE(RESIDENCE, Maisonette.class, I18n.marktr((String)"maisonette")),
    MEZZANINE(RESIDENCE, Mezzanine.class, I18n.marktr((String)"mezzanine")),
    ONE_ROOM_APARTMENT(RESIDENCE, OneRoomApartment.class, I18n.marktr((String)"one-room apartment")),
    PENTHOUSE_APARTMENT(RESIDENCE, PenthouseApartment.class, I18n.marktr((String)"penthouse apartment")),
    SOUTERRAIN_APARTMENT(RESIDENCE, SouterrainApartment.class, I18n.marktr((String)"souterrain apartment")),
    STUDIO(RESIDENCE, Studio.class, I18n.marktr((String)"studio")),
    TERRACE_APARTMENT(RESIDENCE, TerraceApartment.class, I18n.marktr((String)"terrace apartment")),
    ROOM(GENERAL_RESIDENCE, Room.class, I18n.marktr((String)"room")),
    ASSEMBLER_ROOM(ROOM, AssemblerRoom.class, I18n.marktr((String)"assembler room"));

    private static final Logger LOGGER;
    private final OpenEstateType parentType;
    private final Class implClass;
    private final String i18nKey;

    private OpenEstateType(OpenEstateType openEstateType, Class clazz, String string2) {
        this.parentType = openEstateType;
        this.implClass = clazz;
        this.i18nKey = string2;
    }

    public AbstractTypeImpl createImpl() {
        try {
            return (AbstractTypeImpl)this.implClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create implementation of type \"" + this.name() + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public OpenEstateType[] getChildTypes() {
        return this.getChildTypes(false);
    }

    public OpenEstateType[] getChildTypes(boolean bl) {
        ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
        this.loadChildren(arrayList, bl);
        return arrayList.toArray(new OpenEstateType[0]);
    }

    public OpenEstateType[] getParentPath() {
        ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
        this.loadParents(arrayList);
        return arrayList.toArray(new OpenEstateType[0]);
    }

    public OpenEstateType getParentType() {
        return this.parentType;
    }

    public static OpenEstateType[] getRootTypes() {
        ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
        for (OpenEstateType openEstateType : OpenEstateType.values()) {
            if (openEstateType.parentType != null) continue;
            arrayList.add(openEstateType);
        }
        return arrayList.toArray(new OpenEstateType[0]);
    }

    public String getTagName() {
        return OpenEstateUtils.makeCamelCase(this.name());
    }

    @Override
    public String getTranslation() {
        return this.getTranslation(null);
    }

    @Override
    public String getTranslation(Locale locale) {
        return OpenEstateUtils.getI18nString(this.i18nKey, locale);
    }

    public boolean hasChildTypes() {
        for (OpenEstateType openEstateType : OpenEstateType.values()) {
            if (openEstateType.parentType != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentType() {
        return this.parentType != null;
    }

    public boolean isRootType() {
        return this.parentType == null;
    }

    private void loadChildren(List<OpenEstateType> list, boolean bl) {
        for (OpenEstateType openEstateType : OpenEstateType.values()) {
            if (openEstateType.parentType != this) continue;
            list.add(openEstateType);
            if (!bl) continue;
            openEstateType.loadChildren(list, true);
        }
    }

    private void loadParents(List<OpenEstateType> list) {
        if (this.parentType != null) {
            this.parentType.loadParents(list);
        }
        list.add(this);
    }

    static {
        LOGGER = LoggerFactory.getLogger(OpenEstateType.class);
    }
}

