/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateTranslator;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenEstateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenEstateUtils.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/impl/resources/";
    public static final String OPENESTATE_ENCODING = "UTF-8";
    public static final String OPENESTATE_NAMESPACE = "http://www.openestate.org/1.0/";
    public static final String OPENESTATE_VERSION = "1.0";
    public static final Locale DEFAULT_LOCALE = Locale.GERMANY;
    private static final Properties oldNames = new Properties();
    private static String serializationLineBreak = null;
    private static boolean approximatedAttributes = true;

    private OpenEstateUtils() {
    }

    public static String appendTextToDescription(String string, String string2, String string3, int n, boolean bl) {
        int n2;
        string3 = string3 != null ? string3 : System.lineSeparator();
        string = StringUtils.trimToEmpty((String)string);
        int n3 = n2 = bl ? StringEscapeUtils.escapeXml11((String)string).length() : string.length();
        if (n > 0 && n2 > 0 && n2 > n) {
            String string4 = string = n > 3 ? StringUtils.abbreviate((String)string, (int)n) : string.substring(0, n);
        }
        if ((string2 = StringUtils.trimToNull((String)string2)) != null) {
            int n4;
            int n5 = n4 = bl ? StringEscapeUtils.escapeXml11((String)string).length() : string.length();
            if (n > 0) {
                int n6;
                int n7 = bl ? StringEscapeUtils.escapeXml11((String)string2).length() : string2.length();
                int n8 = bl ? StringEscapeUtils.escapeXml11((String)string3).length() : string3.length();
                int n9 = n6 = n4 > 0 ? n4 + n8 + n8 + n7 : n7;
                if (n6 > n) {
                    int n10 = n4 - n7;
                    string = n10 > 3 ? StringUtils.abbreviate((String)string, (int)n10) : string.substring(0, n10);
                }
            }
            string = n4 > 0 ? string + string3 + string3 + string2 : string2;
        }
        return StringUtils.trimToNull((String)string);
    }

    public static Locale buildLocale(String string) {
        if (string == null) {
            throw new NullPointerException("locale-code may not be null!");
        }
        String[] stringArray = string.split("_");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0].toLowerCase());
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0].toLowerCase(), stringArray[1].toUpperCase());
        }
        String string2 = string.substring(stringArray[0].length() + stringArray[1].length() + 2);
        if (string2.contains("#")) {
            string2 = string2.substring(0, string2.indexOf("#"));
        }
        return new Locale(stringArray[0].toLowerCase(), stringArray[1].toUpperCase(), string2);
    }

    public static String convertToIso2Country(String string) {
        for (String string2 : Locale.getISOCountries()) {
            Locale locale = new Locale(string2, string2);
            String string3 = null;
            try {
                string3 = locale.getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
            return locale.getCountry();
        }
        return null;
    }

    public static String convertToIso3Country(String string) {
        for (String string2 : Locale.getISOCountries()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            Locale locale = new Locale(string, string);
            try {
                return locale.getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Locale[] getAvailableLocales() {
        HashMap<String, Locale> hashMap = new HashMap<String, Locale>();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "translators");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            Locale locale;
            String[] stringArray = enumeration.nextElement().toString().split("\\.");
            if (stringArray.length < 2 || hashMap.containsKey((locale = OpenEstateUtils.buildLocale(stringArray[1])).toString())) continue;
            hashMap.put(locale.toString(), locale);
        }
        return hashMap.values().toArray(new Locale[0]);
    }

    public static EfficiencyCategory.Option getEnergyEfficiencyCategory(Number number, String string) {
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        if ("de".equalsIgnoreCase(string)) {
            if (d < 0.0) {
                return null;
            }
            if (d < 30.0) {
                return EfficiencyCategory.Option.A_PLUS;
            }
            if (d < 50.0) {
                return EfficiencyCategory.Option.A;
            }
            if (d < 75.0) {
                return EfficiencyCategory.Option.B;
            }
            if (d < 100.0) {
                return EfficiencyCategory.Option.C;
            }
            if (d < 130.0) {
                return EfficiencyCategory.Option.D;
            }
            if (d < 160.0) {
                return EfficiencyCategory.Option.E;
            }
            if (d < 200.0) {
                return EfficiencyCategory.Option.F;
            }
            if (d < 250.0) {
                return EfficiencyCategory.Option.G;
            }
            return EfficiencyCategory.Option.H;
        }
        if ("it".equalsIgnoreCase(string)) {
            if (d < 0.0) {
                return null;
            }
            if (d <= 15.0) {
                return EfficiencyCategory.Option.A_PLUS;
            }
            if (d <= 30.0) {
                return EfficiencyCategory.Option.A;
            }
            if (d <= 50.0) {
                return EfficiencyCategory.Option.B;
            }
            if (d <= 70.0) {
                return EfficiencyCategory.Option.C;
            }
            if (d <= 90.0) {
                return EfficiencyCategory.Option.D;
            }
            if (d <= 120.0) {
                return EfficiencyCategory.Option.E;
            }
            if (d <= 160.0) {
                return EfficiencyCategory.Option.F;
            }
            return EfficiencyCategory.Option.G;
        }
        return null;
    }

    public static ImageIcon getFlagIcon(Locale locale) {
        return OpenEstateUtils.getFlagIcon(locale.getLanguage());
    }

    public static ImageIcon getFlagIcon(String string) {
        try {
            URL uRL = OpenEstateUtils.class.getResource("/com/openindex/openestate/impl/resources/flags/" + string.toLowerCase() + ".png");
            return uRL != null ? new ImageIcon(uRL) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("could not load country-flag!");
            if (string != null) {
                LOGGER.warn("> code: " + string);
            }
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public static I18n getI18n() {
        return OpenEstateUtils.getI18n(null);
    }

    public static I18n getI18n(Locale locale) {
        return locale != null ? I18nFactory.getI18n(OpenEstateUtils.class, (Locale)locale) : I18nFactory.getI18n(OpenEstateUtils.class);
    }

    public static String getI18nString(String string) {
        return OpenEstateUtils.getI18nString(string, null);
    }

    public static String getI18nString(String string, Locale locale) {
        try {
            return OpenEstateUtils.getI18n(locale).getResources().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private static Properties getOldNames() {
        return oldNames;
    }

    private static String getNewAction(String string) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("ACTION." + string, null));
    }

    private static String getNewAttrib(String string) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("ATTRIBUTE." + string, null));
    }

    private static String getNewAttrib(String string, String string2) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("ATTRIBUTE." + string + "." + string2, null));
    }

    private static String getNewAttrib(String string, String string2, String string3) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("ATTRIBUTE." + string + "." + string2 + "." + string3, null));
    }

    private static String getNewGroupFor(String string, String string2) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("NEW_GROUP_FOR." + string + "." + string2, null));
    }

    private static String getNewEstate(String string) {
        return StringUtils.trimToNull((String)OpenEstateUtils.getOldNames().getProperty("ESTATE." + string, null));
    }

    public static OpenEstateAttrib getPrimaryAreaAttrib(OpenEstateType openEstateType) {
        AbstractTypeImpl abstractTypeImpl = openEstateType != null ? openEstateType.createImpl() : null;
        return abstractTypeImpl != null ? abstractTypeImpl.getPrimaryAreaAttrib() : null;
    }

    public static OpenEstateAttrib getPrimaryPriceAttrib(OpenEstateType openEstateType, OpenEstateAction openEstateAction) {
        AbstractTypeImpl abstractTypeImpl = openEstateType != null ? openEstateType.createImpl() : null;
        return abstractTypeImpl != null ? abstractTypeImpl.getPrimaryPriceAttrib(openEstateAction) : null;
    }

    public static String getSerializationLineBreak() {
        return serializationLineBreak;
    }

    public static BigDecimal getTotalRent(EstateImpl estateImpl) {
        BigDecimal bigDecimal = RentIncludingServiceCharges.getAsBigDecimal(estateImpl);
        if (bigDecimal != null) {
            return bigDecimal;
        }
        bigDecimal = RentExcludingServiceCharges.getAsBigDecimal(estateImpl);
        if (bigDecimal != null) {
            BigDecimal bigDecimal2;
            boolean bl;
            BigDecimal bigDecimal3 = bigDecimal;
            BigDecimal bigDecimal4 = ServiceCharges.getAsBigDecimal(estateImpl);
            if (bigDecimal4 != null) {
                bigDecimal3 = bigDecimal3.add(bigDecimal4);
            }
            if (!(bl = Boolean.TRUE.equals(ServiceChargesIncludingHeatingCosts.get(estateImpl))) && (bigDecimal2 = HeatingCosts.getAsBigDecimal(estateImpl)) != null) {
                bigDecimal3 = bigDecimal3.add(bigDecimal2);
            }
            return bigDecimal3;
        }
        return null;
    }

    public static DateFormat getXsdDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static DateFormat getXsdDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    }

    public static DateFormat getXsdTimeFormat() {
        return new SimpleDateFormat("hh:mm:ss");
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static synchronized boolean isApproximatedAttributes() {
        return approximatedAttributes;
    }

    public static Document loadDocument(Reader reader) throws DocumentException {
        SAXReader sAXReader = new SAXReader();
        return sAXReader.read(reader);
    }

    public static Document loadDocument(InputStream inputStream) throws DocumentException {
        SAXReader sAXReader = new SAXReader();
        return sAXReader.read(inputStream);
    }

    public static Document loadDocumentFromResource(String string) throws DocumentException {
        return OpenEstateUtils.loadDocument(OpenEstateUtils.class.getResourceAsStream(string));
    }

    public static Document loadDocumentFromXmlString(String string) throws DocumentException {
        return OpenEstateUtils.loadDocument(new StringReader(string));
    }

    public static Map<String, OpenEstateTranslator> loadTranslatorsByLanguage() throws IOException {
        Object object;
        Object object2;
        Properties properties = new Properties();
        Object object3 = OpenEstateUtils.class.getResourceAsStream("/com/openindex/openestate/impl/resources/translators.properties");
        TreeMap<String, OpenEstateTranslator> treeMap = null;
        try {
            properties.load((InputStream)object3);
        }
        catch (Throwable throwable) {
            treeMap = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (treeMap != null) {
                    try {
                        ((InputStream)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)treeMap)).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object3).close();
                }
            }
        }
        object3 = new TreeMap();
        treeMap = properties.propertyNames();
        while (treeMap.hasMoreElements()) {
            String string = (String)treeMap.nextElement();
            if (!string.startsWith("translator.")) continue;
            String[] object4 = string.split("\\.");
            object2 = object4[1].split("_");
            if (((String[])object2).length == 1) {
                object = new Locale(object2[0]);
            } else if (((String[])object2).length == 2) {
                object = new Locale(object2[0], object2[1]);
            } else if (((String[])object2).length > 2) {
                object = new Locale(object2[0], object2[1], object2[2]);
            } else {
                LOGGER.warn("cant load locale from key!");
                LOGGER.warn("> " + (String)string);
                continue;
            }
            object3.put(((Locale)object).toString(), object);
        }
        treeMap = new TreeMap<String, OpenEstateTranslator>();
        for (Map.Entry entry : object3.entrySet()) {
            object2 = (String)entry.getKey();
            object = properties.getProperty("translator." + (String)object2 + ".name");
            String string = properties.getProperty("translator." + (String)object2 + ".link");
            treeMap.put((String)object2, new OpenEstateTranslator((String)object, string, (Locale)entry.getValue()));
        }
        return treeMap;
    }

    public static OpenEstateAction lookupAction(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        try {
            return OpenEstateAction.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                string = OpenEstateUtils.getNewAction(string);
                return !StringUtils.isBlank((CharSequence)string) ? OpenEstateAction.valueOf(string) : null;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public static OpenEstateAttrib lookupAttrib(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            return null;
        }
        try {
            return OpenEstateAttrib.valueOf(string + "_" + string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3;
            String string4 = OpenEstateUtils.getNewGroupFor(string, string2);
            OpenEstateAttribGroup openEstateAttribGroup = OpenEstateUtils.lookupAttribGroup(string4 != null ? string4 : string);
            if (openEstateAttribGroup == null) {
                return null;
            }
            if (!string.equals(openEstateAttribGroup.name())) {
                try {
                    return OpenEstateAttrib.valueOf(openEstateAttribGroup.name() + "_" + string2);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    // empty catch block
                }
            }
            if (!StringUtils.isBlank((CharSequence)(string3 = OpenEstateUtils.getNewAttrib(openEstateAttribGroup.name(), string2))) && !string2.equals(string3)) {
                try {
                    return OpenEstateAttrib.valueOf(openEstateAttribGroup.name() + "_" + string3);
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Deprecated
    public static OpenEstateAttribGroup lookupAttrib(String string) {
        return OpenEstateUtils.lookupAttribGroup(string);
    }

    @Deprecated
    public static Enum lookupAttrib(String string, String string2, String string3) {
        return OpenEstateUtils.lookupAttribOption(string, string2, string3);
    }

    public static OpenEstateAttribGroup lookupAttribGroup(String string) {
        try {
            return !StringUtils.isBlank((CharSequence)string) ? OpenEstateAttribGroup.valueOf(string) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                string = OpenEstateUtils.getNewAttrib(string);
                return !StringUtils.isBlank((CharSequence)string) ? OpenEstateAttribGroup.valueOf(string) : null;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public static Enum lookupAttribOption(String string, String string2, String string3) {
        OpenEstateAttrib openEstateAttrib = OpenEstateUtils.lookupAttrib(string, string2);
        if (openEstateAttrib == null) {
            return null;
        }
        AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
        if (abstractAttribImpl instanceof SimpleEnumAttrib) {
            SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
            Object OptionType = simpleEnumAttrib.getOption(string3);
            if (OptionType != null) {
                return OptionType;
            }
            String string4 = OpenEstateUtils.getNewAttrib(openEstateAttrib.getGroupName(), openEstateAttrib.getAttribName(), string3);
            if (string4 != null && !string3.equals(string4) && (OptionType = simpleEnumAttrib.getOption(string4)) != null) {
                return OptionType;
            }
        } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
            Object OptionType = complexEnumAttrib.getOption(string3);
            if (OptionType != null) {
                return OptionType;
            }
            String string5 = OpenEstateUtils.getNewAttrib(openEstateAttrib.getGroupName(), openEstateAttrib.getAttribName(), string3);
            if (string5 != null && !string3.equals(string5) && (OptionType = complexEnumAttrib.getOption(string5)) != null) {
                return OptionType;
            }
        } else {
            LOGGER.warn("Attribute \"" + openEstateAttrib.name() + "\" is not an enumeration!");
        }
        return null;
    }

    public static OpenEstateType lookupEstate(String string) {
        try {
            return !StringUtils.isBlank((CharSequence)string) ? OpenEstateType.valueOf(string) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                string = OpenEstateUtils.getNewEstate(string);
                return !StringUtils.isBlank((CharSequence)string) ? OpenEstateType.valueOf(string) : null;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public static String makeCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("_")) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray = string.split("_")) {
                stringBuilder.append(OpenEstateUtils.makeCamelCase(string2));
            }
            return stringBuilder.toString();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String makeUnCamelCase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            if (i > 0 && !string2.toLowerCase().equals(string2)) {
                stringBuilder.append('_');
            }
            stringBuilder.append(string2.toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static Date parseDate(String string) throws ParseException {
        return !StringUtils.isBlank((CharSequence)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-D", "MM/yyyy", "MM-yyyy", "MMM yyyy", "MMMMM yyyy", "yyyy"}) : null;
    }

    public static Date parseDateTime(String string) throws ParseException {
        return !StringUtils.isBlank((CharSequence)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm"}) : null;
    }

    public static Number parseNumber(String string) {
        return OpenEstateUtils.parseNumber(string, NumberFormat.getInstance());
    }

    public static Number parseNumber(String string, NumberFormat numberFormat) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 == null) {
            return null;
        }
        Number number = null;
        try {
            String string3 = string2.contains(",") && !string2.contains(".") ? StringUtils.replace((String)string2, (String)",", (String)".") : string2;
            number = string3.contains(".") ? new BigDecimal(string3) : new BigInteger(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (number == null && numberFormat != null) {
            try {
                number = numberFormat.parse(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (number == null) {
            LOGGER.warn("Can't convert \"" + string + "\" to a numeric value!");
        }
        return number;
    }

    public static Date parseTime(String string) throws ParseException {
        return !StringUtils.isBlank((CharSequence)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"hh:mm:ss", "hh:mm"}) : null;
    }

    public static String parseString(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        string = StringEscapeUtils.unescapeHtml4((String)string);
        Pattern pattern = Pattern.compile("<br\\s*/?>", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return matcher.replaceAll("\n");
    }

    /*
     * Exception decompiling
     */
    public static String readResource(String var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String serializeString(String string) {
        return OpenEstateUtils.serializeString(string, OpenEstateUtils.getSerializationLineBreak());
    }

    public static String serializeString(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "<br/>";
        }
        Pattern pattern = Pattern.compile("^(.*)$", 8);
        Matcher matcher = pattern.matcher(string.trim());
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            stringBuilder.append(matcher.group());
            if (matcher.hitEnd()) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString().trim();
    }

    public static void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl) throws IOException, DocumentException {
        OpenEstateUtils.serializeToXML(serializableXmlElement, writer, bl, OPENESTATE_ENCODING, null);
    }

    public static void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl, String string) throws IOException, DocumentException {
        OpenEstateUtils.serializeToXML(serializableXmlElement, writer, bl, OPENESTATE_ENCODING, null);
    }

    public static synchronized void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl, String string, String string2) throws IOException, DocumentException {
        Document document = DocumentFactory.getInstance().createDocument(string);
        serializationLineBreak = string2 != null ? string2 : "<br/>";
        serializableXmlElement.serializeToXml(document);
        serializationLineBreak = null;
        OutputFormat outputFormat = bl ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        outputFormat.setEncoding(string);
        XMLWriter xMLWriter = new XMLWriter(writer, outputFormat);
        xMLWriter.write(document);
        xMLWriter.flush();
    }

    public static synchronized void setApproximatedAttributes(boolean bl) {
        approximatedAttributes = bl;
    }

    public static String toString(Object object) {
        return OpenEstateUtils.toString(object, "");
    }

    public static String toString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static String writeEnergyCertificate(EstateImpl estateImpl) {
        return OpenEstateUtils.writeEnergyCertificate(estateImpl, null, null);
    }

    public static String writeEnergyCertificate(EstateImpl estateImpl, Locale locale) {
        return OpenEstateUtils.writeEnergyCertificate(estateImpl, locale, null);
    }

    public static String writeEnergyCertificate(EstateImpl estateImpl, Locale locale, String string) {
        AbstractAttribImpl abstractAttribImpl;
        if (estateImpl == null) {
            return null;
        }
        AbstractTypeImpl abstractTypeImpl = estateImpl.getTypeSpec();
        if (abstractTypeImpl == null || !abstractTypeImpl.hasAttrib(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE)) {
            return null;
        }
        locale = locale != null ? locale : Locale.getDefault();
        string = string != null ? string : System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = Available.get(estateImpl);
        if (!Boolean.FALSE.equals(bl)) {
            for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.ENERGY_CERTIFICATE.getAttributes()) {
                if (OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE.equals(openEstateAttrib)) continue;
                abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
                OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, abstractAttribImpl, locale, string);
            }
        }
        if (stringBuilder.length() < 1) {
            stringBuilder.append(string);
            stringBuilder.append(OpenEstateConstant.NO_ENERGY_CERTIFICATE_AVAILABLE.getTranslation(locale));
        } else {
            abstractAttribImpl = estateImpl.getAttribute(OpenEstateAttrib.FEATURES_TYPE_OF_HEATING);
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, abstractAttribImpl, locale, string);
            abstractAttribImpl = estateImpl.getAttribute(OpenEstateAttrib.FEATURES_TYPE_OF_BEACONING);
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, abstractAttribImpl, locale, string);
            abstractAttribImpl = estateImpl.getAttribute(OpenEstateAttrib.CONDITION_BUILD_YEAR);
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, abstractAttribImpl, locale, string);
        }
        String string2 = StringUtils.trimToNull((String)OpenEstateAttribGroup.ENERGY_CERTIFICATE.getTranslation(locale));
        if (string2 != null) {
            stringBuilder.insert(0, StringUtils.upperCase((String)string2, (Locale)locale) + string);
        }
        return StringUtils.trimToNull((String)stringBuilder.toString());
    }

    private static void writeEstateEnergyCertificateValue(StringBuilder stringBuilder, AbstractAttribImpl abstractAttribImpl, Locale locale, String string) {
        if (abstractAttribImpl == null) {
            return;
        }
        stringBuilder.append(string);
        stringBuilder.append("- ");
        stringBuilder.append(abstractAttribImpl.getAttrib().getTranslation(locale));
        stringBuilder.append(": ");
        stringBuilder.append(abstractAttribImpl.getFormattedValue(locale));
    }

    public static String writeException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static {
        try (InputStream inputStream = OpenEstateUtils.class.getResourceAsStream("/com/openindex/openestate/impl/resources/oldnames.properties");){
            oldNames.load(inputStream);
        }
        catch (Exception exception) {
            LOGGER.error("Can't load old OpenEstate names!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

