/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchDateTimeImpl;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SearchMatchesImpl;
import com.openindex.openestate.impl.SearchNumericImpl;
import com.openindex.openestate.impl.SerializableXmlType;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAttribImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = -7952101296931415449L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchAttribImpl.class);
    private static final String XML_ATTRIB_NAME = "Name";
    private static final String XML_ATTRIB_GROUP = "Group";
    private static final String XML_ELEMENT_EQUALS = "Equals";
    private static final String XML_ELEMENT_MATCHES = "Matches";
    private static final String XML_ELEMENT_NUMERIC = "Numeric";
    private static final String XML_ELEMENT_DATETIME = "DateTime";
    private OpenEstateAttrib attribute;
    private SearchEqualsImpl equalsCondition;
    private SearchMatchesImpl matchesCondition;
    private SearchNumericImpl numericCondition;
    private SearchDateTimeImpl dateTimeCondition;
    private long order = 0L;

    public SearchAttribImpl() {
        this(null);
    }

    public SearchAttribImpl(String string, String string2) {
        this(OpenEstateUtils.lookupAttrib(string, string2));
    }

    public SearchAttribImpl(OpenEstateAttrib openEstateAttrib) {
        this.attribute = openEstateAttrib;
    }

    public OpenEstateAttrib getAttribute() {
        return this.attribute;
    }

    public SearchDateTimeImpl getDateTimeCondition() {
        return this.dateTimeCondition;
    }

    public SearchEqualsImpl getEqualsCondition() {
        return this.equalsCondition;
    }

    public SearchMatchesImpl getMatchesCondition() {
        return this.matchesCondition;
    }

    public SearchNumericImpl getNumericCondition() {
        return this.numericCondition;
    }

    public long getOrder() {
        return this.order;
    }

    public boolean isMatching(AbstractAttribImpl abstractAttribImpl) {
        if (this.attribute == null || abstractAttribImpl == null || abstractAttribImpl.hasEmptyValue()) {
            return true;
        }
        if (!this.attribute.equals(abstractAttribImpl.getAttrib())) {
            return false;
        }
        if (abstractAttribImpl instanceof ComplexAreaAttrib) {
            return this.isMatching(((ComplexAreaAttrib)abstractAttribImpl).getValue());
        }
        if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
            return this.isMatching(((ComplexCurrencyAttrib)abstractAttribImpl).getValue());
        }
        if (abstractAttribImpl instanceof ComplexEnumAttrib) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
            Object ObjectType = ((AbstractAttribImpl)complexEnumAttrib).getValue();
            if (!ArrayUtils.isEmpty(ObjectType)) {
                for (Object ObjectType2 : ObjectType) {
                    if (!this.isMatching(((Enum)ObjectType2).name())) continue;
                    return true;
                }
            }
        } else {
            if (abstractAttribImpl instanceof ComplexLengthAttrib) {
                return this.isMatching(((ComplexLengthAttrib)abstractAttribImpl).getValue());
            }
            if (abstractAttribImpl instanceof ComplexStringAttrib) {
                ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
                for (String string : complexStringAttrib.getValueLanguages()) {
                    String string2 = complexStringAttrib.getValue(string);
                    if (!this.isMatching(string2)) continue;
                    return true;
                }
            } else {
                if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
                    return this.isMatching(((ComplexVolumeAttrib)abstractAttribImpl).getValue());
                }
                if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                    return this.isMatching(((SimpleBooleanAttrib)abstractAttribImpl).getValue());
                }
                if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                    SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
                    Object object = simpleEnumAttrib.getValue();
                    if (object != null) {
                        return this.isMatching(((Enum)object).name());
                    }
                } else {
                    if (abstractAttribImpl instanceof SimpleNumericAttrib) {
                        return this.isMatching(((SimpleNumericAttrib)abstractAttribImpl).getValue());
                    }
                    if (abstractAttribImpl instanceof SimpleTimeAttrib) {
                        return this.isMatching(((SimpleTimeAttrib)abstractAttribImpl).getValue());
                    }
                    LOGGER.warn("Unsupported attribute value!");
                    LOGGER.warn("> class : " + abstractAttribImpl.getClass().getName());
                    LOGGER.warn("> value : " + OpenEstateUtils.toString(abstractAttribImpl.getValue(), "NULL"));
                }
            }
        }
        return false;
    }

    public boolean isMatching(Date date) {
        return this.dateTimeCondition == null || this.dateTimeCondition.isMatching(date);
    }

    public boolean isMatching(AreaValue areaValue) {
        return this.numericCondition == null || this.numericCondition.isMatching(areaValue);
    }

    public boolean isMatching(LengthValue lengthValue) {
        return this.numericCondition == null || this.numericCondition.isMatching(lengthValue);
    }

    public boolean isMatching(VolumeValue volumeValue) {
        return this.numericCondition == null || this.numericCondition.isMatching(volumeValue);
    }

    public boolean isMatching(Number number) {
        return this.numericCondition == null || this.numericCondition.isMatching(number);
    }

    public boolean isMatching(Boolean bl) {
        return bl == null || this.isMatching(bl.toString());
    }

    public boolean isMatching(String string) {
        if (this.equalsCondition == null && this.matchesCondition == null) {
            return true;
        }
        if (this.equalsCondition != null && this.equalsCondition.isMatching(string)) {
            return true;
        }
        return this.matchesCondition != null && this.matchesCondition.isMatching(string);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        String string;
        String string2 = SearchAttribImpl.selectAttribute(element, XML_ATTRIB_GROUP, null);
        OpenEstateAttrib openEstateAttrib = OpenEstateUtils.lookupAttrib(string2, string = SearchAttribImpl.selectAttribute(element, XML_ATTRIB_NAME, null));
        if (openEstateAttrib == null) {
            throw new DocumentException("Unknown attribute: " + string2 + " / " + string);
        }
        this.setAttribute(openEstateAttrib);
        this.setCondition(null);
        List<Node> list = SearchAttribImpl.selectChildElements(element);
        if (!list.isEmpty()) {
            Node node = list.get(0);
            if (XML_ELEMENT_DATETIME.equals(node.getName())) {
                SearchDateTimeImpl searchDateTimeImpl = new SearchDateTimeImpl();
                searchDateTimeImpl.readFromXml((Element)node);
                this.setDateTimeCondition(searchDateTimeImpl);
            } else if (XML_ELEMENT_EQUALS.equals(node.getName())) {
                SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
                searchEqualsImpl.readFromXml((Element)node);
                this.setEqualsCondition(searchEqualsImpl);
            } else if (XML_ELEMENT_MATCHES.equals(node.getName())) {
                SearchMatchesImpl searchMatchesImpl = new SearchMatchesImpl();
                searchMatchesImpl.readFromXml((Element)node);
                this.setMatchesCondition(searchMatchesImpl);
            } else if (XML_ELEMENT_NUMERIC.equals(node.getName())) {
                SearchNumericImpl searchNumericImpl = new SearchNumericImpl();
                searchNumericImpl.readFromXml((Element)node);
                this.setNumericCondition(searchNumericImpl);
            }
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (this.attribute != null) {
            element.addAttribute(XML_ATTRIB_GROUP, this.attribute.getGroup().name());
            element.addAttribute(XML_ATTRIB_NAME, this.attribute.name());
        }
        if (this.dateTimeCondition != null) {
            Element element2 = element.addElement(XML_ELEMENT_DATETIME);
            this.dateTimeCondition.serializeToXml(element2);
        } else if (this.equalsCondition != null) {
            Element element3 = element.addElement(XML_ELEMENT_EQUALS);
            this.equalsCondition.serializeToXml(element3);
        } else if (this.matchesCondition != null) {
            Element element4 = element.addElement(XML_ELEMENT_MATCHES);
            this.matchesCondition.serializeToXml(element4);
        } else if (this.numericCondition != null) {
            Element element5 = element.addElement(XML_ELEMENT_NUMERIC);
            this.numericCondition.serializeToXml(element5);
        }
    }

    public void setAttribute(OpenEstateAttrib openEstateAttrib) {
        this.attribute = openEstateAttrib;
    }

    public void setDateTimeCondition(SearchDateTimeImpl searchDateTimeImpl) {
        this.setCondition(searchDateTimeImpl);
    }

    public void setEqualsCondition(SearchEqualsImpl searchEqualsImpl) {
        this.setCondition(searchEqualsImpl);
    }

    public void setMatchesCondition(SearchMatchesImpl searchMatchesImpl) {
        this.setCondition(searchMatchesImpl);
    }

    public void setNumericCondition(SearchNumericImpl searchNumericImpl) {
        this.setCondition(searchNumericImpl);
    }

    private void setCondition(Object object) {
        this.dateTimeCondition = object instanceof SearchDateTimeImpl ? (SearchDateTimeImpl)object : null;
        this.equalsCondition = object instanceof SearchEqualsImpl ? (SearchEqualsImpl)object : null;
        this.matchesCondition = object instanceof SearchMatchesImpl ? (SearchMatchesImpl)object : null;
        this.numericCondition = object instanceof SearchNumericImpl ? (SearchNumericImpl)object : null;
    }

    public void setOrder(long l) {
        this.order = l;
    }
}

